/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.core.transformer;

import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public abstract class ClassNodeTransformer
implements IClassTransformer {
    protected String className;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals(this.className)) {
            System.out.println("Transforming class " + name + " " + transformedName);
            boolean isObfuscated = !name.equals(transformedName);
            return this.transform(basicClass, isObfuscated);
        }
        return basicClass;
    }

    private byte[] transform(byte[] basicClass, boolean isObfuscated) {
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        this.transformNode(classNode, isObfuscated);
        ClassWriter classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    protected void addGetter(ClassNode classNode, String fieldName, String fieldDesc) {
        List methods = classNode.methods;
        MethodNode getterNode = new MethodNode(1, "get" + (fieldName.charAt(0) + "").toUpperCase() + fieldName.substring(1), "()" + fieldDesc, null, null);
        LabelNode labelNode1 = new LabelNode();
        LabelNode labelNode2 = new LabelNode();
        InsnList instructions = getterNode.instructions;
        instructions.add((AbstractInsnNode)labelNode1);
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, fieldName, fieldDesc));
        instructions.add((AbstractInsnNode)new InsnNode(176));
        instructions.add((AbstractInsnNode)labelNode2);
        getterNode.localVariables.add(new LocalVariableNode("this", "L" + classNode.name + ";", null, labelNode1, labelNode2, 0));
        getterNode.maxStack = 1;
        getterNode.maxLocals = 1;
        methods.add(getterNode);
    }

    protected void addSetter(ClassNode classNode, String fieldName, String fieldDesc) {
        List methods = classNode.methods;
        MethodNode setterNode = new MethodNode(1, "set" + (fieldName.charAt(0) + "").toUpperCase() + fieldName.substring(1), "(" + fieldDesc + ")V", null, null);
        LabelNode labelNode1 = new LabelNode();
        LabelNode labelNode2 = new LabelNode();
        InsnList instructions = setterNode.instructions;
        instructions.add((AbstractInsnNode)labelNode1);
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, fieldName, fieldDesc));
        instructions.add((AbstractInsnNode)new InsnNode(177));
        instructions.add((AbstractInsnNode)labelNode2);
        setterNode.localVariables.add(new LocalVariableNode("this", "L" + classNode.name + ";", null, labelNode1, labelNode2, 0));
        setterNode.localVariables.add(new LocalVariableNode("value", fieldDesc, null, labelNode1, labelNode2, 1));
        setterNode.maxStack = 2;
        setterNode.maxLocals = 2;
        methods.add(setterNode);
    }

    protected abstract void transformNode(ClassNode var1, boolean var2);
}

