/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending;

import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class General {
    public static Random rand = new Random();
    static HashMap<String, Block> blockMapping;

    public static void propelTowards(Entity what, Entity whereTo, double force) {
        double dx = whereTo.field_70165_t - what.field_70165_t;
        double dy = whereTo.field_70163_u - what.field_70163_u;
        double dz = whereTo.field_70161_v - what.field_70161_v;
        double total = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (total == 0.0) {
            what.field_70159_w = 0.0;
            what.field_70181_x = 0.0;
            what.field_70179_y = 0.0;
        } else {
            what.field_70159_w = dx / total * force;
            what.field_70181_x = dy / total * force;
            what.field_70179_y = dz / total * force;
        }
    }

    public static boolean isInRange(double distance, double x1, double y1, double z1, double x2, double y2, double z2) {
        double x = x1 - x2;
        double y = y1 - y2;
        double z = z1 - z2;
        return x * x + y * y + z * z < distance * distance;
    }

    public static Item getItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return stack.func_77973_b();
    }

    public static Item getItem(int itemId) {
        Item item = (Item)GameData.getItemRegistry().func_148754_a(itemId);
        return item;
    }

    public static Integer getItemId(Item item) {
        return GameData.getItemRegistry().getId((Object)item);
    }

    public static String getUnlocalizedName(Block block) {
        String name = block.func_149739_a();
        if (name.startsWith("tile.")) {
            name = name.substring(5);
        }
        return name;
    }

    public static Block getBlock(String s, Block fallback) {
        Block res;
        Set blockReg = GameData.getBlockRegistry().func_148742_b();
        ArrayList blockList = new ArrayList();
        blockList.addAll(blockReg);
        String[] blockNames = blockList.toArray(new String[0]);
        if (blockMapping == null) {
            blockMapping = new HashMap();
            for (int i = 0; i < blockList.size(); ++i) {
                Block block = Block.func_149684_b((String)blockNames[i]);
                if (block == null) continue;
                String name = block.func_149739_a();
                if (name.startsWith("tile.")) {
                    name = name.substring(5);
                }
                blockMapping.put(name.toLowerCase(), block);
            }
        }
        if ((res = blockMapping.get(s.toLowerCase())) == null) {
            return fallback;
        }
        return res;
    }

    public static Block getBlock(String s) {
        return General.getBlock(s, Blocks.field_150348_b);
    }

    public static String getName(Block block) {
        String res = block.func_149739_a();
        return res.substring(5);
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayer(World par1World, EntityPlayer par2EntityPlayer, boolean par3) {
        float var4 = 1.0f;
        float var5 = par2EntityPlayer.field_70127_C + (par2EntityPlayer.field_70125_A - par2EntityPlayer.field_70127_C) * var4;
        float var6 = par2EntityPlayer.field_70126_B + (par2EntityPlayer.field_70177_z - par2EntityPlayer.field_70126_B) * var4;
        double var7 = par2EntityPlayer.field_70169_q + (par2EntityPlayer.field_70165_t - par2EntityPlayer.field_70169_q) * (double)var4;
        double var9 = par2EntityPlayer.field_70167_r + (par2EntityPlayer.field_70163_u - par2EntityPlayer.field_70167_r) * (double)var4 + 1.62 - (double)par2EntityPlayer.field_70129_M;
        double var11 = par2EntityPlayer.field_70166_s + (par2EntityPlayer.field_70161_v - par2EntityPlayer.field_70166_s) * (double)var4;
        Vec3 var13 = Vec3.func_72443_a((double)var7, (double)var9, (double)var11);
        float var14 = MathHelper.func_76134_b((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var15 = MathHelper.func_76126_a((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var16 = -MathHelper.func_76134_b((float)(-var5 * ((float)Math.PI / 180)));
        float var17 = MathHelper.func_76126_a((float)(-var5 * ((float)Math.PI / 180)));
        float var18 = var15 * var16;
        float var20 = var14 * var16;
        double var21 = 5.0;
        if (par2EntityPlayer instanceof EntityPlayerMP) {
            var21 = ((EntityPlayerMP)par2EntityPlayer).field_71134_c.getBlockReachDistance();
        }
        Vec3 var23 = var13.func_72441_c((double)var18 * var21, (double)var17 * var21, (double)var20 * var21);
        return par1World.func_72901_a(var13, var23, par3);
    }

    public static int countNotNull(ItemStack[] itemStacks) {
        int counter = 0;
        for (ItemStack itemStack : itemStacks) {
            if (itemStack == null) continue;
            ++counter;
        }
        return counter;
    }

    public static ItemStack getNotNull(ItemStack[] itemStacks, int num) {
        int counter = -1;
        for (ItemStack itemStack : itemStacks) {
            if (itemStack != null) {
                ++counter;
            }
            if (counter != num) continue;
            return itemStack;
        }
        return null;
    }
}

