/*
 * Decompiled with CFR 0.152.
 */
package two.graves.util;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public enum BlockSide {
    BOTTOM,
    TOP,
    NORTH,
    SOUTH,
    WEST,
    EAST;

    public static final int ROTATION_MASK = 12;
    public static final int DATA_MASK = 3;

    public ForgeDirection behind() {
        switch (this) {
            case BOTTOM: {
                return ForgeDirection.UP;
            }
            case TOP: {
                return ForgeDirection.DOWN;
            }
            case NORTH: {
                return ForgeDirection.SOUTH;
            }
            case SOUTH: {
                return ForgeDirection.NORTH;
            }
            case WEST: {
                return ForgeDirection.EAST;
            }
            case EAST: {
                return ForgeDirection.WEST;
            }
        }
        throw new IllegalStateException("Illegal side for behind: " + this.name());
    }

    public BlockSide backSide() {
        switch (this) {
            case BOTTOM: {
                return TOP;
            }
            case TOP: {
                return BOTTOM;
            }
            case NORTH: {
                return SOUTH;
            }
            case SOUTH: {
                return NORTH;
            }
            case WEST: {
                return EAST;
            }
            case EAST: {
                return WEST;
            }
        }
        throw new IllegalStateException("Illegal side for backSide: " + this.name());
    }

    public ForgeDirection infront() {
        switch (this) {
            case BOTTOM: {
                return ForgeDirection.DOWN;
            }
            case TOP: {
                return ForgeDirection.UP;
            }
            case NORTH: {
                return ForgeDirection.NORTH;
            }
            case SOUTH: {
                return ForgeDirection.SOUTH;
            }
            case WEST: {
                return ForgeDirection.WEST;
            }
            case EAST: {
                return ForgeDirection.EAST;
            }
        }
        throw new IllegalStateException("Illegal side for infront: " + this.name());
    }

    public ForgeDirection left() {
        switch (this) {
            case NORTH: {
                return ForgeDirection.WEST;
            }
            case SOUTH: {
                return ForgeDirection.EAST;
            }
            case WEST: {
                return ForgeDirection.NORTH;
            }
            case EAST: {
                return ForgeDirection.SOUTH;
            }
        }
        throw new IllegalStateException("Illegal side for left: " + this.name());
    }

    public BlockSide leftSide() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case SOUTH: {
                return EAST;
            }
            case WEST: {
                return NORTH;
            }
            case EAST: {
                return SOUTH;
            }
        }
        throw new IllegalStateException("Illegal side for leftSide: " + this.name());
    }

    public ForgeDirection right() {
        switch (this) {
            case NORTH: {
                return ForgeDirection.EAST;
            }
            case SOUTH: {
                return ForgeDirection.WEST;
            }
            case WEST: {
                return ForgeDirection.SOUTH;
            }
            case EAST: {
                return ForgeDirection.NORTH;
            }
        }
        throw new IllegalStateException("Illegal side for right: " + this.name());
    }

    public BlockSide rightSide() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case SOUTH: {
                return WEST;
            }
            case WEST: {
                return SOUTH;
            }
            case EAST: {
                return NORTH;
            }
        }
        throw new IllegalStateException("Illegal side for rightSide: " + this.name());
    }

    public static int getLookDirection(EntityLivingBase entity) {
        return MathHelper.func_76128_c((double)((double)(entity.field_70177_z + 360.0f - 45.0f + 180.0f) / 90.0)) & 3;
    }

    public static BlockSide getLookSide(EntityLivingBase entity) {
        return BlockSide.fromDirection(BlockSide.getLookDirection(entity));
    }

    public static int getDirectionFacing(EntityLivingBase entity) {
        return MathHelper.func_76128_c((double)((double)(entity.field_70177_z + 360.0f - 45.0f + 180.0f) / 90.0)) & 3;
    }

    public static BlockSide getSideFacing(EntityLivingBase entity) {
        return BlockSide.fromDirection(BlockSide.getDirectionFacing(entity));
    }

    public static int createRotationData(int direction) {
        return (direction & 3) << 2;
    }

    public static int createRotationData(BlockSide direction) {
        return BlockSide.createRotationData(direction.direction());
    }

    public int direction() {
        switch (this) {
            case WEST: {
                return 0;
            }
            case NORTH: {
                return 1;
            }
            case EAST: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
        }
        throw new IllegalArgumentException("No direction for " + (Object)((Object)this));
    }

    public static int getRotationData(int metadata) {
        return metadata & 0xC;
    }

    public static int getDirectionFrom(int metadata) {
        return (metadata & 0xC) >>> 2;
    }

    public static BlockSide getRotatedSide(int side, int metadata) {
        switch (side) {
            case 0: {
                return BOTTOM;
            }
            case 1: {
                return TOP;
            }
            case 2: {
                switch (BlockSide.getDirectionFrom(metadata)) {
                    case 0: {
                        return EAST;
                    }
                    case 1: {
                        return NORTH;
                    }
                    case 2: {
                        return WEST;
                    }
                    case 3: {
                        return SOUTH;
                    }
                }
            }
            case 3: {
                switch (BlockSide.getDirectionFrom(metadata)) {
                    case 0: {
                        return WEST;
                    }
                    case 1: {
                        return SOUTH;
                    }
                    case 2: {
                        return EAST;
                    }
                    case 3: {
                        return NORTH;
                    }
                }
            }
            case 4: {
                switch (BlockSide.getDirectionFrom(metadata)) {
                    case 0: {
                        return NORTH;
                    }
                    case 1: {
                        return WEST;
                    }
                    case 2: {
                        return SOUTH;
                    }
                    case 3: {
                        return EAST;
                    }
                }
            }
            case 5: {
                switch (BlockSide.getDirectionFrom(metadata)) {
                    case 0: {
                        return SOUTH;
                    }
                    case 1: {
                        return EAST;
                    }
                    case 2: {
                        return NORTH;
                    }
                    case 3: {
                        return WEST;
                    }
                }
            }
        }
        throw new IllegalArgumentException("Illegal side " + side);
    }

    public static BlockSide getSide(int side) {
        return BlockSide.getRotatedSide(side, 0);
    }

    public static BlockSide fromMetadata(int metadata) {
        return BlockSide.fromDirection(BlockSide.getDirectionFrom(metadata));
    }

    public static BlockSide fromDirection(int direction) {
        switch (direction & 3) {
            case 0: {
                return WEST;
            }
            case 1: {
                return NORTH;
            }
            case 2: {
                return EAST;
            }
            case 3: {
                return SOUTH;
            }
        }
        throw new IllegalArgumentException("Illegal direction " + direction);
    }

    public static int getBlockDataFromMetadata(int metadata) {
        return metadata & 3;
    }

    public static int updateState(int metaCurrent, int state) {
        return metaCurrent & 0xC | state & 3;
    }

    public static int createState(int rotationData, int state) {
        return BlockSide.createRotationData(rotationData) | state & 3;
    }

    public static int createState(BlockSide blockFacing, int state) {
        return BlockSide.createState(blockFacing.direction(), state);
    }
}

