/*
 * Decompiled with CFR 0.152.
 */
package two.graves.network;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Deque;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.logging.log4j.Level;
import two.graves.API.InventoryContent;
import two.graves.network.ForceEquipMessageHandlerBase;
import two.graves.tiles.TileGrave;

public class PacketForceEquipItems
extends ForceEquipMessageHandlerBase
implements IMessage {
    protected final Deque<InventoryContent> inventoryContent;

    public PacketForceEquipItems(Deque<InventoryContent> inventoryContent) {
        this.inventoryContent = inventoryContent == null ? new LinkedList<InventoryContent>() : new LinkedList<InventoryContent>(inventoryContent);
    }

    public PacketForceEquipItems() {
        this(null);
    }

    public void fromBytes(ByteBuf buf) {
        int count = buf.readInt();
        while (count-- > 0) {
            try {
                InventoryContent content = InventoryContent.fromBytes(buf);
                this.inventoryContent.add(content);
            }
            catch (Exception e) {
                FMLLog.log((String)"TwoGraves", (Level)Level.ERROR, (Throwable)e, (String)"Unable to read Grave content properly", (Object[])new Object[0]);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.inventoryContent.size());
        for (InventoryContent content : this.inventoryContent) {
            try {
                content.toBytes(buf);
            }
            catch (Exception e) {
                FMLLog.log((String)"TwoGraves", (Level)Level.ERROR, (Throwable)e, (String)"Unable to package Grave content %s", (Object[])new Object[]{content.toString()});
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public PacketForceEquipItems onMessage(PacketForceEquipItems message, MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            TileGrave.giveItemsToPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g, message.inventoryContent, false);
            return null;
        }
        throw new IllegalStateException("Received " + PacketForceEquipItems.class.getSimpleName() + " for " + ctx.side.toString());
    }
}

