/*
 * Decompiled with CFR 0.152.
 */
package two.graves.blocks;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import two.graves.Graves;
import two.graves.GravesAssets;
import two.graves.blocks.BlockBase;
import two.graves.tiles.TileGrave;

public class BlockGrave
extends BlockBase
implements ITileEntityProvider {
    protected static final float PIXEL_SIZE = 0.0625f;
    public static final String NAME = "grave";
    protected static final Class<TileGrave> tileEntityClass = TileGrave.class;
    protected IIcon textureFront;
    protected IIcon textureSides;

    public BlockGrave() {
        super(Material.field_151576_e);
        GameRegistry.registerTileEntity(tileEntityClass, (String)tileEntityClass.getName());
    }

    @Override
    public void initialize() {
        this.setBaseValues(NAME, null, field_149769_e, 3.0f, "axe", 1);
        this.func_149752_b(6000.0f);
        if (!GravesAssets.playerCanDestroyGave) {
            this.func_149722_s();
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntityClass.isInstance(tileEntity)) {
                tileEntityClass.cast(tileEntity).giveItemsToPlayer(player);
            } else {
                FMLLog.log((String)"TwoGraves", (Level)Level.ERROR, (String)"Grave TileEntity expected %s, but found %s", (Object[])new Object[]{tileEntityClass.getName(), tileEntity == null ? "null" : tileEntity.getClass().getName()});
            }
        }
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntityClass.isInstance(tileEntity)) {
            tileEntityClass.cast(tileEntity).spillOutInventory();
        } else {
            FMLLog.log((String)"TwoGraves", (Level)Level.ERROR, (String)"Grave TileEntity expected %s, but found %s", (Object[])new Object[]{tileEntityClass.getName(), tileEntity == null ? "null" : tileEntity.getClass().getName()});
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntityClass.isInstance(tileEntity)) {
            tileEntityClass.cast(tileEntity).spillOutInventory();
        } else {
            FMLLog.log((String)"TwoGraves", (Level)Level.ERROR, (String)"Grave TileEntity expected %s, but found %s", (Object[])new Object[]{tileEntityClass.getName(), tileEntity == null ? "null" : tileEntity.getClass().getName()});
        }
    }

    public TileEntity func_149915_a(World world, int i) {
        try {
            return tileEntityClass.newInstance();
        }
        catch (Exception ex) {
            FMLLog.log((String)"TwoGraves", (Level)Level.ERROR, (Throwable)ex, (String)"Creation of %s failed!", (Object[])new Object[]{tileEntityClass.getName()});
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.textureFront = iconRegister.func_94245_a(Graves.getTextureName("grave_front"));
        this.textureSides = iconRegister.func_94245_a(Graves.getTextureName("grave_sides"));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return side == 2 ? this.textureFront : this.textureSides;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB boundingBox, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, boundingBox, list, entity);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.func_149676_a(0.125f, 0.0f, 0.8125f, 0.875f, 0.875f, 0.9375f);
    }

    public void func_149683_g() {
        this.func_149676_a(0.375f, 0.0f, 0.0f, 0.625f, 1.0f, 1.0f);
    }

    public boolean func_149662_c() {
        return false;
    }
}

