/*
 * Decompiled with CFR 0.152.
 */
package two.graves.API;

import cpw.mods.fml.common.FMLLog;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Level;
import two.graves.API.IInventoryHandler;
import two.graves.API.InventoryHandlerVanilla;

public class InventoryHandlerRegistry {
    protected static final ConcurrentHashMap<String, IInventoryHandler> inventoryHandlers = new ConcurrentHashMap();
    public static final String INVENTORY_HANDLER_ID_VANILLA = "";

    public static boolean registerHandler(IInventoryHandler handler) {
        if (handler.getID() == null || handler.getID().isEmpty()) {
            throw new IllegalArgumentException("HandlerID cannot be null or empty");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        if (inventoryHandlers.putIfAbsent(handler.getID(), handler) == null) {
            FMLLog.log((String)"TwoGraves", (Level)Level.INFO, (String)"Added Grave handler for %s", (Object[])new Object[]{handler.getID()});
            return true;
        }
        return false;
    }

    public static Collection<IInventoryHandler> getAllHandlers() {
        return inventoryHandlers.values();
    }

    public static IInventoryHandler getHandlerForID(String handlerID) {
        return inventoryHandlers.get(handlerID);
    }

    public static boolean isHandlerRegistered(String handlerID) {
        return inventoryHandlers.containsKey(handlerID);
    }

    static {
        inventoryHandlers.put(INVENTORY_HANDLER_ID_VANILLA, new InventoryHandlerVanilla());
    }
}

