/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.ee3;

import cofh.api.modhelpers.EE3Helper;
import cofh.asm.relauncher.Strippable;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.item.TEAugments;
import cofh.thermalexpansion.plugins.nei.handlers.NEIRecipeWrapper;
import cofh.thermalexpansion.util.crafting.ChargerManager;
import cofh.thermalexpansion.util.crafting.CrucibleManager;
import cofh.thermalexpansion.util.crafting.FurnaceManager;
import cofh.thermalexpansion.util.crafting.InsolatorManager;
import cofh.thermalexpansion.util.crafting.PulverizerManager;
import cofh.thermalexpansion.util.crafting.SawmillManager;
import cofh.thermalexpansion.util.crafting.SmelterManager;
import cofh.thermalexpansion.util.crafting.TransposerManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class EE3Plugin {
    private static int MAX_SECONDARY_MOD = 100;

    public static void preInit() {
    }

    public static void initialize() {
    }

    public static void postInit() {
    }

    /*
     * WARNING - void declaration
     */
    @Strippable(value={"mod:EE3"})
    public static void loadComplete() throws Throwable {
        for (ChargerManager.RecipeCharger objectArray : ChargerManager.getRecipeList()) {
            EE3Helper.addRecipe((Object)objectArray.getOutput(), (Object[])new Object[]{objectArray.getInput()});
        }
        for (CrucibleManager.RecipeCrucible recipeCrucible : CrucibleManager.getRecipeList()) {
            EE3Helper.addRecipe((Object)recipeCrucible.getOutput(), (Object[])new Object[]{recipeCrucible.getInput()});
        }
        for (FurnaceManager.RecipeFurnace recipeFurnace : FurnaceManager.getRecipeList()) {
            EE3Helper.addRecipe((Object)recipeFurnace.getOutput(), (Object[])new Object[]{recipeFurnace.getInput()});
        }
        for (InsolatorManager.RecipeInsolator recipeInsolator : InsolatorManager.getRecipeList()) {
            EE3Plugin.addTE3Machine(recipeInsolator.getPrimaryOutput(), recipeInsolator.getSecondaryOutput(), recipeInsolator.getSecondaryOutputChance(), recipeInsolator.getPrimaryInput(), recipeInsolator.getSecondaryInput());
        }
        for (PulverizerManager.RecipePulverizer recipePulverizer : PulverizerManager.getRecipeList()) {
            EE3Plugin.addTE3Machine(recipePulverizer.getPrimaryOutput(), recipePulverizer.getSecondaryOutput(), recipePulverizer.getSecondaryOutputChance(), recipePulverizer.getInput());
        }
        for (SawmillManager.RecipeSawmill recipeSawmill : SawmillManager.getRecipeList()) {
            EE3Plugin.addTE3Machine(recipeSawmill.getPrimaryOutput(), recipeSawmill.getSecondaryOutput(), recipeSawmill.getSecondaryOutputChance(), recipeSawmill.getInput());
        }
        for (SmelterManager.RecipeSmelter recipeSmelter : SmelterManager.getRecipeList()) {
            EE3Plugin.addTE3Machine(recipeSmelter.getPrimaryOutput(), recipeSmelter.getSecondaryOutput(), recipeSmelter.getSecondaryOutputChance(), recipeSmelter.getPrimaryInput(), recipeSmelter.getSecondaryInput());
        }
        for (TransposerManager.RecipeTransposer recipeTransposer : TransposerManager.getFillRecipeList()) {
            EE3Helper.addRecipe((Object)recipeTransposer.getOutput(), (Object[])new Object[]{recipeTransposer.getInput(), recipeTransposer.getFluid()});
        }
        for (TransposerManager.RecipeTransposer recipeTransposer : TransposerManager.getExtractionRecipeList()) {
            EE3Helper.addRecipe((Object)recipeTransposer.getFluid(), (Object[])new Object[]{recipeTransposer.getInput()});
            EE3Helper.addRecipe((Object)recipeTransposer.getOutput(), (Object[])new Object[]{recipeTransposer.getInput()});
        }
        for (IRecipe iRecipe : NEIRecipeWrapper.originalRecipeList) {
            void var3_27;
            ShapedRecipes shapedRecipes;
            ItemStack itemStack = iRecipe.func_77571_b();
            if (itemStack == null) continue;
            if (iRecipe instanceof ShapedRecipes) {
                shapedRecipes = (ShapedRecipes)iRecipe;
                ItemStack[] itemStackArray = shapedRecipes.field_77574_d;
            } else if (iRecipe instanceof ShapelessRecipes) {
                shapedRecipes = (ShapelessRecipes)iRecipe;
                Object[] objectArray = shapedRecipes.field_77579_b.toArray();
            } else if (iRecipe instanceof ShapedOreRecipe) {
                shapedRecipes = (ShapedOreRecipe)iRecipe;
                Object[] objectArray = shapedRecipes.getInput();
            } else {
                if (!(iRecipe instanceof ShapelessOreRecipe)) continue;
                shapedRecipes = (ShapelessOreRecipe)iRecipe;
                Object[] objectArray = shapedRecipes.getInput().toArray();
            }
            EE3Helper.addRecipe((Object)itemStack, (Object[])var3_27);
        }
        ThermalExpansion.log.info("Thermal Expansion: Equivalent Exchange 3 Plugin Enabled.");
    }

    public static void addTE3Machine(ItemStack itemStack, ItemStack itemStack2, int n, ItemStack ... itemStackArray) throws Throwable {
        if (itemStack2 == null) {
            EE3Helper.addRecipe((Object)itemStack, (Object[])itemStackArray);
        } else if (ItemHelper.itemsEqualWithMetadata((ItemStack)itemStack, (ItemStack)itemStack2)) {
            double d = (double)itemStack.field_77994_a + (double)itemStack2.field_77994_a * EE3Plugin.getTE3Prob(n);
            EE3Helper.addProbabilisticRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)itemStack, (int)1), (double)d, (ItemStack[])itemStackArray);
        } else {
            EE3Helper.addRecipe((Object)itemStack, (Object[])itemStackArray);
            EE3Helper.addProbabilisticRecipe((ItemStack)itemStack2, (double)EE3Plugin.getTE3Prob(n), (ItemStack[])itemStackArray);
        }
    }

    public static double getTE3Prob(int n) {
        return n > MAX_SECONDARY_MOD ? 1.0 : (double)n / (double)MAX_SECONDARY_MOD;
    }

    static {
        for (int n : TEAugments.MACHINE_SECONDARY_MOD) {
            MAX_SECONDARY_MOD -= n;
        }
    }
}

