/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.plugins;

import cofh.core.CoFHProps;
import cofh.thermaldynamics.ThermalDynamics;
import java.util.ArrayList;

public class TDPlugins {
    public static ArrayList<Plugin> pluginList = new ArrayList();

    public static void preInit() {
        ThermalDynamics.log.info("Loading Plugins...");
        for (int i = 0; i < pluginList.size(); ++i) {
            pluginList.get(i).preInit();
        }
        ThermalDynamics.log.info("Finished Loading Plugins.");
    }

    public static void initialize() {
        for (int i = 0; i < pluginList.size(); ++i) {
            pluginList.get(i).initialize();
        }
    }

    public static void postInit() {
        for (int i = 0; i < pluginList.size(); ++i) {
            pluginList.get(i).postInit();
        }
    }

    public static void loadComplete() {
        for (int i = 0; i < pluginList.size(); ++i) {
            pluginList.get(i).loadComplete();
        }
    }

    public static void cleanUp() {
        pluginList.clear();
    }

    public static boolean addPlugin(String string, String string2) {
        boolean bl = ThermalDynamics.config.get("Plugins." + string2, "Enable", true);
        ThermalDynamics.config.save();
        if (bl) {
            pluginList.add(new Plugin(string));
            return true;
        }
        return false;
    }

    static {
        TDPlugins.addPlugin("thaumcraft.ThaumcraftPlugin", "Thaumcraft");
    }

    static class Plugin {
        public Class<?> pluginClass = null;
        public String pluginPath;

        public Plugin(String string) {
            this.pluginPath = TDPlugins.class.getName().replace("TDPlugins", "") + string;
        }

        public void preInit() {
            block2: {
                try {
                    this.pluginClass = TDPlugins.class.getClassLoader().loadClass(this.pluginPath);
                    this.pluginClass.getMethod("preInit", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable throwable) {
                    if (!CoFHProps.enableDebugOutput) break block2;
                    throwable.printStackTrace();
                }
            }
        }

        public void initialize() {
            block3: {
                try {
                    if (this.pluginClass != null) {
                        this.pluginClass.getMethod("initialize", new Class[0]).invoke(null, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    if (!CoFHProps.enableDebugOutput) break block3;
                    throwable.printStackTrace();
                }
            }
        }

        public void postInit() {
            block3: {
                try {
                    if (this.pluginClass != null) {
                        this.pluginClass.getMethod("postInit", new Class[0]).invoke(null, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    if (!CoFHProps.enableDebugOutput) break block3;
                    throwable.printStackTrace();
                }
            }
        }

        public void loadComplete() {
            block3: {
                try {
                    if (this.pluginClass != null) {
                        this.pluginClass.getMethod("loadComplete", new Class[0]).invoke(null, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    if (!CoFHProps.enableDebugOutput) break block3;
                    throwable.printStackTrace();
                }
            }
        }

        public void registerRenderInformation() {
            block3: {
                try {
                    if (this.pluginClass != null) {
                        this.pluginClass.getMethod("registerRenderInformation", new Class[0]).invoke(null, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    if (!CoFHProps.enableDebugOutput) break block3;
                    throwable.printStackTrace();
                }
            }
        }
    }
}

