/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct;

import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.debughelper.DebugHelper;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.DuctFactory;
import cofh.thermaldynamics.duct.DuctItem;
import cofh.thermaldynamics.duct.DuctTransport;
import cofh.thermaldynamics.duct.light.DuctLight;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TDDucts {
    public static ArrayList<Duct> ductList = new ArrayList();
    public static ArrayList<Duct> ductListSorted = null;
    public static int OFFSET_ENERGY = 0;
    public static int OFFSET_FLUID = 16;
    public static int OFFSET_ITEM = 32;
    public static int OFFSET_STRUCTURE = 48;
    public static int OFFSET_TRANSPORT = 64;
    public static Duct energyBasic;
    public static Duct energyHardened;
    public static Duct energyReinforced;
    public static Duct energyReinforcedEmpty;
    public static Duct energyResonant;
    public static Duct energyResonantEmpty;
    public static Duct energySuperCond;
    public static Duct energySuperCondEmpty;
    public static Duct fluidBasic;
    public static Duct fluidBasicOpaque;
    public static Duct fluidHardened;
    public static Duct fluidHardenedOpaque;
    public static Duct fluidFlux;
    public static Duct fluidFluxOpaque;
    public static Duct fluidSuper;
    public static Duct fluidSuperOpaque;
    public static DuctItem itemBasic;
    public static DuctItem itemBasicOpaque;
    public static DuctItem itemFast;
    public static DuctItem itemFastOpaque;
    public static DuctItem itemEnder;
    public static DuctItem itemEnderOpaque;
    public static DuctItem itemEnergy;
    public static DuctItem itemEnergyOpaque;
    public static DuctTransport transportBasic;
    public static DuctTransport transportLongRange;
    public static DuctTransport transportCrossover;
    public static DuctTransport transportFrame;
    public static Duct structure;
    public static DuctLight lightDuct;
    public static Duct structureInvis;
    public static Duct placeholder;

    private TDDucts() {
    }

    static Duct addDuct(int n, boolean bl, int n2, int n3, String string, Duct.Type type, DuctFactory ductFactory, String string2, String string3, String string4, int n4, String string5, String string6, int n5) {
        Duct duct = new Duct(n, bl, n2, n3, string, type, ductFactory, string2, string3, string4, n4, string5, string6, n5);
        return TDDucts.registerDuct(duct);
    }

    static DuctItem addDuctItem(int n, boolean bl, int n2, int n3, String string, Duct.Type type, DuctFactory ductFactory, String string2, String string3, String string4, int n4, String string5, String string6, int n5) {
        DuctItem ductItem = new DuctItem(n, bl, n2, n3, string, type, ductFactory, string2, string3, string4, n4, string5, string6, n5);
        return TDDucts.registerDuct(ductItem);
    }

    static <T extends Duct> T registerDuct(T t) {
        int n = t.id;
        while (n >= ductList.size()) {
            ductList.add(null);
        }
        Duct duct = ductList.set(n, t);
        if (duct != null) {
            ThermalDynamics.log.info("Replacing " + duct.unlocalizedName + " with " + t.unlocalizedName);
        }
        return t;
    }

    public static Duct getDuct(int n) {
        if (TDDucts.isValid(n)) {
            return ductList.get(n);
        }
        return structure;
    }

    public static List<Duct> getSortedDucts() {
        if (ductListSorted == null) {
            ductListSorted = new ArrayList();
            for (Duct duct : ductList) {
                if (duct == null) continue;
                ductListSorted.add(duct);
            }
            Collections.sort(ductListSorted, new Comparator<Duct>(){

                @Override
                public int compare(Duct duct, Duct duct2) {
                    int n = duct.ductType.compareTo(duct2.ductType);
                    if (n == 0) {
                        n = duct.compareTo(duct2);
                    }
                    return n;
                }
            });
        }
        return ductListSorted;
    }

    public static boolean isValid(int n) {
        return n < ductList.size() && ductList.get(n) != null;
    }

    public static Duct getType(int n) {
        return ductList.get(n) != null ? ductList.get(n) : structure;
    }

    public static boolean addDucts() {
        TDDucts.addEnergyDucts();
        TDDucts.addFluidDucts();
        TDDucts.addItemDucts();
        TDDucts.addSupportDucts();
        TDDucts.addTransportDucts();
        if (DebugHelper.debug) {
            TDDucts.addIndevDucts();
        }
        return true;
    }

    static void addIndevDucts() {
    }

    static void addEnergyDucts() {
        energyBasic = TDDucts.addDuct(OFFSET_ENERGY + 0, false, 1, 0, "energyBasic", Duct.Type.ENERGY, DuctFactory.energy, "lead", "lead", "minecraft:redstone_block", 255, null, null, 0);
        energyHardened = TDDucts.addDuct(OFFSET_ENERGY + 1, false, 1, 1, "energyHardened", Duct.Type.ENERGY, DuctFactory.energy, "invar", "invar", "minecraft:redstone_block", 255, null, null, 0);
        energyReinforced = TDDucts.addDuct(OFFSET_ENERGY + 2, false, 1, 2, "energyReinforced", Duct.Type.ENERGY, DuctFactory.energy, "electrum", "electrum", "thermalfoundation:fluid/Fluid_Redstone_Still", 128, null, null, 0);
        energyReinforcedEmpty = TDDucts.addDuct(OFFSET_ENERGY + 3, false, 1, -1, "energyReinforcedEmpty", Duct.Type.CRAFTING, DuctFactory.structural, "electrum", "electrum", null, 0, null, null, 0);
        energyResonant = TDDucts.addDuct(OFFSET_ENERGY + 4, false, 1, 3, "energyResonant", Duct.Type.ENERGY, DuctFactory.energy, "enderium", "enderium", "thermalfoundation:fluid/Fluid_Redstone_Still", 128, null, null, 0);
        energyResonantEmpty = TDDucts.addDuct(OFFSET_ENERGY + 5, false, 1, -1, "energyResonantEmpty", Duct.Type.CRAFTING, DuctFactory.structural, "enderium", "enderium", null, 0, null, null, 0);
        energySuperCond = TDDucts.addDuct(OFFSET_ENERGY + 6, false, 1, 4, "energySuperconductor", Duct.Type.ENERGY, DuctFactory.energy_super, "electrum", "electrum", "thermalfoundation:fluid/Fluid_Redstone_Still", 255, "electrum", "thermalfoundation:fluid/Fluid_Cryotheum_Still", 96);
        energySuperCondEmpty = TDDucts.addDuct(OFFSET_ENERGY + 7, false, 1, -1, "energySuperconductorEmpty", Duct.Type.CRAFTING, DuctFactory.structural, "electrum", "electrum", "thermalfoundation:fluid/Fluid_Redstone_Still", 192, "electrum", null, 0);
        energyReinforced.setRarity(1);
        energyReinforcedEmpty.setRarity(1);
        energyResonant.setRarity(2);
        energyResonantEmpty.setRarity(2);
        energySuperCond.setRarity(2);
        energySuperCondEmpty.setRarity(2);
    }

    static void addFluidDucts() {
        fluidBasic = TDDucts.addDuct(OFFSET_FLUID + 0, false, 1, 0, "fluidBasic", Duct.Type.FLUID, DuctFactory.fluid_fragile, "copper", "copper", null, 0, null, null, 0);
        fluidBasicOpaque = TDDucts.addDuct(OFFSET_FLUID + 1, true, 1, 0, "fluidBasic", Duct.Type.FLUID, DuctFactory.fluid_fragile, "copper", "copper", null, 0, null, null, 0);
        fluidHardened = TDDucts.addDuct(OFFSET_FLUID + 2, false, 1, 1, "fluidHardened", Duct.Type.FLUID, DuctFactory.fluid, "invar", "invar", null, 0, null, null, 0);
        fluidHardenedOpaque = TDDucts.addDuct(OFFSET_FLUID + 3, true, 1, 1, "fluidHardened", Duct.Type.FLUID, DuctFactory.fluid, "invar", "invar", null, 0, null, null, 0);
        fluidFlux = TDDucts.addDuct(OFFSET_FLUID + 4, false, 1, 2, "fluidFlux", Duct.Type.FLUID, DuctFactory.fluid_flux, "fluxElectrum", "fluxElectrum", null, 0, null, null, 0);
        fluidFluxOpaque = TDDucts.addDuct(OFFSET_FLUID + 5, true, 1, 2, "fluidFlux", Duct.Type.FLUID, DuctFactory.fluid_flux, "fluxElectrum", "fluxElectrum", null, 0, null, null, 0);
        fluidSuper = TDDucts.addDuct(OFFSET_FLUID + 6, false, 1, 3, "fluidSuper", Duct.Type.FLUID, DuctFactory.fluid_super, "invar", "invar", null, 0, "bronze_large", null, 0);
        fluidSuperOpaque = TDDucts.addDuct(OFFSET_FLUID + 7, true, 1, 3, "fluidSuper", Duct.Type.FLUID, DuctFactory.fluid_super, "invar", "invar", null, 0, "bronze_large", null, 0);
        fluidHardened.setRarity(1);
        fluidHardenedOpaque.setRarity(1);
        fluidFlux.setRarity(1);
        fluidFluxOpaque.setRarity(1);
        fluidSuper.setRarity(2);
        fluidSuperOpaque.setRarity(2);
    }

    static void addItemDucts() {
        itemBasic = TDDucts.addDuctItem(OFFSET_ITEM + 0, false, 1, 0, "itemBasic", Duct.Type.ITEM, DuctFactory.item, "tin", "tin", null, 0, null, null, 0);
        itemBasicOpaque = TDDucts.addDuctItem(OFFSET_ITEM + 1, true, 1, 0, "itemBasic", Duct.Type.ITEM, DuctFactory.item, "tin", "tin", null, 0, null, null, 0);
        itemFast = TDDucts.addDuctItem(OFFSET_ITEM + 2, false, 1, 1, "itemFast", Duct.Type.ITEM, DuctFactory.item, "tin", "tin", "thermalfoundation:fluid/Fluid_Glowstone_Still", 128, null, null, 0);
        itemFastOpaque = TDDucts.addDuctItem(OFFSET_ITEM + 3, true, 1, 1, "itemFast", Duct.Type.ITEM, DuctFactory.item, "tin_1", "tin", null, 0, null, null, 0);
        itemEnder = TDDucts.addDuctItem(OFFSET_ITEM + 4, false, 0, 2, "itemEnder", Duct.Type.ITEM, DuctFactory.item_ender, "enderium", "enderium", null, 48, null, null, 0);
        itemEnderOpaque = TDDucts.addDuctItem(OFFSET_ITEM + 5, true, 0, 2, "itemEnder", Duct.Type.ITEM, DuctFactory.item_ender, "enderium", "enderium", null, 48, null, null, 0);
        itemEnergy = TDDucts.addDuctItem(OFFSET_ITEM + 6, false, 1, 3, "itemFlux", Duct.Type.ITEM, DuctFactory.item_flux, "tin", "tin", "thermalfoundation:fluid/Fluid_Redstone_Still", 48, null, null, 0);
        itemEnergyOpaque = TDDucts.addDuctItem(OFFSET_ITEM + 7, true, 1, 3, "itemFlux", Duct.Type.ITEM, DuctFactory.item_flux, "tin_2", "tin", null, 0, null, null, 0);
        itemFast.setRarity(1);
        itemFastOpaque.setRarity(1);
        itemEnder.setRarity(2);
        itemEnderOpaque.setRarity(2);
        itemEnergy.setRarity(1);
        itemEnergyOpaque.setRarity(1);
    }

    static void addTransportDucts() {
        transportBasic = TDDucts.registerDuct(new DuctTransport(OFFSET_TRANSPORT + 0, false, 1, 4, "transport", Duct.Type.TRANSPORT, DuctFactory.transport, null, null, null, 255, "electrum", "thermaldynamics:duct/base/greenGlass", 96));
        transportLongRange = TDDucts.registerDuct(new DuctTransport(OFFSET_TRANSPORT + 1, false, 1, 4, "transportLongRange", Duct.Type.TRANSPORT, DuctFactory.transport_longrange, null, null, null, 255, "copper", "thermaldynamics:duct/base/greenGlass", 80));
        transportCrossover = TDDucts.registerDuct(new DuctTransport(OFFSET_TRANSPORT + 2, false, 1, 4, "transportAcceleration", Duct.Type.TRANSPORT, DuctFactory.transport_crossover, null, null, null, 255, "enderium", "thermaldynamics:duct/base/greenGlass", 128));
        transportFrame = TDDucts.registerDuct(new DuctTransport(OFFSET_TRANSPORT + 3, false, 1, 4, "transportCrafting", Duct.Type.CRAFTING, DuctFactory.structural, null, null, null, 255, "electrum", null, 128));
        transportBasic.setRarity(1);
        transportLongRange.setRarity(1);
        transportCrossover.setRarity(2);
    }

    static void addSupportDucts() {
        structure = TDDucts.addDuct(OFFSET_STRUCTURE + 0, true, 1, -1, "structure", Duct.Type.STRUCTURAL, DuctFactory.structural, "support", null, null, 0, null, null, 0);
        lightDuct = TDDucts.registerDuct(new DuctLight(OFFSET_STRUCTURE + 1, 0, "structureGlow", Duct.Type.STRUCTURAL, DuctFactory.glow, "lumium", "lumium", null, 0));
    }

    static {
        structureInvis = new Duct(-1, false, 1, -1, "structure", Duct.Type.STRUCTURAL, DuctFactory.structural, "support", null, null, 0, null, null, 0);
        placeholder = new Duct(-1, false, 1, -1, "structure", Duct.Type.STRUCTURAL, DuctFactory.structural, "support", null, null, 0, null, null, 0);
    }
}

