/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.debughelper;

import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermaldynamics.core.TickHandler;
import cofh.thermaldynamics.debughelper.DebugHelper;
import cofh.thermaldynamics.debughelper.PacketDebug;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.iterator.TObjectLongIterator;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkEvent;

public class DebugTickHandler {
    public static DebugTickHandler INSTANCE = new DebugTickHandler();
    public final Random rand = new Random();
    public static boolean showParticles;
    public static boolean showLoading;
    public static volatile long lag;
    int servertick = 0;
    public static HashSet<EntityPlayer> debugPlayers;
    public int[] displayValue = new int[DebugEvent.values().length];
    public int[][] values = new int[20][DebugEvent.values().length];

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load load) {
        this.printChunkEvent((ChunkEvent)load);
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Unload unload) {
        this.printChunkEvent((ChunkEvent)unload);
    }

    public void printChunkEvent(ChunkEvent chunkEvent) {
        if (!showLoading) {
            return;
        }
        DebugHelper.info("[" + chunkEvent.getChunk().field_76635_g + "," + chunkEvent.getChunk().field_76647_h + "]_" + (chunkEvent.getChunk().field_76637_e.field_72995_K ? "Client" : "Server"));
    }

    @SubscribeEvent
    public void lag(TickEvent.ServerTickEvent serverTickEvent) {
        if (lag <= 0L || serverTickEvent.phase == TickEvent.Phase.END) {
            return;
        }
        long l = System.nanoTime();
        while (System.nanoTime() < l + lag) {
        }
    }

    @SubscribeEvent
    public void subTicks(TickEvent.ServerTickEvent serverTickEvent) {
        if (DebugHelper.subTicks.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        TObjectLongIterator tObjectLongIterator = DebugHelper.subTicks.iterator();
        boolean bl = false;
        while (tObjectLongIterator.hasNext()) {
            tObjectLongIterator.advance();
            int n = DebugHelper.subTickCalls.get(tObjectLongIterator.key());
            bl = bl || n > 0;
            double d = (double)tObjectLongIterator.value() * 1.0E-6;
            stringBuilder.append((String)tObjectLongIterator.key()).append("={").append(d).append(" ms").append(", n=").append(n).append(", avg=").append(d / (double)(n == 0 ? 1 : n)).append("} ");
            tObjectLongIterator.setValue(0L);
            DebugHelper.subTickCalls.put(tObjectLongIterator.key(), 0);
        }
        if (bl) {
            DebugHelper.info(stringBuilder.toString());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void showParticles(TickEvent.WorldTickEvent worldTickEvent) {
        if (worldTickEvent.phase == TickEvent.Phase.START || Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g != worldTickEvent.world.field_73011_w.field_76574_g) {
            return;
        }
        if (ServerHelper.isClientWorld((World)worldTickEvent.world)) {
            return;
        }
        if (!showParticles) {
            return;
        }
        for (MultiBlockGrid multiBlockGrid : TickHandler.getTickHandler((World)worldTickEvent.world).tickingGrids) {
            this.rand.setSeed(multiBlockGrid.hashCode());
            double d = this.rand.nextDouble();
            double d2 = this.rand.nextDouble();
            double d3 = this.rand.nextDouble();
            double d4 = 1.0 / (d > d2 ? (d3 > d ? d3 : d) : (d3 > d2 ? d3 : d2));
            d *= d4;
            d2 *= d4;
            d3 *= d4;
            for (IMultiBlock iMultiBlock : multiBlockGrid.nodeSet) {
                Minecraft.func_71410_x().field_71441_e.func_72869_a("reddust", (double)iMultiBlock.x() + 0.5, (double)iMultiBlock.y() + 0.75, (double)iMultiBlock.z() + 0.5, d, d2, d3);
            }
            d *= 0.8;
            d2 *= 0.8;
            d3 *= 0.8;
            for (IMultiBlock iMultiBlock : multiBlockGrid.idleSet) {
                Minecraft.func_71410_x().field_71441_e.func_72869_a("reddust", (double)iMultiBlock.x() + 0.5, (double)iMultiBlock.y() + 0.75, (double)iMultiBlock.z() + 0.5, d, d2, d3);
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent serverTickEvent) {
        if (serverTickEvent.phase != TickEvent.Phase.END) {
            return;
        }
        int n = (this.servertick + 1) % this.values.length;
        for (int i = 0; i < DebugEvent.n; ++i) {
            this.displayValue[i] = 0;
            for (int[] nArray : this.values) {
                int n2 = i;
                this.displayValue[n2] = this.displayValue[n2] + nArray[i];
            }
            this.values[n][i] = 0;
        }
        this.servertick = n;
        PacketDebug packetDebug = new PacketDebug(this.displayValue);
        Object object = debugPlayers.iterator();
        while (object.hasNext()) {
            EntityPlayer entityPlayer = (EntityPlayer)object.next();
            PacketHandler.sendTo((PacketBase)packetDebug, (EntityPlayer)entityPlayer);
        }
    }

    public static void tickEvent(DebugEvent debugEvent) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            int[] nArray = DebugTickHandler.INSTANCE.values[DebugTickHandler.INSTANCE.servertick];
            int n = debugEvent.ordinal();
            nArray[n] = nArray[n] + 1;
        }
    }

    static {
        lag = 0L;
        debugPlayers = new HashSet();
    }

    public static enum DebugEvent {
        GRID_FORMED,
        GRID_BROKEN,
        NEIGHBOUR_CHANGE,
        NEIGHBOUR_WEAK_CHANGE,
        TILE_INVALIDATED,
        NEIGHBOUR_CHUNK_UNLOADED,
        TILE_TICKED,
        PACKET_FORMED,
        GRID_MERGED,
        GRID_DESTROYED,
        ROUTE_SEARCH,
        ROUTE_INVALIDATED,
        ROUTE_RESET,
        ITEM_POLL,
        ITEM_REPOLL;

        static final int n;

        static {
            n = DebugEvent.values().length;
        }
    }
}

