/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.network.packet.client;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import thaumicenergistics.common.network.NetworkHandler;
import thaumicenergistics.common.network.ThEBasePacket;
import thaumicenergistics.common.network.packet.client.ThEClientPacket;
import thaumicenergistics.common.utils.ThEUtils;

public class Packet_C_Sync
extends ThEClientPacket {
    private static final byte MODE_PLAYER_HELD = 1;
    private static final byte MODE_SOUND = 2;
    private ItemStack syncStack;
    private boolean syncFlag;
    private String syncString;

    private static Packet_C_Sync newPacket(EntityPlayer player, byte mode) {
        Packet_C_Sync packet = new Packet_C_Sync();
        packet.player = player;
        packet.mode = mode;
        return packet;
    }

    public static void sendPlayerHeldItem(EntityPlayer player, ItemStack heldItem) {
        Packet_C_Sync packet = Packet_C_Sync.newPacket(player, (byte)1);
        packet.syncStack = heldItem;
        packet.syncFlag = heldItem != null;
        NetworkHandler.sendPacketToClient(packet);
    }

    public static void sendPlaySound(EntityPlayer player, String soundLocation) {
        Packet_C_Sync packet = Packet_C_Sync.newPacket(player, (byte)2);
        packet.syncString = soundLocation;
        NetworkHandler.sendPacketToClient(packet);
    }

    @Override
    protected void readData(ByteBuf stream) {
        switch (this.mode) {
            case 1: {
                this.syncFlag = stream.readBoolean();
                if (this.syncFlag) {
                    this.syncStack = ThEBasePacket.readItemstack(stream);
                    break;
                }
                this.syncStack = null;
                break;
            }
            case 2: {
                this.syncString = ThEBasePacket.readString(stream);
            }
        }
    }

    @Override
    protected void wrappedExecute() {
        switch (this.mode) {
            case 1: {
                this.player.field_71071_by.func_70437_b(this.syncStack);
                break;
            }
            case 2: {
                ThEUtils.playClientSound(null, this.syncString);
            }
        }
    }

    @Override
    protected void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 1: {
                stream.writeBoolean(this.syncFlag);
                if (!this.syncFlag) break;
                ThEBasePacket.writeItemstack(this.syncStack, stream);
                break;
            }
            case 2: {
                ThEBasePacket.writeString(this.syncString, stream);
            }
        }
    }
}

