/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import appeng.api.AEApi;
import appeng.container.slot.SlotFake;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.research.ScanManager;
import thaumicenergistics.api.storage.IInventoryUpdateReceiver;
import thaumicenergistics.common.container.ContainerWithPlayerInventory;
import thaumicenergistics.common.container.slot.SlotRestrictive;
import thaumicenergistics.common.inventory.HandlerDistillationPattern;
import thaumicenergistics.common.inventory.TheInternalInventory;
import thaumicenergistics.common.items.ItemCraftingAspect;
import thaumicenergistics.common.items.ItemEnum;
import thaumicenergistics.common.tiles.TileDistillationPatternEncoder;
import thaumicenergistics.common.utils.EffectiveSide;

public class ContainerDistillationPatternEncoder
extends ContainerWithPlayerInventory {
    private static final int PLAYER_INV_POSITION_Y = 152;
    private static final int HOTBAR_INV_POSITION_Y = 210;
    public static final int SLOT_SOURCE_ITEM_POS_X = 15;
    public static final int SLOT_SOURCE_ITEM_POS_Y = 69;
    private static final int SLOT_SOURCE_ASPECTS_POS_X = 65;
    private static final int SLOT_SOURCE_ASPECTS_POS_Y = 24;
    private static final int SLOT_SOURCE_ASPECTS_COUNT = 6;
    private static final int SLOT_SELECTED_ASPECT_POS_X = 116;
    private static final int SLOT_SELECTED_ASPECT_POS_Y = 69;
    private static final int SLOT_PATTERNS_BLANK_POS_X = 146;
    private static final int SLOT_PATTERNS_BLANK_POS_Y = 75;
    private static final int SLOT_PATTERN_ENCODED_POS_X = 146;
    private static final int SLOT_PATTERN_ENCODED_POS_Y = 113;
    private final TileDistillationPatternEncoder encoder;
    private final SlotFake slotSelectedAspect;
    private final SlotRestrictive slotPatternsBlank;
    private final SlotRestrictive slotPatternEncoded;
    private final HandlerDistillationPattern patternHelper;
    private final TheInternalInventory internalInventory;
    private ItemStack cachedSource;
    private ItemStack cachedPattern;
    public final SlotFake slotSourceItem;
    public final SlotFake[] slotSourceAspects = new SlotFake[6];
    public IInventoryUpdateReceiver slotUpdateReceiver;

    public ContainerDistillationPatternEncoder(EntityPlayer player, World world, int x, int y, int z) {
        super(player);
        this.encoder = (TileDistillationPatternEncoder)world.func_147438_o(x, y, z);
        this.internalInventory = new TheInternalInventory("dpeAspects", 7, 64){

            @Override
            public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
                return itemStack == null || itemStack.func_77973_b() instanceof ItemCraftingAspect;
            }
        };
        for (int index = 0; index < 6; ++index) {
            int posY = 24 + index * 18;
            this.slotSourceAspects[index] = new SlotFake((IInventory)this.internalInventory, index, 65, posY);
            this.func_75146_a((Slot)this.slotSourceAspects[index]);
        }
        this.slotSelectedAspect = new SlotFake((IInventory)this.internalInventory, 6, 116, 69);
        this.func_75146_a((Slot)this.slotSelectedAspect);
        this.slotSourceItem = new SlotFake((IInventory)this.encoder, TileDistillationPatternEncoder.SLOT_SOURCE_ITEM, 15, 69);
        this.func_75146_a((Slot)this.slotSourceItem);
        this.slotPatternsBlank = new SlotRestrictive(this.encoder, TileDistillationPatternEncoder.SLOT_BLANK_PATTERNS, 146, 75);
        this.func_75146_a(this.slotPatternsBlank);
        this.slotPatternEncoded = new SlotRestrictive(this.encoder, TileDistillationPatternEncoder.SLOT_ENCODED_PATTERN, 146, 113);
        this.func_75146_a(this.slotPatternEncoded);
        this.bindPlayerInventory((IInventory)player.field_71071_by, 152, 210);
        this.patternHelper = new HandlerDistillationPattern();
    }

    private void clearAspectSlots() {
        this.slotSelectedAspect.clearStack();
        for (int index = 0; index < this.slotSourceAspects.length; ++index) {
            this.slotSourceAspects[index].clearStack();
        }
    }

    private boolean handleSlotTransfer(@Nonnull Slot clickedSlot) {
        ItemStack slotStack = clickedSlot.func_75211_c();
        if (clickedSlot.field_75224_c == this.player.field_71071_by) {
            if (this.slotPatternsBlank.func_75214_a(slotStack)) {
                return this.func_75135_a(slotStack, this.slotPatternsBlank.field_75222_d, this.slotPatternsBlank.field_75222_d + 1, false);
            }
            if (this.slotPatternEncoded.func_75214_a(slotStack)) {
                return this.func_75135_a(slotStack, this.slotPatternEncoded.field_75222_d, this.slotPatternEncoded.field_75222_d + 1, false);
            }
            ItemStack copy = slotStack.func_77946_l();
            copy.field_77994_a = 1;
            this.slotSourceItem.func_75215_d(copy);
            return true;
        }
        if (this.slotPatternsBlank == clickedSlot || this.slotPatternEncoded == clickedSlot) {
            if (!this.mergeSlotWithHotbarInventory(slotStack)) {
                return this.mergeSlotWithPlayerInventory(slotStack);
            }
            return true;
        }
        return false;
    }

    private void loadPattern() {
        this.cachedPattern = this.slotPatternEncoded.func_75211_c();
        this.patternHelper.readPattern(this.cachedPattern);
        if (this.patternHelper.isValid()) {
            this.slotSourceItem.func_75215_d(this.patternHelper.getInput());
            this.scanSourceItem(false);
            this.setSelectedAspect(this.patternHelper.getOutput());
        }
    }

    private void scanSourceItem(boolean setSelectedAspect) {
        boolean playerScanned;
        this.cachedSource = this.slotSourceItem.func_75211_c();
        this.clearAspectSlots();
        if (this.cachedSource == null) {
            return;
        }
        AspectList itemAspects = ThaumcraftApiHelper.getObjectAspects((ItemStack)this.cachedSource);
        itemAspects = ThaumcraftApiHelper.getBonusObjectTags((ItemStack)this.cachedSource, (AspectList)itemAspects);
        Aspect[] sortedAspects = null;
        if (itemAspects == null || itemAspects.size() == 0) {
            return;
        }
        int hash = ScanManager.generateItemHash((Item)this.cachedSource.func_77973_b(), (int)this.cachedSource.func_77960_j());
        List list = (List)Thaumcraft.proxy.getScannedObjects().get(this.player.func_70005_c_());
        int numOfAspects = this.slotSourceAspects.length;
        boolean bl = playerScanned = list != null && (list.contains("@" + hash) || list.contains("#" + hash));
        if (playerScanned) {
            sortedAspects = itemAspects.getAspectsSortedAmount();
            numOfAspects = Math.min(numOfAspects, sortedAspects.length);
        }
        for (int i = 0; i < numOfAspects; ++i) {
            ItemStack aspectItem = ItemEnum.CRAFTING_ASPECT.getStack();
            if (sortedAspects != null) {
                Aspect aspect = sortedAspects[i];
                ItemCraftingAspect.setAspect(aspectItem, aspect);
                aspectItem.field_77994_a = itemAspects.getAmount(aspect);
            }
            this.slotSourceAspects[i].func_75215_d(aspectItem);
            if (!setSelectedAspect || !playerScanned || this.slotSelectedAspect.func_75216_d()) continue;
            this.setSelectedAspect(aspectItem);
        }
    }

    @Override
    protected boolean detectAndSendChangesMP(EntityPlayerMP playerMP) {
        if (this.slotPatternEncoded.func_75211_c() != this.cachedPattern) {
            this.loadPattern();
            return true;
        }
        if (this.slotSourceItem.func_75211_c() != this.cachedSource) {
            this.scanSourceItem(true);
            return true;
        }
        return false;
    }

    protected void setSelectedAspect(ItemStack aspectStack) {
        this.slotSelectedAspect.clearStack();
        if (aspectStack == null) {
            return;
        }
        Aspect aspect = ItemCraftingAspect.getAspect(aspectStack);
        if (aspect == null) {
            return;
        }
        if (!ItemCraftingAspect.canPlayerSeeAspect(this.player, aspect)) {
            this.slotSelectedAspect.func_75215_d(ItemEnum.CRAFTING_ASPECT.getStack());
            return;
        }
        this.slotSelectedAspect.func_75215_d(aspectStack.func_77946_l());
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.encoder != null) {
            return this.encoder.func_70300_a(player);
        }
        return false;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void onEncodePattern() {
        ItemStack pattern = null;
        boolean takeBlank = false;
        if (this.slotPatternEncoded.func_75216_d()) {
            pattern = this.slotPatternEncoded.func_75211_c();
        } else if (this.slotPatternsBlank.func_75216_d()) {
            pattern = (ItemStack)AEApi.instance().definitions().items().encodedPattern().maybeStack(1).orNull();
            if (pattern == null) {
                return;
            }
            takeBlank = true;
        } else {
            return;
        }
        if (!this.patternHelper.setPatternItems(this.slotSourceItem.getDisplayStack(), this.slotSelectedAspect.getDisplayStack())) {
            return;
        }
        this.patternHelper.encodePattern(pattern);
        this.slotPatternEncoded.func_75215_d(pattern);
        if (takeBlank) {
            this.slotPatternsBlank.func_75209_a(1);
        }
    }

    public void func_75141_a(int slotNumber, ItemStack stack) {
        super.func_75141_a(slotNumber, stack);
        if (this.slotUpdateReceiver != null && this.slotSourceItem.field_75222_d == slotNumber) {
            this.slotUpdateReceiver.onInventoryChanged(this.slotSourceItem.field_75224_c);
        }
    }

    public ItemStack func_75144_a(int slotNumber, int buttonPressed, int flag, EntityPlayer player) {
        if (this.slotSelectedAspect.field_75222_d == slotNumber) {
            return null;
        }
        boolean handled = false;
        if (this.slotSourceItem.field_75222_d == slotNumber) {
            ItemStack heldItem = player.field_71071_by.func_70445_o();
            if (heldItem != null) {
                ItemStack copy = heldItem.func_77946_l();
                copy.field_77994_a = 1;
                this.slotSourceItem.func_75215_d(copy);
            } else {
                this.slotSourceItem.func_75215_d(null);
            }
            handled = true;
        }
        if (!handled) {
            for (int index = 0; index < this.slotSourceAspects.length; ++index) {
                if (this.slotSourceAspects[index].field_75222_d != slotNumber) continue;
                if (this.slotSourceAspects[index].func_75216_d()) {
                    this.setSelectedAspect(this.slotSourceAspects[index].func_75211_c());
                }
                handled = true;
                break;
            }
        }
        if (handled) {
            this.func_75142_b();
            return null;
        }
        return super.func_75144_a(slotNumber, buttonPressed, flag, player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        if (EffectiveSide.isClientSide()) {
            return null;
        }
        Slot clickedSlot = this.getSlotOrNull(slotNumber);
        if (clickedSlot == null || !clickedSlot.func_75216_d()) {
            return null;
        }
        if (this.handleSlotTransfer(clickedSlot)) {
            if (clickedSlot.func_75216_d() && clickedSlot.func_75211_c().field_77994_a <= 0) {
                clickedSlot.func_75215_d(null);
            } else {
                clickedSlot.func_75218_e();
            }
            this.func_75142_b();
        }
        return null;
    }
}

