/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui;

import appeng.api.config.RedstoneMode;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.gui.IAspectSlotGui;
import thaumicenergistics.client.gui.abstraction.ThEBaseGui;
import thaumicenergistics.client.gui.buttons.GuiButtonAllowVoid;
import thaumicenergistics.client.gui.buttons.GuiButtonRedstoneModes;
import thaumicenergistics.client.gui.widget.AspectWidgetBase;
import thaumicenergistics.client.gui.widget.WidgetAspectSlot;
import thaumicenergistics.client.textures.GuiTextureManager;
import thaumicenergistics.common.container.ContainerPartEssentiaIOBus;
import thaumicenergistics.common.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.common.network.packet.server.Packet_S_EssentiaIOBus;
import thaumicenergistics.common.parts.AEPartsEnum;
import thaumicenergistics.common.parts.PartEssentiaExportBus;
import thaumicenergistics.common.parts.PartEssentiaImportBus;
import thaumicenergistics.common.parts.ThEPartEssentiaIOBus_Base;

@SideOnly(value=Side.CLIENT)
public class GuiEssentiaIO
extends ThEBaseGui
implements WidgetAspectSlot.IConfigurable,
IAspectSlotGui {
    private static final int FILTER_GRID_SIZE = 3;
    private static final byte[] WIDGET_CONFIG_BYTES = new byte[]{2, 1, 2, 1, 0, 1, 2, 1, 2};
    private static final int WIDGET_X_POSITION = 61;
    private static final int WIDGET_Y_POSITION = 21;
    private static final int GUI_HEIGHT = 184;
    private static final int GUI_WIDTH_NO_TOOL = 211;
    private static final int GUI_WIDTH_WITH_TOOL = 246;
    private static final int GUI_MAIN_WIDTH = 176;
    private static final int GUI_UPGRADES_WIDTH = 35;
    private static final int GUI_UPGRADES_HEIGHT = 86;
    private static final int TITLE_POS_X = 6;
    private static final int TITLE_POS_Y = 5;
    private static final int REDSTONE_CONTROL_BUTTON_POS_Y = 2;
    private static final int REDSTONE_CONTROL_BUTTON_POS_X = -18;
    private static final int REDSTONE_CONTROL_BUTTON_SIZE = 16;
    private static final int REDSTONE_CONTROL_BUTTON_ID = 0;
    private static final int ALLOW_VOID_BUTTON_POS_Y = 2;
    private static final int ALLOW_VOID_BUTTON_POS_X = -19;
    private static final int ALLOW_VOID_BUTTON_ID = 1;
    private ThEPartEssentiaIOBus_Base part;
    private EntityPlayer player;
    private byte filterSize;
    private List<WidgetAspectSlot> aspectSlotList = new ArrayList<WidgetAspectSlot>();
    private List<Aspect> filteredAspects = new ArrayList<Aspect>();
    private boolean hasNetworkTool;
    private RedstoneMode redstoneMode = RedstoneMode.HIGH_SIGNAL;
    private final String guiTitle;
    private GuiButtonRedstoneModes redstoneControlButton = null;
    private GuiButtonAllowVoid voidModeButton = null;

    public GuiEssentiaIO(ThEPartEssentiaIOBus_Base partBus, EntityPlayer player) {
        super(new ContainerPartEssentiaIOBus(partBus, player));
        this.part = partBus;
        this.player = player;
        this.hasNetworkTool = ((ContainerPartEssentiaIOBus)this.field_147002_h).hasNetworkTool();
        this.field_146999_f = this.hasNetworkTool ? 246 : 211;
        this.field_147000_g = 184;
        this.guiTitle = partBus instanceof PartEssentiaImportBus ? AEPartsEnum.EssentiaImportBus.getLocalizedName() : (partBus instanceof PartEssentiaExportBus ? AEPartsEnum.EssentiaExportBus.getLocalizedName() : "");
    }

    protected void func_146976_a(float alpha, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiTextureManager.ESSENTIA_IO_BUS.getTexture());
        if (this.hasNetworkTool) {
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 246, 184);
        } else {
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 176, 184);
            this.func_73729_b(this.field_147003_i + 176, this.field_147009_r, 176, 0, 35, 86);
        }
        super.drawAEToolAndUpgradeSlots(alpha, mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(this.guiTitle, 6, 5, 0);
        boolean hoverUnderlayRendered = false;
        AspectWidgetBase slotUnderMouse = null;
        for (int i = 0; i < 9; ++i) {
            WidgetAspectSlot slotWidget = this.aspectSlotList.get(i);
            if (!hoverUnderlayRendered && slotWidget.canRender() && slotWidget.isMouseOverWidget(mouseX, mouseY)) {
                slotWidget.drawMouseHoverUnderlay();
                slotUnderMouse = slotWidget;
                hoverUnderlayRendered = true;
            }
            slotWidget.drawWidget();
        }
        if (slotUnderMouse != null) {
            slotUnderMouse.getTooltip(this.tooltip);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (WidgetAspectSlot aspectSlot : this.aspectSlotList) {
            if (!aspectSlot.isMouseOverWidget(mouseX, mouseY)) continue;
            Aspect itemAspect = EssentiaItemContainerHelper.INSTANCE.getFilterAspectFromItem(this.player.field_71071_by.func_70445_o());
            if (itemAspect != null && this.filteredAspects.contains(itemAspect)) {
                return;
            }
            aspectSlot.mouseClicked(itemAspect);
            break;
        }
    }

    @Override
    protected void onButtonClicked(GuiButton button, int mouseButton) {
        if (button.field_146127_k == 0) {
            Packet_S_EssentiaIOBus.sendRedstoneModeChange(this.player, this.part);
        } else if (button.field_146127_k == 1 && this.part instanceof PartEssentiaExportBus) {
            Packet_S_EssentiaIOBus.sendVoidModeChange(this.player, (PartEssentiaExportBus)this.part);
        }
    }

    @Override
    public byte getConfigState() {
        return this.filterSize;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                int index = row * 3 + column;
                int xPos = 61 + column * 18;
                int yPos = 21 + row * 18;
                this.aspectSlotList.add(new WidgetAspectSlot(this, this.player, this.part, index, xPos, yPos, this, WIDGET_CONFIG_BYTES[index]));
            }
        }
        this.redstoneControlButton = new GuiButtonRedstoneModes(0, this.field_147003_i + -18, this.field_147009_r + 2, 16, 16, this.redstoneMode, false);
        if (this.part instanceof PartEssentiaExportBus) {
            this.voidModeButton = new GuiButtonAllowVoid(1, this.field_147003_i + -19, this.field_147009_r + 2);
            this.field_146292_n.add(this.voidModeButton);
        }
        Packet_S_EssentiaIOBus.sendRequestFilterList(this.player, this.part);
    }

    public void onReceiveFilterSize(byte filterSize) {
        this.part.onReceiveFilterSize(filterSize);
        this.filterSize = filterSize;
        for (int i = 0; i < this.aspectSlotList.size(); ++i) {
            WidgetAspectSlot slot = this.aspectSlotList.get(i);
            if (slot.canRender()) continue;
            slot.setAspect(null);
        }
    }

    public void onReceiveRedstoneControlled(boolean newRedstoneControled) {
        if (newRedstoneControled && !this.field_146292_n.contains((Object)this.redstoneControlButton)) {
            this.field_146292_n.add(this.redstoneControlButton);
            if (this.voidModeButton != null) {
                this.voidModeButton.field_146129_i += 18;
            }
        } else if (!newRedstoneControled && this.field_146292_n.contains((Object)this.redstoneControlButton)) {
            this.field_146292_n.remove((Object)this.redstoneControlButton);
            if (this.voidModeButton != null) {
                this.voidModeButton.field_146129_i -= 18;
            }
        }
    }

    public void onReceiveRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneControlButton.setRedstoneMode(redstoneMode);
        this.redstoneMode = redstoneMode;
    }

    public void onServerSendVoidMode(boolean isVoidAllowed) {
        if (this.voidModeButton != null) {
            this.voidModeButton.setIsVoidAllowed(isVoidAllowed);
        }
    }

    @Override
    public void updateAspects(List<Aspect> aspectList) {
        this.part.onReceiveFilterList(aspectList);
        int count = Math.min(this.aspectSlotList.size(), aspectList.size());
        for (int i = 0; i < count; ++i) {
            this.aspectSlotList.get(i).setAspect(aspectList.get(i), 1L, false);
        }
        this.filteredAspects = aspectList;
    }
}

