/*
 * Decompiled with CFR 0.152.
 */
package me.codasylph.thaumicalchemy.tileentities;

import me.codasylph.thaumicalchemy.AspectHelper;
import me.codasylph.thaumicalchemy.EssentiaTank;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.config.ConfigBlocks;

public class TileAmalgamator
extends TileEntity
implements IEssentiaTransport {
    public static final String tileEntityName = "tileAmalgamator";
    public EssentiaTank[] storage = new EssentiaTank[3];
    public int ticks;

    public TileAmalgamator() {
        this.storage[0] = new EssentiaTank(null, 0, 4);
        this.storage[1] = new EssentiaTank(null, 0, 4);
        this.storage[2] = new EssentiaTank(null, 0, 8);
        this.ticks = 0;
    }

    public void func_145845_h() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.canInputFrom(dir) || !(this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) instanceof IEssentiaTransport)) continue;
            IEssentiaTransport tube = (IEssentiaTransport)this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            this.addEssentia(tube.getEssentiaType(dir), tube.takeEssentia(tube.getEssentiaType(dir), 1, dir), dir);
        }
        if (this.storage != null) {
            Aspect type;
            if (AspectHelper.getCompound(this.storage[0].getAspect(), this.storage[1].getAspect()) != null) {
                type = AspectHelper.getCompound(this.storage[0].getAspect(), this.storage[1].getAspect());
                if (this.storage[0].getAmount() >= 4 && this.storage[1].getAmount() >= 4 && (this.storage[2].getAspect() == null || this.storage[2].getAspect() == type) && this.ticks >= 36) {
                    this.takeEssentia(this.storage[0].getAspect(), 4, 0);
                    this.takeEssentia(this.storage[1].getAspect(), 4, 1);
                    this.addEssentia(type, 1 + this.field_145850_b.field_73012_v.nextInt(4), 2);
                    this.ticks = 0;
                }
                ++this.ticks;
            } else if (this.storage[0].getAspect() != null && this.storage[1].getAspect() != null && this.storage[0].getAspect() != this.storage[1].getAspect()) {
                this.takeEssentia(this.storage[0].getAspect(), 1, 0);
                this.takeEssentia(this.storage[1].getAspect(), 1, 1);
                this.spill();
            } else if (this.storage[0].getAspect() != null && this.storage[0].getAspect() == this.storage[1].getAspect()) {
                type = this.storage[0].getAspect();
                this.takeEssentia(type, 1, 0);
                this.takeEssentia(type, 1, 1);
                this.addEssentia(type, 2, 2);
            }
        }
    }

    private void spill() {
        if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
            if (this.field_145850_b.field_73012_v.nextBoolean()) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, ConfigBlocks.blockFluxGas, 0, 3);
            } else {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, ConfigBlocks.blockFluxGoo, 0, 3);
            }
        } else {
            Block bi = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            int md = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            if (bi == ConfigBlocks.blockFluxGoo && md < 7) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, ConfigBlocks.blockFluxGoo, md + 1, 3);
            } else if (bi == ConfigBlocks.blockFluxGas && md < 7) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, ConfigBlocks.blockFluxGas, md + 1, 3);
            } else {
                int z;
                int y;
                int x = -1 + this.field_145850_b.field_73012_v.nextInt(3);
                if (this.field_145850_b.func_147437_c(this.field_145851_c + x, this.field_145848_d + (y = -1 + this.field_145850_b.field_73012_v.nextInt(3)), this.field_145849_e + (z = -1 + this.field_145850_b.field_73012_v.nextInt(3)))) {
                    if (this.field_145850_b.field_73012_v.nextBoolean()) {
                        this.field_145850_b.func_147465_d(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z, ConfigBlocks.blockFluxGas, 0, 3);
                    } else {
                        this.field_145850_b.func_147465_d(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z, ConfigBlocks.blockFluxGoo, 0, 3);
                    }
                }
            }
        }
    }

    public boolean isConnectable(ForgeDirection face) {
        return face == ForgeDirection.DOWN || face == ForgeDirection.EAST || face == ForgeDirection.WEST;
    }

    public boolean canInputFrom(ForgeDirection face) {
        int i;
        if (face != null && (i = face.ordinal() - 4) >= 0) {
            return this.storage[i].getCapacity() > this.storage[i].getAmount();
        }
        return false;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return face == ForgeDirection.DOWN && this.storage[2].getAmount() > 0;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public Aspect getSuctionType(ForgeDirection face) {
        return null;
    }

    public int getSuctionAmount(ForgeDirection face) {
        return this.canInputFrom(face) ? 128 : 0;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (this.canOutputTo(face)) {
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return this.storage[2].remove(aspect, amount);
        }
        return 0;
    }

    public int takeEssentia(Aspect aspect, int amount, int tank) {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.storage[tank].remove(aspect, amount);
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (this.canInputFrom(face)) {
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            int i = face.ordinal() - 4;
            return this.storage[i].add(aspect, amount);
        }
        return 0;
    }

    public int addEssentia(Aspect aspect, int amount, int tank) {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.storage[tank].add(aspect, amount);
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        int i;
        int n = i = face != null ? face.ordinal() - 4 : 2;
        if (i >= 0) {
            return this.storage[i % this.storage.length].getAspect();
        }
        return this.storage[2].getAspect();
    }

    public int getEssentiaAmount(ForgeDirection face) {
        int i = face != null ? face.ordinal() - 4 : 2;
        return i >= 0 ? this.storage[i].getAmount() : 0;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public boolean renderExtendedTube() {
        return false;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("ticks", this.ticks);
        nbt.func_74778_a("Tank0a", this.storage[0].getAspect() != null ? this.storage[0].getAspect().getTag() : "null");
        nbt.func_74768_a("Tank0i", this.storage[0].getAmount());
        nbt.func_74778_a("Tank1a", this.storage[1].getAspect() != null ? this.storage[1].getAspect().getTag() : "null");
        nbt.func_74768_a("Tank1i", this.storage[1].getAmount());
        nbt.func_74778_a("Tank2a", this.storage[2].getAspect() != null ? this.storage[2].getAspect().getTag() : "null");
        nbt.func_74768_a("Tank2i", this.storage[2].getAmount());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.ticks = nbt.func_74762_e("ticks");
        this.storage[0].setContent(nbt.func_74779_i("Tank0a") != "null" ? Aspect.getAspect((String)nbt.func_74779_i("Tank0a")) : null, nbt.func_74762_e("Tank0i"));
        this.storage[1].setContent(nbt.func_74779_i("Tank1a") != "null" ? Aspect.getAspect((String)nbt.func_74779_i("Tank1a")) : null, nbt.func_74762_e("Tank1i"));
        this.storage[2].setContent(nbt.func_74779_i("Tank2a") != "null" ? Aspect.getAspect((String)nbt.func_74779_i("Tank2a")) : null, nbt.func_74762_e("Tank2i"));
    }

    public Packet func_145844_m() {
        super.func_145844_m();
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("ticks", this.ticks);
        nbt.func_74778_a("Tank0a", this.storage[0].getAspect() != null ? this.storage[0].getAspect().getTag() : "null");
        nbt.func_74768_a("Tank0i", this.storage[0].getAmount());
        nbt.func_74778_a("Tank1a", this.storage[1].getAspect() != null ? this.storage[1].getAspect().getTag() : "null");
        nbt.func_74768_a("Tank1i", this.storage[1].getAmount());
        nbt.func_74778_a("Tank2a", this.storage[2].getAspect() != null ? this.storage[2].getAspect().getTag() : "null");
        nbt.func_74768_a("Tank2i", this.storage[2].getAmount());
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound nbt = pkt.func_148857_g();
        this.ticks = nbt.func_74762_e("ticks");
        this.storage[0].setContent(nbt.func_74779_i("Tank0a") != "null" ? Aspect.getAspect((String)nbt.func_74779_i("Tank0a")) : null, nbt.func_74762_e("Tank0i"));
        this.storage[1].setContent(nbt.func_74779_i("Tank1a") != "null" ? Aspect.getAspect((String)nbt.func_74779_i("Tank1a")) : null, nbt.func_74762_e("Tank1i"));
        this.storage[2].setContent(nbt.func_74779_i("Tank2a") != "null" ? Aspect.getAspect((String)nbt.func_74779_i("Tank2a")) : null, nbt.func_74762_e("Tank2i"));
    }
}

