/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.io.File;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.client.lib.RenderEventHandler;
import thaumcraft.common.CommonProxy;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigAspects;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigEntities;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.config.ConfigRecipes;
import thaumcraft.common.config.ConfigResearch;
import thaumcraft.common.items.BehaviorDispenseAlumetum;
import thaumcraft.common.lib.CreativeTabThaumcraft;
import thaumcraft.common.lib.InternalMethodHandler;
import thaumcraft.common.lib.events.CommandThaumcraft;
import thaumcraft.common.lib.events.EventHandlerEntity;
import thaumcraft.common.lib.events.EventHandlerRunic;
import thaumcraft.common.lib.events.EventHandlerWorld;
import thaumcraft.common.lib.events.ServerTickEventsFML;
import thaumcraft.common.lib.network.EventHandlerNetwork;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketSyncWarp;
import thaumcraft.common.lib.network.playerdata.PacketWarpMessage;
import thaumcraft.common.lib.research.PlayerKnowledge;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.lib.utils.CropUtils;
import thaumcraft.common.lib.utils.Utils;
import thaumcraft.common.lib.world.ComponentBankerHome;
import thaumcraft.common.lib.world.ComponentWizardTower;
import thaumcraft.common.lib.world.ThaumcraftWorldGenerator;
import thaumcraft.common.lib.world.VillageBankerManager;
import thaumcraft.common.lib.world.VillageWizardManager;
import thaumcraft.common.lib.world.dim.WorldProviderOuter;
import thaumcraft.common.tiles.TileEldritchAltar;

@Mod(modid="Thaumcraft", name="Thaumcraft", version="4.2.3.5", guiFactory="thaumcraft.client.ThaumcraftGuiFactory", dependencies="required-after:Forge@[10.13.2,);required-after:Baubles@[1.0.1.10,)")
public class Thaumcraft {
    public static final String MODID = "Thaumcraft";
    public static final String MODNAME = "Thaumcraft";
    public static final String VERSION = "4.2.3.5";
    @SidedProxy(clientSide="thaumcraft.client.ClientProxy", serverSide="thaumcraft.common.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="Thaumcraft")
    public static Thaumcraft instance;
    ResearchManager researchManager;
    public ThaumcraftWorldGenerator worldGen;
    public EventHandlerWorld worldEventHandler;
    public EventHandlerNetwork networkEventHandler;
    public ServerTickEventsFML serverTickEvents;
    public EventHandlerEntity entityEventHandler;
    public EventHandlerRunic runicEventHandler;
    public RenderEventHandler renderEventHandler;
    public File modDir;
    public static final Logger log;
    public static boolean isHalloween;
    public static CreativeTabs tabTC;
    public boolean aspectShift = false;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        event.getModMetadata().version = VERSION;
        this.modDir = event.getModConfigurationDirectory();
        try {
            Config.initialize(event.getSuggestedConfigurationFile());
        }
        catch (Exception var8) {
            log.error("Thaumcraft has a problem loading it's configuration");
        }
        finally {
            if (Config.config != null) {
                Config.save();
            }
        }
        ThaumcraftApi.internalMethods = new InternalMethodHandler();
        Thaumcraft.proxy.playerKnowledge = new PlayerKnowledge();
        Thaumcraft.proxy.researchManager = new ResearchManager();
        this.worldEventHandler = new EventHandlerWorld();
        this.serverTickEvents = new ServerTickEventsFML();
        this.entityEventHandler = new EventHandlerEntity();
        this.runicEventHandler = new EventHandlerRunic();
        this.renderEventHandler = new RenderEventHandler();
        this.networkEventHandler = new EventHandlerNetwork();
        PacketHandler.init();
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this.worldEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)this.worldEventHandler);
        FMLCommonHandler.instance().bus().register((Object)this.worldEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)this.entityEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)this.runicEventHandler);
        FMLCommonHandler.instance().bus().register((Object)this.networkEventHandler);
        GameRegistry.registerFuelHandler((IFuelHandler)this.worldEventHandler);
        FMLCommonHandler.instance().bus().register((Object)this.serverTickEvents);
        this.worldGen = new ThaumcraftWorldGenerator();
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.worldGen, (int)0);
        ThaumcraftApi.registerScanEventhandler(new ScanManager());
        Config.save();
        ConfigBlocks.init();
        ConfigItems.init();
        try {
            MapGenStructureIO.func_143031_a(ComponentWizardTower.class, (String)"TCVillageTower");
            MapGenStructureIO.func_143031_a(ComponentBankerHome.class, (String)"TCVillageBanker");
        }
        catch (Throwable var7) {
            log.error("[Thaumcraft] Village tower could not be registered.");
        }
        proxy.registerHandlers();
        this.worldGen.initialize();
        FMLCommonHandler.instance().bus().register((Object)instance);
        Config.registerBiomes();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        proxy.registerDisplayInformation();
        ConfigEntities.init();
        BlockDispenser.field_149943_a.func_82595_a((Object)ConfigItems.itemResource, (Object)new BehaviorDispenseAlumetum());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        VillageWizardManager villageManagerWizard = new VillageWizardManager();
        VillageBankerManager villageManagerBanker = new VillageBankerManager();
        VillagerRegistry.instance().registerVillagerId(ConfigEntities.entWizardId);
        VillagerRegistry.instance().registerVillagerId(ConfigEntities.entBankerId);
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)villageManagerWizard);
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)villageManagerBanker);
        VillagerRegistry.instance().registerVillageTradeHandler(ConfigEntities.entWizardId, (VillagerRegistry.IVillageTradeHandler)villageManagerWizard);
        VillagerRegistry.instance().registerVillageTradeHandler(ConfigEntities.entBankerId, (VillagerRegistry.IVillageTradeHandler)villageManagerBanker);
        proxy.registerKeyBindings();
        DimensionManager.registerProviderType((int)Config.dimensionOuterId, WorldProviderOuter.class, (boolean)false);
        DimensionManager.registerDimension((int)Config.dimensionOuterId, (int)Config.dimensionOuterId);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        Config.initPotions();
        ConfigEntities.initEntitySpawns();
        Config.initModCompatibility();
        ConfigItems.postInit();
        ConfigRecipes.init();
        ConfigAspects.init();
        ConfigResearch.init();
        Config.initLoot();
        Config.initMisc();
        for (FMLInterModComms.IMCMessage message : FMLInterModComms.fetchRuntimeMessages((Object)this)) {
            try {
                String[] t;
                ItemStack crop;
                if (message.key.equals("harvestStandardCrop") && message.isItemStackMessage()) {
                    crop = message.getItemStackValue();
                    CropUtils.addStandardCrop(crop, crop.func_77960_j());
                    log.warn("Adding standard crop support for [" + crop.func_82833_r() + "]");
                }
                if (message.key.equals("harvestClickableCrop") && message.isItemStackMessage()) {
                    crop = message.getItemStackValue();
                    CropUtils.addClickableCrop(crop, crop.func_77960_j());
                    log.warn("Adding clickable crop support for [" + crop.func_82833_r() + "]");
                }
                if (message.key.equals("harvestStackedCrop") && message.isItemStackMessage()) {
                    crop = message.getItemStackValue();
                    CropUtils.addStackedCrop(crop, crop.func_77960_j());
                    log.warn("Adding stacked crop support for [" + crop.func_82833_r() + "]");
                }
                if (message.key.equals("nativeCluster") && message.isStringMessage() && (t = message.getStringValue().split(",")) != null && t.length == 5) {
                    try {
                        ItemStack ore = new ItemStack(Item.func_150899_d((int)Integer.parseInt(t[0])), 1, Integer.parseInt(t[1]));
                        ItemStack cluster = new ItemStack(Item.func_150899_d((int)Integer.parseInt(t[2])), 1, Integer.parseInt(t[3]));
                        Utils.addSpecialMiningResult(ore, cluster, Float.parseFloat(t[4]));
                        log.warn("Adding [" + cluster.func_82833_r() + "] to special result list for [" + ore.func_82833_r() + "]");
                    }
                    catch (Exception ore) {
                        // empty catch block
                    }
                }
                if (message.key.equals("lampBlacklist") && message.isItemStackMessage()) {
                    crop = message.getItemStackValue();
                    CropUtils.blacklistLamp(crop, crop.func_77960_j());
                    log.warn("[Thaumcraft] Blacklisting [" + crop.func_82833_r() + "] for lamp of growth");
                }
                if (message.key.equals("dimensionBlacklist") && message.isStringMessage() && (t = message.getStringValue().split(":")) != null && t.length == 2) {
                    try {
                        ThaumcraftWorldGenerator var10000 = this.worldGen;
                        ThaumcraftWorldGenerator.addDimBlacklist(Integer.parseInt(t[0]), Integer.parseInt(t[1]));
                        log.warn("Blacklisting dimension [" + Integer.parseInt(t[0]) + "] to only spawn TC content at level [" + Integer.parseInt(t[1]) + "]");
                    }
                    catch (Exception var10000) {
                        // empty catch block
                    }
                }
                if (message.key.equals("biomeBlacklist") && message.isStringMessage() && (t = message.getStringValue().split(":")) != null && t.length == 2 && BiomeGenBase.func_150568_d((int)Integer.parseInt(t[0])) != null) {
                    try {
                        ThaumcraftWorldGenerator var20 = this.worldGen;
                        ThaumcraftWorldGenerator.addBiomeBlacklist(Integer.parseInt(t[0]), Integer.parseInt(t[1]));
                        log.warn("Blacklisting [" + BiomeGenBase.func_150568_d((int)Integer.parseInt((String)t[0])).field_76791_y + "] to only spawn TC content at level [" + Integer.parseInt(t[1]) + "]");
                    }
                    catch (Exception var20) {
                        // empty catch block
                    }
                }
                if (!message.key.equals("championWhiteList") || !message.isStringMessage()) continue;
                try {
                    t = message.getStringValue().split(":");
                    Class oclass = (Class)EntityList.field_75625_b.get(t[0]);
                    if (oclass == null) continue;
                    ConfigEntities.championModWhitelist.put(oclass, Integer.parseInt(t[1]));
                    log.warn("Whitelisting [" + t[0] + "] to spawn champion mobs at level [" + Integer.parseInt(t[1]) + "]");
                }
                catch (Exception var11) {
                    log.error("Failed to Whitelist [" + message.getStringValue() + "] with [ championWhiteList ] message.");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(Thaumcraft.imcMessageToString(message), e);
            }
        }
    }

    private static String imcMessageToString(FMLInterModComms.IMCMessage message) {
        ItemStack stack;
        Item item;
        String value = message.isStringMessage() ? message.getStringValue() : (message.isNBTMessage() ? String.valueOf(message.getNBTValue()) : (message.isItemStackMessage() ? ((item = (stack = message.getItemStackValue()).func_77973_b()) == null ? "{item=null}" : "{item=" + GameData.getItemRegistry().func_148750_c((Object)item) + ",damage=" + stack.func_77960_j() + ",stackSize=" + stack.field_77994_a + ')') : "unknown"));
        return "IMCMessage{sender=" + message.getSender() + ",key=" + message.key + ",value=" + value + ')';
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandThaumcraft());
        event.registerServerCommand((ICommand)new CommandBase(){

            public String func_71517_b() {
                return "pgen";
            }

            public String func_71518_a(ICommandSender sender) {
                return "pgen";
            }

            public void func_71515_b(ICommandSender sender, String[] args) {
                if (sender instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)sender;
                    this.generate(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    ThaumcraftWorldGenerator.createRandomNodeAt(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u + 2, (int)player.field_70161_v, player.field_70170_p.field_73012_v, false, true, false);
                }
            }

            private void generate(World world, int i, int j, int k) {
                Random rand = world.field_73012_v;
                for (int x = i - 3; x <= i + 3; ++x) {
                    for (int z = k - 3; z <= k + 3; ++z) {
                        if ((x == i - 3 || x == i + 3) && (z == k - 3 || z == k + 3)) continue;
                        for (int q = -4; q < 5; ++q) {
                            Block bb = world.func_147439_a(x, j + q, z);
                            if (q <= 0 || bb.isReplaceable((IBlockAccess)world, x, j + q, z) || !bb.func_149688_o().func_76230_c() || bb.isFoliage((IBlockAccess)world, x, j + q, z)) {
                                if (rand.nextInt(4) == 0) {
                                    world.func_147449_b(x, j + q, z, Blocks.field_150343_Z);
                                } else {
                                    world.func_147465_d(x, j + q, z, ConfigBlocks.blockCosmeticSolid, 1, 3);
                                }
                            }
                            if (q <= 0) continue;
                            world.func_147468_f(x, j + q, z);
                        }
                        if (x == i && z == k) {
                            world.func_147465_d(x, j + 1, z, ConfigBlocks.blockEldritch, 0, 3);
                            world.func_147465_d(x, j, z, ConfigBlocks.blockCosmeticSolid, 1, 3);
                            TileEntity te = world.func_147438_o(x, j + 1, z);
                            if (te instanceof TileEldritchAltar) {
                                ((TileEldritchAltar)te).setEyes((byte)4);
                            }
                            world.func_147465_d(x, j + 3, z, ConfigBlocks.blockEldritch, 1, 3);
                            world.func_147465_d(x, j + 4, z, ConfigBlocks.blockEldritch, 2, 3);
                            world.func_147465_d(x, j + 5, z, ConfigBlocks.blockEldritch, 2, 3);
                            world.func_147465_d(x, j + 6, z, ConfigBlocks.blockEldritch, 2, 3);
                            world.func_147465_d(x, j + 7, z, ConfigBlocks.blockEldritch, 2, 3);
                            continue;
                        }
                        if ((x != i - 3 && x != i + 3 || Math.abs((z - k) % 2) != 1) && (z != k - 3 && z != k + 3 || Math.abs((x - i) % 2) != 1) || Math.abs(x - i) == Math.abs(z - k)) continue;
                        world.func_147465_d(x, j, z, ConfigBlocks.blockCosmeticSolid, 1, 3);
                        world.func_147465_d(x, j + 1, z, ConfigBlocks.blockEldritch, 3, 3);
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals("Thaumcraft")) {
            Config.syncConfigurable();
            if (Config.config != null && Config.config.hasChanged()) {
                Config.save();
            }
        }
    }

    public static void addWarpToPlayer(EntityPlayer player, int amount, boolean temporary) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        if (!player.field_70170_p.field_72995_K && proxy.getPlayerKnowledge() != null && (temporary || amount >= 0) && amount != 0) {
            if (temporary) {
                if (amount < 0 && proxy.getPlayerKnowledge().getWarpTemp(player.func_70005_c_()) <= 0) {
                    return;
                }
                proxy.getPlayerKnowledge().addWarpTemp(player.func_70005_c_(), amount);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncWarp(player, 2), (EntityPlayerMP)player);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketWarpMessage(player, 2, amount), (EntityPlayerMP)player);
            } else {
                proxy.getPlayerKnowledge().addWarpPerm(player.func_70005_c_(), amount);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncWarp(player, 0), (EntityPlayerMP)player);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketWarpMessage(player, 0, amount), (EntityPlayerMP)player);
            }
            proxy.getPlayerKnowledge().setWarpCounter(player.func_70005_c_(), proxy.getPlayerKnowledge().getWarpTotal(player.func_70005_c_()));
        }
    }

    public static void addStickyWarpToPlayer(EntityPlayer player, int amount) {
        if (!(player.field_70170_p.field_72995_K || proxy.getPlayerKnowledge() == null || amount == 0 || amount < 0 && proxy.getPlayerKnowledge().getWarpSticky(player.func_70005_c_()) <= 0)) {
            proxy.getPlayerKnowledge().addWarpSticky(player.func_70005_c_(), amount);
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncWarp(player, 1), (EntityPlayerMP)player);
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketWarpMessage(player, 1, amount), (EntityPlayerMP)player);
            proxy.getPlayerKnowledge().setWarpCounter(player.func_70005_c_(), proxy.getPlayerKnowledge().getWarpTotal(player.func_70005_c_()));
        }
    }

    static {
        log = LogManager.getLogger((String)"THAUMCRAFT");
        isHalloween = false;
        tabTC = new CreativeTabThaumcraft(CreativeTabs.getNextID(), "thaumcraft");
    }
}

