/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items.wand.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.helper.TaintedMagicHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.client.fx.bolt.FXLightningBolt;
import thaumcraft.codechicken.lib.vec.Vector3;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ItemFocusShockwave
extends ItemFocusBasic {
    private static final AspectList COST = new AspectList().add(Aspect.AIR, 150).add(Aspect.ENTROPY, 100);
    private IIcon depthIcon;

    public ItemFocusShockwave() {
        this.func_77637_a(TaintedMagic.tabTM);
        this.func_77655_b("ItemFocusShockwave");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("taintedmagic:ItemFocusShockwave");
        this.depthIcon = ir.func_94245_a("taintedmagic:ItemFocusShockwave_depth");
    }

    public IIcon getFocusDepthLayerIcon(ItemStack stack) {
        return this.depthIcon;
    }

    public String getSortingHelper(ItemStack stack) {
        return "SHOCKWAVE" + super.getSortingHelper(stack);
    }

    public int getFocusColor(ItemStack stack) {
        return 11581380;
    }

    public AspectList getVisCost(ItemStack stack) {
        return COST;
    }

    public int getActivationCooldown(ItemStack stack) {
        return 10000;
    }

    public boolean isVisCostPerTick(ItemStack stack) {
        return false;
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack stack) {
        return ItemFocusBasic.WandFocusAnimation.WAVE;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        list.add(" ");
        list.add(EnumChatFormatting.BLUE + "+" + new String(this.isUpgradedWith(stack, FocusUpgradeType.enlarge) ? Integer.toString(15 + this.getUpgradeLevel(stack, FocusUpgradeType.enlarge)) : "15") + " " + StatCollector.func_74838_a((String)"text.radius"));
    }

    public ItemStack onFocusRightClick(ItemStack stack, World world, EntityPlayer player, MovingObjectPosition mop) {
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        int potency = wand.getFocusPotency(stack);
        int enlarge = wand.getFocusEnlarge(stack);
        if (wand.consumeAllVis(stack, player, this.getVisCost(stack), true, false)) {
            List ents = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)(player.field_70165_t + 1.0), (double)(player.field_70163_u + 1.0), (double)(player.field_70161_v + 1.0)).func_72314_b(15.0 + (double)enlarge, 15.0 + (double)enlarge, 15.0 + (double)enlarge));
            if (ents != null && ents.size() > 0) {
                for (EntityLivingBase entity : ents) {
                    if (entity == player || !entity.func_70089_S() || entity.func_85032_ar()) continue;
                    double dist = TaintedMagicHelper.getDistanceTo(player, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    if (dist < 7.0) {
                        entity.func_70097_a(DamageSource.field_76376_m, 2.0f + (float)potency);
                    }
                    Vector3 vel = TaintedMagicHelper.getVectorBetweenEntities((Entity)entity, (Entity)player);
                    entity.func_70024_g(vel.x * (5.0 + (double)potency), 1.5 + (double)potency * 0.1, vel.z * (5.0 + (double)potency));
                    if (!world.field_72995_K) continue;
                    ItemFocusShockwave.spawnParticles(world, player, (Entity)entity);
                }
            }
            world.func_72956_a((Entity)player, "taintedmagic:shockwave", 5.0f, 1.5f * (float)Math.random());
            return stack;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnParticles(World world, EntityPlayer player, Entity entity) {
        FXLightningBolt bolt = new FXLightningBolt(world, (Entity)player, entity, world.field_73012_v.nextLong(), 4);
        bolt.defaultFractal();
        bolt.setType(2);
        bolt.setWidth(0.125f);
        bolt.finalizeBolt();
        for (int a = 0; a < 5; ++a) {
            Random random = player.field_70170_p.field_73012_v;
            float x = (float)entity.field_70165_t + (random.nextFloat() - random.nextFloat()) * 0.6f;
            float y = (float)entity.field_70163_u + (random.nextFloat() - random.nextFloat()) * 0.6f;
            float z = (float)entity.field_70161_v + (random.nextFloat() - random.nextFloat()) * 0.6f;
            Thaumcraft.proxy.sparkle(x, y, z, 2.0f + random.nextFloat(), 2, 0.05f + random.nextFloat() * 0.05f);
        }
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack stack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.potency};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.potency};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.potency};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.potency};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.potency};
            }
        }
        return null;
    }
}

