/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items.wand.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.entities.EntityDarkMatter;
import taintedmagic.common.entities.EntityDiffusion;
import taintedmagic.common.items.wand.foci.TMFocusUpgrades;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ItemFocusDarkMatter
extends ItemFocusBasic {
    private IIcon depthIcon;
    private IIcon ornIcon;
    private long soundDelay = 0L;
    private static final AspectList COST = new AspectList().add(Aspect.ENTROPY, 150).add(Aspect.FIRE, 100);
    private static final AspectList COST_SANITY = COST.copy().add(Aspect.ORDER, 50);
    private static final AspectList COST_CORROSIVE = COST.copy().add(Aspect.WATER, 50);

    public ItemFocusDarkMatter() {
        this.func_77637_a(TaintedMagic.tabTM);
        this.func_77655_b("ItemFocusDarkMatter");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("taintedmagic:ItemFocusDarkMatter");
        this.depthIcon = ir.func_94245_a("taintedmagic:ItemFocusDarkMatter_depth");
        this.ornIcon = ir.func_94245_a("thaumcraft:focus_warding_orn");
    }

    public IIcon getFocusDepthLayerIcon(ItemStack stack) {
        return this.depthIcon;
    }

    public IIcon getOrnament(ItemStack stack) {
        return this.ornIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int meta) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int meta, int pass) {
        return pass == 0 ? this.ornIcon : this.icon;
    }

    public String getSortingHelper(ItemStack stack) {
        return "ELDRITCH" + super.getSortingHelper(stack);
    }

    public int getFocusColor(ItemStack stack) {
        return 24;
    }

    public AspectList getVisCost(ItemStack stack) {
        AspectList cost;
        AspectList aspectList = this.isUpgradedWith(stack, TMFocusUpgrades.sanity) ? COST_SANITY : (cost = this.isUpgradedWith(stack, TMFocusUpgrades.corrosive) ? COST_CORROSIVE : COST);
        if (this.isUpgradedWith(stack, TMFocusUpgrades.diffusion)) {
            cost = cost.copy();
            for (Aspect aspect : cost.getAspects()) {
                cost.reduce(aspect, (int)((double)cost.getAmount(aspect) * 0.9));
            }
        }
        return cost;
    }

    public int getActivationCooldown(ItemStack stack) {
        return this.isUpgradedWith(stack, TMFocusUpgrades.diffusion) ? -1 : 1000;
    }

    public boolean isVisCostPerTick(ItemStack stack) {
        return this.isUpgradedWith(stack, TMFocusUpgrades.diffusion);
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack stack) {
        return this.isUpgradedWith(stack, TMFocusUpgrades.diffusion) ? ItemFocusBasic.WandFocusAnimation.CHARGE : ItemFocusBasic.WandFocusAnimation.WAVE;
    }

    public ItemStack onFocusRightClick(ItemStack stack, World world, EntityPlayer player, MovingObjectPosition mop) {
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        if (this.isUpgradedWith(wand.getFocusItem(stack), TMFocusUpgrades.diffusion)) {
            player.func_71008_a(stack, Integer.MAX_VALUE);
        } else {
            if (!world.field_72995_K && wand.consumeAllVis(stack, player, this.getVisCost(wand.getFocusItem(stack)), true, false)) {
                EntityDarkMatter proj = new EntityDarkMatter(world, (EntityLivingBase)player, 16.0f + (float)wand.getFocusPotency(stack), wand.getFocusEnlarge(stack), this.isUpgradedWith(wand.getFocusItem(stack), TMFocusUpgrades.corrosive));
                world.func_72838_d((Entity)proj);
                if (!this.isUpgradedWith(wand.getFocusItem(stack), TMFocusUpgrades.sanity) && world.field_73012_v.nextInt(20) == 0) {
                    Thaumcraft.addStickyWarpToPlayer((EntityPlayer)player, (int)1);
                }
                world.func_72956_a((Entity)player, "thaumcraft:egattack", 0.4f, 1.0f + world.field_73012_v.nextFloat() * 0.1f);
            }
            player.func_71038_i();
        }
        return stack;
    }

    public void onUsingFocusTick(ItemStack stack, EntityPlayer player, int i) {
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        if (!wand.consumeAllVis(stack, player, this.getVisCost(wand.getFocusItem(stack)), false, false)) {
            player.func_71034_by();
            return;
        }
        if (!player.field_70170_p.field_72995_K && this.soundDelay < System.currentTimeMillis()) {
            player.field_70170_p.func_72956_a((Entity)player, "thaumcraft:wind", 0.3f + 0.2f * (float)Math.random(), 0.75f + 0.25f * (float)Math.random());
            this.soundDelay = System.currentTimeMillis() + 750L;
        }
        if (!player.field_70170_p.field_72995_K && wand.consumeAllVis(stack, player, this.getVisCost(wand.getFocusItem(stack)), true, false)) {
            for (int a = 0; a < 2 + wand.getFocusPotency(stack); ++a) {
                EntityDiffusion proj = new EntityDiffusion(player.field_70170_p, (EntityLivingBase)player, this.isUpgradedWith(wand.getFocusItem(stack), FocusUpgradeType.enlarge) ? 12.0f + (float)wand.getFocusEnlarge(stack) : 9.0f, 12.0f + (float)wand.getFocusPotency(stack), this.isUpgradedWith(wand.getFocusItem(stack), TMFocusUpgrades.corrosive));
                proj.field_70165_t += proj.field_70159_w;
                proj.field_70163_u += proj.field_70181_x;
                proj.field_70161_v += proj.field_70179_y;
                player.field_70170_p.func_72838_d((Entity)proj);
            }
            if (!this.isUpgradedWith(wand.getFocusItem(stack), TMFocusUpgrades.sanity) && player.field_70170_p.field_73012_v.nextInt(1000) == 0) {
                Thaumcraft.addStickyWarpToPlayer((EntityPlayer)player, (int)1);
            }
        }
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack stack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.enlarge};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.enlarge};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.enlarge, TMFocusUpgrades.corrosive, TMFocusUpgrades.sanity};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.enlarge};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.enlarge, TMFocusUpgrades.diffusion};
            }
        }
        return null;
    }

    public boolean canApplyUpgrade(ItemStack stack, EntityPlayer player, FocusUpgradeType type, int rank) {
        return !type.equals((Object)TMFocusUpgrades.diffusion) || ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)"DIFFUSIONUPGRADE");
    }
}

