/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items.tools;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import taintedmagic.api.IHeldItemHUD;
import taintedmagic.api.IRenderInventoryItem;
import taintedmagic.client.model.ModelKatana;
import taintedmagic.client.model.ModelSaya;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.helper.TaintedMagicHelper;
import taintedmagic.common.items.wand.foci.ItemFocusShockwave;
import taintedmagic.common.network.PacketHandler;
import taintedmagic.common.network.PacketKatanaAttack;
import thaumcraft.api.IRepairable;
import thaumcraft.api.IWarpingGear;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.codechicken.lib.vec.Vector3;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.projectile.EntityExplosiveOrb;

public class ItemKatana
extends Item
implements IWarpingGear,
IRepairable,
IRenderInventoryItem,
IHeldItemHUD {
    private static final int SUBTYPES = 3;
    public static final String TAG_INSCRIPTION = "inscription";
    public static final String TAG_COOLDOWN = "cooldown";
    private static final int CHARGE_TICKS = 20;
    private static final int COOLDOWN_TICKS = 140;
    private static final ResourceLocation TEXTURE_THAUMIUM = new ResourceLocation("taintedmagic:textures/models/ModelKatanaThaumium.png");
    private static final ResourceLocation TEXTURE_VOIDMETAL = new ResourceLocation("taintedmagic:textures/models/ModelKatanaVoidmetal.png");
    private static final ResourceLocation TEXTURE_SHADOWMETAL = new ResourceLocation("taintedmagic:textures/models/ModelKatanaShadowmetal.png");
    public static final ModelKatana KATANA = new ModelKatana();
    public static final ModelSaya SAYA = new ModelSaya();
    private int ticksInUse = 0;

    public ItemKatana() {
        this.func_77637_a(TaintedMagic.tabTM);
        this.func_77655_b("ItemKatana");
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return false;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.bow;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int a = 0; a < 3; ++a) {
            list.add(new ItemStack((Item)this, 1, a));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77960_j();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        if (stack.func_77960_j() == 1) {
            list.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"enchantment.special.sapless"));
        }
        if (stack.func_77960_j() == 2) {
            list.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"enchantment.special.sapgreat"));
        }
        list.add(" ");
        list.add("\u00a79+" + this.getAttackDamage(stack) + " " + StatCollector.func_74838_a((String)"text.attackdamage"));
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b(TAG_INSCRIPTION)) {
            list.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)("text.katana.inscription." + stack.field_77990_d.func_74762_e(TAG_INSCRIPTION))));
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    public int getWarp(ItemStack stack, EntityPlayer player) {
        return stack.func_77960_j() == 0 ? 0 : (stack.func_77960_j() == 1 ? 3 : 7);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity, EntityLivingBase player) {
        if (!(entity.field_70170_p.field_72995_K || entity instanceof EntityPlayer && player instanceof EntityPlayer && !MinecraftServer.func_71276_C().func_71219_W())) {
            if (stack.func_77960_j() == 1) {
                entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 60));
            }
            if (stack.func_77960_j() == 2) {
                entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 60));
                entity.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 120));
            }
            if (ItemKatana.hasAnyInscription(stack)) {
                switch (this.getInscription(stack)) {
                    case 0: {
                        entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)).func_76361_j(), this.getAttackDamage(stack));
                        entity.func_70015_d(3);
                        break;
                    }
                    case 1: {
                        entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)).func_82726_p(), this.getAttackDamage(stack));
                        entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 140));
                        break;
                    }
                    case 2: {
                        entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)).func_82726_p(), this.getAttackDamage(stack));
                        entity.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 60));
                        break;
                    }
                }
            } else {
                entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)), this.getAttackDamage(stack));
            }
        }
        player.field_70170_p.func_72956_a((Entity)player, "thaumcraft:swing", 0.5f + (float)Math.random(), 0.5f + (float)Math.random());
        return super.func_77644_a(stack, entity, player);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!this.hasCooldown(stack)) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int i) {
        super.onUsingTick(stack, player, i);
        this.ticksInUse = this.func_77626_a(stack) - i;
        float j = 0.75f + (float)Math.random() * 0.25f;
        if (player.field_70173_aa % 5 == 0) {
            player.field_70170_p.func_72956_a((Entity)player, "thaumcraft:wind", j * 0.1f, j);
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int i) {
        super.func_77615_a(stack, world, player, i);
        if (this.isFullyCharged(player)) {
            if (!ItemKatana.hasAnyInscription(stack) || player.func_70093_af()) {
                if (world.field_72995_K) {
                    MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
                    float mul = 1.5f;
                    if (world.field_73012_v.nextInt(10) == 0) {
                        mul += 1.0f;
                    }
                    if (mop.field_72308_g != null) {
                        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketKatanaAttack(mop.field_72308_g, player, this.getAttackDamage(stack) * mul));
                    }
                }
                player.field_70170_p.func_72956_a((Entity)player, "thaumcraft:swing", 0.5f + (float)Math.random(), 0.5f + (float)Math.random());
                player.func_71038_i();
            } else {
                switch (this.getInscription(stack)) {
                    case 0: {
                        EntityExplosiveOrb proj = new EntityExplosiveOrb(world, (EntityLivingBase)player);
                        proj.strength = this.getAttackDamage(stack) * 0.25f;
                        proj.field_70165_t += proj.field_70159_w;
                        proj.field_70163_u += proj.field_70181_x;
                        proj.field_70161_v += proj.field_70179_y;
                        if (!world.field_72995_K) {
                            world.func_72838_d((Entity)proj);
                        }
                        player.func_71038_i();
                        break;
                    }
                    case 1: {
                        List ents = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)(player.field_70165_t + 1.0), (double)(player.field_70163_u + 1.0), (double)(player.field_70161_v + 1.0)).func_72314_b(10.0, 10.0, 10.0));
                        if (ents != null && ents.size() > 0) {
                            for (EntityLivingBase entity : ents) {
                                if (entity == player || !entity.func_70089_S() || entity.func_85032_ar()) continue;
                                entity.func_70097_a(DamageSource.field_76376_m, this.getAttackDamage(stack) * 0.25f);
                                Vector3 movement = TaintedMagicHelper.getVectorBetweenEntities((Entity)entity, (Entity)player);
                                entity.func_70024_g(movement.x * 5.0, 1.5, movement.z * 5.0);
                                if (!world.field_72995_K) continue;
                                ItemFocusShockwave.spawnParticles(world, player, (Entity)entity);
                            }
                        }
                        world.func_72956_a((Entity)player, "taintedmagic:shockwave", 5.0f, 1.5f * (float)Math.random());
                        player.func_71038_i();
                        break;
                    }
                    case 2: {
                        player.func_70691_i((player.func_110138_aP() - player.func_110143_aJ()) * 0.5f);
                        List ents = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)(player.field_70165_t + 1.0), (double)(player.field_70163_u + 1.0), (double)(player.field_70161_v + 1.0)).func_72314_b(5.0, 5.0, 5.0));
                        if (ents != null && ents.size() > 0) {
                            for (EntityLivingBase entity : ents) {
                                if (entity == player || !entity.func_70089_S() || entity.func_85032_ar()) continue;
                                entity.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 100, 1));
                            }
                        }
                        player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 60, 1));
                        player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 120, 1));
                        if (world.field_72995_K) {
                            for (int a = 0; a < 18; ++a) {
                                Thaumcraft.proxy.wispFX2(world, player.field_70165_t + world.field_73012_v.nextGaussian() * 0.25, player.field_70121_D.field_72338_b + 1.0 + world.field_73012_v.nextGaussian() * 0.5, player.field_70161_v + world.field_73012_v.nextGaussian() * 0.25, 0.25f + (float)Math.random() * 0.25f, 3, true, false, 0.02f);
                                Thaumcraft.proxy.sparkle((float)player.field_70165_t + (float)world.field_73012_v.nextGaussian() * 0.25f, (float)player.field_70121_D.field_72338_b + 1.0f + (float)world.field_73012_v.nextGaussian() * 0.5f, (float)player.field_70161_v + (float)world.field_73012_v.nextGaussian() * 0.25f, 5);
                            }
                        }
                        world.func_72956_a((Entity)player, "thaumcraft:wand", 1.0f, 0.9f + (float)Math.random() * 0.1f);
                        player.func_71038_i();
                        break;
                    }
                }
                this.setCooldown(stack, 140);
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int i, boolean b) {
        if (this.hasCooldown(stack)) {
            this.setCooldown(stack, this.getCooldown(stack) - 1);
        }
    }

    private boolean isFullyCharged(EntityPlayer player) {
        float f = Math.min((float)this.ticksInUse / 20.0f, 1.0f);
        return f == 1.0f;
    }

    public static boolean hasAnyInscription(ItemStack stack) {
        return stack.func_77942_o() && stack.field_77990_d.func_74764_b(TAG_INSCRIPTION);
    }

    private int getInscription(ItemStack stack) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b(TAG_INSCRIPTION)) {
            return stack.field_77990_d.func_74762_e(TAG_INSCRIPTION);
        }
        return 0;
    }

    private boolean hasCooldown(ItemStack stack) {
        return stack.func_77942_o() && stack.field_77990_d.func_74762_e(TAG_COOLDOWN) > 0;
    }

    private void setCooldown(ItemStack stack, int cooldown) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a(TAG_COOLDOWN, cooldown);
    }

    private int getCooldown(ItemStack stack) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b(TAG_COOLDOWN)) {
            return stack.field_77990_d.func_74762_e(TAG_COOLDOWN);
        }
        return 0;
    }

    private float getAttackDamage(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return 14.25f;
            }
            case 1: {
                return 17.5f;
            }
            case 2: {
                return 20.75f;
            }
        }
        return 0.0f;
    }

    public static ResourceLocation getTexture(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return TEXTURE_THAUMIUM;
            }
            case 1: {
                return TEXTURE_VOIDMETAL;
            }
            case 2: {
                return TEXTURE_SHADOWMETAL;
            }
        }
        return null;
    }

    @Override
    public void renderHUD(ScaledResolution res, EntityPlayer player, ItemStack stack, float partialTicks, float fract) {
        Tessellator t = Tessellator.field_78398_a;
        float overlay = Math.min(this.hasCooldown(stack) ? (float)this.getCooldown(stack) / 140.0f : (float)player.func_71057_bx() / 20.0f, 1.0f);
        float scale = 0.315f;
        double x = (double)res.func_78326_a() / 2.0 / (double)0.315f + 30.0;
        double x2 = x + 16.0;
        double y = (double)res.func_78328_b() / (double)0.315f - (player.field_71075_bZ.field_75098_d ? 100.0 : 150.0);
        double y2 = y + 16.0;
        GL11.glPushMatrix();
        GL11.glScalef((float)0.315f, (float)0.315f, (float)0.315f);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        GL11.glBlendFunc((int)770, (int)771);
        UtilsFX.bindTexture((ResourceLocation)new ResourceLocation("thaumcraft:textures/misc/script.png"));
        for (int rune = 0; rune < 16; ++rune) {
            float red = MathHelper.func_76126_a((float)((float)(player.field_70173_aa + rune * 5) / 5.0f)) * 0.1f + 0.8f;
            float green = MathHelper.func_76126_a((float)((float)(player.field_70173_aa + rune * 5) / 7.0f)) * 0.1f + 0.7f;
            float blue = 0.4f;
            float alpha = MathHelper.func_76126_a((float)((float)(player.field_70173_aa + rune * 5) / 10.0f)) * 0.3f;
            float f = 0.0625f * (float)rune;
            float f1 = f + 0.0625f;
            float f2 = 0.0f;
            float f3 = 1.0f;
            t.func_78382_b();
            t.func_78380_c(240);
            t.func_78369_a(red, green, blue, (alpha + 0.7f) * fract);
            t.func_78374_a(x + (double)(rune * 16) - (double)alpha, y2 + (double)alpha, 0.0, (double)f, 1.0);
            t.func_78374_a(x2 + (double)(rune * 16) + (double)alpha, y2 + (double)alpha, 0.0, (double)f1, 1.0);
            t.func_78374_a(x2 + (double)(rune * 16) + (double)alpha, y - (double)alpha, 0.0, (double)f1, 0.0);
            t.func_78374_a(x + (double)(rune * 16) - (double)alpha, y - (double)alpha, 0.0, (double)f, 0.0);
            t.func_78381_a();
            if (!(Math.ceil(16.0f * overlay) > (double)rune)) continue;
            Color color = new Color(Color.HSBtoRGB((float)rune / 16.0f * 0.3f, 1.0f, 1.0f));
            if (this.hasCooldown(stack)) {
                color = new Color(Color.HSBtoRGB((16.0f - (float)rune) / 16.0f * 0.3f, 1.0f, 1.0f));
            }
            red = (float)color.getRed() / 255.0f;
            green = (float)color.getGreen() / 255.0f;
            blue = (float)color.getBlue() / 255.0f;
            t.func_78382_b();
            t.func_78380_c(240);
            t.func_78369_a(red, green, blue, 0.9f + alpha);
            t.func_78374_a(x + (double)(rune * 16) - (double)alpha, y2 + (double)alpha, 0.0, (double)f, 1.0);
            t.func_78374_a(x2 + (double)(rune * 16) + (double)alpha, y2 + (double)alpha, 0.0, (double)f1, 1.0);
            t.func_78374_a(x2 + (double)(rune * 16) + (double)alpha, y - (double)alpha, 0.0, (double)f1, 0.0);
            t.func_78374_a(x + (double)(rune * 16) - (double)alpha, y - (double)alpha, 0.0, (double)f, 0.0);
            t.func_78381_a();
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    @Override
    public void render(EntityPlayer player, ItemStack stack, float partialTicks) {
        GL11.glPushMatrix();
        int light = player.func_70070_b(0.0f);
        int lightmapX = light % 65536;
        int lightmapY = light / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapX, (float)lightmapY);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glRotatef((float)55.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.6f, (float)2.25f, (float)1.25f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ItemKatana.getTexture(stack));
        SAYA.render(0.0625f);
        GL11.glPopMatrix();
        if (player.func_70694_bm() == null || player.func_70694_bm() != stack) {
            GL11.glPushMatrix();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glRotatef((float)55.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.6f, (float)2.25f, (float)1.25f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ItemKatana.getTexture(stack));
            KATANA.render(0.0625f);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }
}

