/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.witch;

import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.EffectHelper;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.witch.Entity_SpecialWitch;

public class EntityRageWitch
extends Entity_SpecialWitch {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "witch/rage.png")};

    public EntityRageWitch(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
    }

    @Override
    protected void initTypeAI() {
        this.setMeleeAI();
    }

    @Override
    public void adjustTypeAttributes() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 4.0);
        ItemStack itemStack = new ItemStack(Items.field_151010_B);
        float tension = this.field_70170_p.func_147462_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.field_70146_Z.nextFloat() < 0.25f * tension) {
            try {
                EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)itemStack, (int)((int)(5.0f + tension * (float)this.field_70146_Z.nextInt(18))));
            }
            catch (Exception ex) {
                _SpecialMobs.console("Error applying enchantments! entity:" + this.toString());
                ex.printStackTrace();
            }
        }
        this.func_70062_b(0, itemStack);
    }

    @Override
    protected void tryDrinkPotionByType() {
        if (this.field_70146_Z.nextFloat() < 0.2f && this.func_70638_az() != null && !this.func_70644_a(Potion.field_76429_m) && !this.func_70644_a(Potion.field_76420_g)) {
            this.drinkPotion(this.makeRagePotion());
        }
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151065_br, 1);
        }
    }

    protected void func_70600_l(int superRare) {
        this.func_70099_a(this.makeRagePotion(), 0.0f);
    }

    private ItemStack makeRagePotion() {
        ItemStack potion = new ItemStack((Item)Items.field_151068_bn, 1, 8201);
        EffectHelper.setItemName(potion, "Potion of Rage", 15);
        EffectHelper.addPotionEffect(potion, Potion.field_76420_g, 300, 0);
        EffectHelper.addPotionEffect(potion, Potion.field_76429_m, 1500, 0);
        return potion;
    }
}

