/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.slime;

import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.slime.Entity_SpecialSlime;

public class EntityBlackberrySlime
extends Entity_SpecialSlime {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "slime/blackberry.png")};
    private int fuseTime = 0;

    public EntityBlackberrySlime(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
    }

    @Override
    protected int getTypeXp() {
        return 2;
    }

    @Override
    protected void adjustHealthAttribute() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 6.0);
    }

    @Override
    protected void attackEntityByType(EntityPlayer target) {
        float explosionPower = this.func_70809_q();
        if (target != null && target.func_70068_e((Entity)this) < (double)(9.0f + (explosionPower - 1.0f) * 2.0f)) {
            if (this.fuseTime == 0) {
                this.func_85030_a("creeper.primed", 1.0f, 0.5f);
            } else if (this.fuseTime >= 30) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, explosionPower, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.func_70106_y();
            }
            this.getSpecialData().setRenderScale(this.getSpecialData().getRenderScale() + 0.013f);
            ++this.fuseTime;
            this.field_70701_bs = 0.0f;
            this.field_70702_br = 0.0f;
            this.field_70122_E = false;
        } else if (this.fuseTime > 0) {
            --this.fuseTime;
            this.getSpecialData().setRenderScale(this.getSpecialData().getRenderScale() - 0.013f);
            this.field_70701_bs = 0.0f;
            this.field_70702_br = 0.0f;
            this.field_70122_E = false;
        }
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        if (this.func_70809_q() == 1) {
            int i = this.field_70146_Z.nextInt(3) + looting;
            while (i-- > 0) {
                this.func_145779_a(Items.field_151016_H, 1);
            }
            if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
                this.func_145779_a(Items.field_151100_aR, 1);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74774_a("FuseTime", (byte)this.fuseTime);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("FuseTime")) {
            this.fuseTime = tag.func_74771_c("FuseTime");
        }
    }
}

