/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.impl.forge;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import lain.mods.skins.api.interfaces.ISkinTexture;
import lain.mods.skins.impl.SkinData;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class CustomSkinTexture
extends AbstractTexture
implements ISkinTexture {
    private final ResourceLocation _location;
    private WeakReference<ByteBuffer> _data;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BufferedImage loadImage(ByteBuffer buf) {
        try (InputStream in = SkinData.wrapByteBufferAsInputStream(buf);){
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public CustomSkinTexture(ResourceLocation location, ByteBuffer data) {
        this._location = location;
        if (data == null) {
            throw new IllegalArgumentException("buffer must not be null");
        }
        this._data = new WeakReference<ByteBuffer>(data);
    }

    @Override
    public ByteBuffer getData() {
        return (ByteBuffer)this._data.get();
    }

    public ResourceLocation getLocation() {
        return this._location;
    }

    public void func_110551_a(IResourceManager resMan) throws IOException {
        this.func_147631_c();
        ByteBuffer buf = (ByteBuffer)this._data.get();
        if (buf == null) {
            throw new FileNotFoundException(this.getLocation().toString());
        }
        BufferedImage image = CustomSkinTexture.loadImage(buf);
        if (image == null) {
            throw new FileNotFoundException(this.getLocation().toString());
        }
        TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)image, (boolean)false, (boolean)false);
    }
}

