/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.gt5;

import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.metatileentity.BaseTileEntity;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.powerconverters.position.BlockPosition;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.systems.gt5.BaseGTProducerTileEntity;

public class TileEntityGregTechProducer
extends BaseGTProducerTileEntity<IEnergyConnected>
implements IEnergyConnected {
    private static final long[] typeVoltageIndex = new long[]{8L, 32L, 128L, 512L, 2048L, 8192L, 32768L, 131072L, 524288L};
    private byte voltageIndex;
    private long voltage;
    private long maxAmperage;
    private double lastSentEnergy;
    private byte gtTileColor;
    private boolean needsBlockUpdate = true;

    public TileEntityGregTechProducer() {
        this(0);
    }

    public TileEntityGregTechProducer(int voltageIndex) {
        super(PowerSystemManager.getInstance().getPowerSystemByName("GT"), voltageIndex, IEnergyConnected.class);
        this.setVoltageByIndex(voltageIndex);
        this.setMaxAmperage(1L);
        this.setColorization((byte)-1);
    }

    private void setVoltageByIndex(int index) {
        if (index > 8) {
            index = 0;
        }
        this.voltage = typeVoltageIndex[index];
        this.voltageIndex = (byte)index;
    }

    private void setMaxAmperage(long amp) {
        this.maxAmperage = amp;
    }

    public long incMaxAmperage() {
        long tmp = this.maxAmperage + 1L;
        if (tmp > 8L) {
            tmp = 1L;
        }
        this.maxAmperage = tmp;
        return this.maxAmperage;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.needsBlockUpdate) {
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity te = BlockPosition.getAdjacentTileEntity(this, d);
                if (!(te instanceof BaseTileEntity)) continue;
                ((BaseTileEntity)te).onAdjacentBlockChange(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.onNeighboorChanged();
            this.needsBlockUpdate = false;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setVoltageByIndex(tag.func_74771_c("voltageIndex"));
        this.setMaxAmperage(tag.func_74763_f("maxAmperage"));
        this.setColorization(tag.func_74771_c("gtTileColor"));
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("voltageIndex", this.voltageIndex);
        tag.func_74772_a("maxAmperage", this.maxAmperage);
        tag.func_74774_a("gtTileColor", this.gtTileColor);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
    }

    @Override
    public double produceEnergy(double energy) {
        boolean powered = this.func_145831_w().func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0;
        double EU = energy / (double)this.getPowerSystem().getInternalEnergyPerOutput(0);
        long lEU = (long)EU;
        long usedEU = 0L;
        if (!powered && lEU >= this.voltage) {
            long ampsLeft = lEU / this.voltage;
            for (Map.Entry it : this.getTiles().entrySet()) {
                byte tColor;
                if (ampsLeft < this.maxAmperage) break;
                IEnergyConnected t = (IEnergyConnected)it.getValue();
                if (this.getColorization() >= 0 && (tColor = t.getColorization()) >= 0 && tColor != this.getColorization()) continue;
                long ampsUsed = t.injectEnergyUnits((byte)it.getKey().getOpposite().ordinal(), this.voltage, this.maxAmperage);
                ampsLeft -= ampsUsed;
                usedEU += ampsUsed * this.voltage;
            }
        }
        return energy - (double)((float)usedEU * this.getPowerSystem().getInternalEnergyPerOutput(0));
    }

    public long injectEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        return 0L;
    }

    public boolean inputEnergyFrom(byte aSide) {
        return false;
    }

    public boolean outputsEnergyTo(byte aSide) {
        return true;
    }

    public byte getColorization() {
        return -1;
    }

    public byte setColorization(byte aColor) {
        return -1;
    }
}

