/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.gt5;

import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.metatileentity.BaseTileEntity;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.powerconverters.position.BlockPosition;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.systems.gt5.BaseGTConsumerTileEntity;

public class TileEntityGregTechConsumer
extends BaseGTConsumerTileEntity<IEnergyConnected>
implements IEnergyConnected {
    private static final long[] typeVoltageIndex = new long[]{8L, 32L, 128L, 512L, 2048L, 8192L, 32768L, 131072L, 524288L};
    private byte voltageIndex;
    private long maxSafeVoltage;
    private byte gtTileColor;
    private double _euLastTick;
    private long _lastTickInjected;
    private boolean needsBlockUpdate = true;

    public TileEntityGregTechConsumer() {
        this(0);
    }

    public TileEntityGregTechConsumer(int voltageIndex) {
        super(PowerSystemManager.getInstance().getPowerSystemByName("GT"), voltageIndex, IEnergyConnected.class);
        this.setVoltageByIndex(voltageIndex);
        this.setColorization((byte)-1);
    }

    private void setVoltageByIndex(int vi) {
        if (vi > 8) {
            vi = 0;
        }
        this.voltageIndex = (byte)vi;
        this.maxSafeVoltage = typeVoltageIndex[this.voltageIndex];
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_72820_D() - this._lastTickInjected > 2L) {
                this._euLastTick = 0.0;
            }
            if (this.needsBlockUpdate) {
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity te = BlockPosition.getAdjacentTileEntity(this, d);
                    if (!(te instanceof BaseTileEntity)) continue;
                    ((BaseTileEntity)te).onAdjacentBlockChange(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                this.onNeighboorChanged();
                this.needsBlockUpdate = false;
            }
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
    }

    @Override
    public double getInputRate() {
        return this._euLastTick;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setVoltageByIndex(tag.func_74771_c("voltageIndex"));
        this.setColorization(tag.func_74771_c("gtTileColor"));
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("voltageIndex", this.voltageIndex);
        tag.func_74774_a("gtTileColor", this.gtTileColor);
    }

    private void onOvervoltage() {
        Block b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        b.func_149697_b(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), 0);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public long injectEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        boolean powered;
        double dInternalFactor = this.getPowerSystem().getInternalEnergyPerInput(0);
        double dEU = aVoltage;
        double dAmperage = aAmperage;
        boolean bl = powered = this.func_145831_w().func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0;
        if (powered) {
            return 0L;
        }
        if (aVoltage > this.maxSafeVoltage) {
            this.onOvervoltage();
            return 0L;
        }
        double dDemandInEU = (double)this.getTotalEnergyDemand() / dInternalFactor;
        if (dDemandInEU < dEU) {
            return 0L;
        }
        double dDemandInAmps = dDemandInEU / dEU;
        if (dDemandInAmps < 1.0) {
            return 0L;
        }
        if (dDemandInAmps > dAmperage) {
            dDemandInAmps = dAmperage;
        }
        double dUnusedAmps = this.storeEnergy(dDemandInAmps * dEU * dInternalFactor, false);
        dUnusedAmps /= dInternalFactor;
        long usedAmps = (dUnusedAmps /= dEU) > 0.0 ? (long)dDemandInAmps - (long)Math.floor(dUnusedAmps) : (long)dDemandInAmps;
        if (this._lastTickInjected == this.field_145850_b.func_72820_D()) {
            this._euLastTick += dEU * (double)usedAmps;
        } else {
            this._euLastTick = dEU * (double)usedAmps;
            this._lastTickInjected = this.field_145850_b.func_72820_D();
        }
        return usedAmps;
    }

    public boolean inputEnergyFrom(byte aSide) {
        return true;
    }

    public boolean outputsEnergyTo(byte aSide) {
        return false;
    }

    public byte getColorization() {
        return -1;
    }

    public byte setColorization(byte aColor) {
        return -1;
    }
}

