/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.factorization;

import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.powerconverters.position.BlockPosition;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.base.TileEntityEnergyProducer;

public class TileEntityFactorizationProducer
extends TileEntityEnergyProducer<IChargeConductor>
implements IChargeConductor {
    private Charge _charge = new Charge((IChargeConductor)this);
    private static final int _maxCG = 1000;
    private boolean neighbourDirty = false;

    public TileEntityFactorizationProducer() {
        super(PowerSystemManager.getInstance().getPowerSystemByName("FZ"), 0, IChargeConductor.class);
    }

    @Override
    public double produceEnergy(double energy) {
        boolean powered;
        double CG = energy / (double)this.getPowerSystem().getInternalEnergyPerOutput(0);
        boolean bl = powered = this.func_145831_w().func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0;
        if (!powered) {
            for (Map.Entry output : this.getTiles().entrySet()) {
                IChargeConductor o = (IChargeConductor)output.getValue();
                if (o == null || o.getCharge().getValue() >= 1000) continue;
                int store = (int)Math.min((double)(1000 - o.getCharge().getValue()), CG);
                o.getCharge().addValue(store);
                if (!((CG -= (double)store) <= 0.0)) continue;
                break;
            }
        }
        return CG * (double)this.getPowerSystem().getInternalEnergyPerOutput(0);
    }

    public Charge getCharge() {
        return this._charge;
    }

    public String getInfo() {
        return null;
    }

    public Coord getCoord() {
        return new Coord((TileEntity)this);
    }

    @Override
    public void onNeighboorChanged() {
        super.onNeighboorChanged();
        try {
            Class<?> fzNullClass = Class.forName("factorization.shared.TileEntityFzNull");
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity te = BlockPosition.getAdjacentTileEntity(this, d);
                if (te == null || fzNullClass == null || !fzNullClass.isAssignableFrom(te.getClass())) continue;
                this.neighbourDirty = true;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isConnected() {
        if (this.neighbourDirty) {
            this.onNeighboorChanged();
            this.neighbourDirty = false;
        }
        return super.isConnected();
    }
}

