/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.network;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.network.GenericHandler;
import powercrystals.powerconverters.power.PowerSystemManager;

public class PacketClientSync
implements IMessage {
    NBTTagCompound data;

    public PacketClientSync() {
        this.data = new NBTTagCompound();
    }

    public PacketClientSync(NBTTagCompound nbt) {
        this.data = nbt;
    }

    public void fromBytes(ByteBuf buf) {
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    public static class Handler
    extends GenericHandler<PacketClientSync> {
        @Override
        public void processMessage(PacketClientSync message, MessageContext context) {
            PowerConverterCore.instance.logger.debug("Got sync packet. Applying ...");
            PowerSystemManager manager = PowerSystemManager.getInstance();
            try {
                manager = PowerSystemManager.getInstance();
                manager.readPowerData(message.data);
                PowerConverterCore.instance.logger.debug("Sync packet success.");
                return;
            }
            catch (Exception e) {
                FMLLog.severe((String)"Error processing Powerconverter sync data from server. Using client data.", (Object[])new Object[0]);
                manager.readPowerData(manager.writePowerData());
                return;
            }
        }
    }
}

