/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.crafting.mods;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.crafting.RecipeProvider;
import powercrystals.powerconverters.power.PowerSystem;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.base.BlockPowerConverter;
import powercrystals.powerconverters.power.systems.PowerSteam;

public class RecipeBuildCraft
extends RecipeProvider {
    private boolean enableRecipes = true;
    public static final String RECIPE_BUILDCRAFT_CATEGORY = "recipes.bc";

    @Override
    public void registerRecipes() {
        try {
            PowerSystem rf;
            ItemStack redstoneBlock = new ItemStack(GameRegistry.findBlock((String)"minecraft", (String)"redstone_block"), 1);
            Item cable = GameRegistry.findItem((String)"BuildCraft|Transport", (String)"item.buildcraftPipe.pipepowergold");
            Item struct = GameRegistry.findItem((String)"BuildCraft|Transport", (String)"item.buildcraftPipe.pipestructurecobblestone");
            Item conduit = GameRegistry.findItem((String)"BuildCraft|Transport", (String)"item.buildcraftPipe.pipepowerdiamond");
            Item fluid = GameRegistry.findItem((String)"BuildCraft|Transport", (String)"item.buildcraftPipe.pipefluidsgold");
            Block chest = GameRegistry.findBlock((String)"BuildCraft|Transport", (String)"filteredBufferBlock");
            Block engine = GameRegistry.findBlock((String)"BuildCraft|Energy", (String)"engineBlock");
            Block pump = GameRegistry.findBlock((String)"BuildCraft|Factory", (String)"pumpBlock");
            if (this.enableRecipes) {
                if (redstoneBlock.func_77973_b() == null || cable == null || conduit == null || engine == null || chest == null || OreDictionary.getOres((String)"gearGold").size() == 0) {
                    PowerConverterCore.instance.logger.error("Buildcraft recipe is missing items, not adding Power Converters converter recipes.");
                }
                GameRegistry.addRecipe((ItemStack)new ItemStack(PowerConverterCore.converterBlockCommon, 1, 0), (Object[])new Object[]{"PPP", "PBP", "PPP", Character.valueOf('B'), redstoneBlock, Character.valueOf('P'), conduit});
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(PowerConverterCore.converterBlockCommon, 1, 2), new Object[]{true, new Object[]{"TGT", "#S#", "T#T", Character.valueOf('T'), cable, Character.valueOf('S'), chest, Character.valueOf('#'), engine, Character.valueOf('G'), "gearGold"}}));
                PowerSystem steam = PowerSystemManager.getInstance().getPowerSystemByName(PowerSteam.id);
                if (steam != null) {
                    GameRegistry.addRecipe((ItemStack)new ItemStack((Block)steam.block, 1, 0), (Object[])new Object[]{"GSG", "SES", "GSG", Character.valueOf('G'), fluid, Character.valueOf('S'), struct, Character.valueOf('E'), pump});
                }
            }
            if ((rf = PowerSystemManager.getInstance().getPowerSystemByName("RF")) != null) {
                BlockPowerConverter converterBlock = rf.block;
                if (cable == null || struct == null) {
                    PowerConverterCore.instance.logger.error("Buildcraft recipe is missing items, not adding Power Converters recipe.");
                    return;
                }
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)converterBlock, 1, 0), new Object[]{true, new Object[]{"GSG", "SES", "GSG", Character.valueOf('G'), cable, Character.valueOf('S'), struct, Character.valueOf('E'), "gearGold"}}));
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    @Override
    public void loadConfig(Configuration c) {
        this.enableRecipes = c.get(RECIPE_BUILDCRAFT_CATEGORY, "enableRecipes", true).getBoolean(true);
    }

    @Override
    public void saveConfig(Configuration c) {
        c.getCategory(RECIPE_BUILDCRAFT_CATEGORY).get("enableRecipes").set(this.enableRecipes);
    }
}

