/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.exnihilo.handlers;

import exnihilo.registries.SieveRegistry;
import exnihilo.registries.helpers.SiftingResult;
import exnihilo.utils.ItemInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientAny;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.exnihilo.Sieve")
public class Sieve {
    public static final String name = "ExNihilo Sieve";

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output, int rarity) {
        if (input == null || output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s recipe.", name));
            return;
        }
        Sieve.addRecipe(input, new IItemStack[]{output}, new int[]{rarity});
    }

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack[] output, int[] rarity) {
        if (input == null || output == null || rarity == null) {
            LogHelper.logError(String.format("Required parameters missing for %s recipe.", name));
            return;
        }
        if (!InputHelper.isABlock(input)) {
            LogHelper.logError(String.format("Input item for %s recipe must be a block.", name));
            return;
        }
        if (output.length == 0 || output.length != rarity.length) {
            LogHelper.logError(String.format("Number of items in arrays are different or null (%d, %d)", output.length, rarity.length));
            return;
        }
        HashMap<ItemInfo, ArrayList<SiftingResult>> recipes = new HashMap<ItemInfo, ArrayList<SiftingResult>>();
        ArrayList<SiftingResult> list = new ArrayList<SiftingResult>();
        ItemInfo itemInfo = new ItemInfo(InputHelper.toStack(input));
        recipes.put(itemInfo, list);
        for (int i = 0; i < output.length; ++i) {
            ItemStack out = InputHelper.toStack(output[i]);
            list.add(new SiftingResult(out.func_77973_b(), out.func_77960_j(), rarity[i]));
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(recipes));
    }

    @Deprecated
    @ZenMethod
    public static void removeRecipe(IItemStack input, IItemStack output) {
        Sieve.removeRecipe((IIngredient)input, (IIngredient)output);
    }

    @Deprecated
    @ZenMethod
    public static void removeRewardFromAllBlocks(IItemStack output) {
        Sieve.removeRecipe((IIngredient)IngredientAny.INSTANCE, (IIngredient)output);
    }

    @Deprecated
    @ZenMethod
    public static void removeAllRewardsFromBlock(IItemStack output) {
        Sieve.removeRecipe((IIngredient)output, (IIngredient)IngredientAny.INSTANCE);
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input, @Optional IIngredient output) {
        if (input == null) {
            LogHelper.logError(String.format("Required parameters missing for %s recipe.", name));
            return;
        }
        if (output == null) {
            output = IngredientAny.INSTANCE;
        }
        HashMap<ItemInfo, ArrayList<SiftingResult>> recipes = new HashMap<ItemInfo, ArrayList<SiftingResult>>();
        for (Map.Entry entry : SieveRegistry.getSiftables().entrySet()) {
            if (!input.matches(InputHelper.toIItemStack(((ItemInfo)entry.getKey()).getStack()))) continue;
            ArrayList list = (ArrayList)entry.getValue();
            ArrayList<SiftingResult> toRemove = new ArrayList<SiftingResult>();
            for (SiftingResult recipe : list) {
                ItemStack item = new ItemStack(recipe.item, 1, recipe.meta);
                if (!StackHelper.matches(output, InputHelper.toIItemStack(item))) continue;
                toRemove.add(recipe);
            }
            if (toRemove.isEmpty()) continue;
            recipes.put((ItemInfo)entry.getKey(), toRemove);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s recipes found for %s and %s. Command ignored!", name, input.toString(), output.toString()));
        }
    }

    public static ArrayList<SiftingResult> removeFromList(ArrayList<SiftingResult> list, SiftingResult s) {
        ArrayList<SiftingResult> removed = new ArrayList<SiftingResult>();
        ItemInfo toRemove = new ItemInfo(s.item, s.meta);
        Iterator<SiftingResult> it = list.iterator();
        while (it.hasNext()) {
            SiftingResult itS = it.next();
            ItemInfo item = new ItemInfo(itS.item, itS.meta);
            if (!item.equals((Object)toRemove)) continue;
            removed.add(itS);
            it.remove();
        }
        return removed;
    }

    private static class Remove
    extends BaseMapRemoval<ItemInfo, ArrayList<SiftingResult>> {
        public Remove(Map<ItemInfo, ArrayList<SiftingResult>> recipes) {
            super(Sieve.name, SieveRegistry.getSiftables(), recipes);
        }

        @Override
        public void apply() {
            for (Map.Entry entry : this.recipes.entrySet()) {
                ArrayList list = (ArrayList)this.map.get(entry.getKey());
                for (SiftingResult recipe : (ArrayList)entry.getValue()) {
                    Sieve.removeFromList(list, recipe);
                }
                this.successful.put(entry.getKey(), entry.getValue());
            }
            Iterator it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry;
                entry = it.next();
                if (!((ArrayList)entry.getValue()).isEmpty()) continue;
                it.remove();
            }
        }

        @Override
        public void undo() {
            for (Map.Entry entry : this.successful.entrySet()) {
                if (!this.map.containsKey(entry.getKey())) {
                    this.map.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
                    continue;
                }
                ((ArrayList)this.map.get(entry.getKey())).addAll((Collection)entry.getValue());
            }
        }

        @Override
        protected String getRecipeInfo(Map.Entry<ItemInfo, ArrayList<SiftingResult>> recipe) {
            return LogHelper.getStackDescription(recipe.getKey().getStack()) + " (" + recipe.getValue().size() + " entries)";
        }
    }

    private static class Add
    extends BaseMapAddition<ItemInfo, ArrayList<SiftingResult>> {
        public Add(Map<ItemInfo, ArrayList<SiftingResult>> recipes) {
            super(Sieve.name, SieveRegistry.getSiftables(), recipes);
        }

        @Override
        public void apply() {
            for (Map.Entry entry : this.recipes.entrySet()) {
                if (!this.map.containsKey(entry.getKey())) {
                    this.map.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
                } else {
                    ArrayList list = (ArrayList)this.map.get(entry.getKey());
                    ArrayList<SiftingResult> backup = new ArrayList<SiftingResult>();
                    for (SiftingResult recipe : (ArrayList)entry.getValue()) {
                        backup.addAll(Sieve.removeFromList(list, recipe));
                    }
                    if (!backup.isEmpty()) {
                        LogHelper.logWarning(String.format("Overwritten %d %s recipe outputs for %s.", backup.size(), this.name, LogHelper.getStackDescription(((ItemInfo)entry.getKey()).getStack())));
                        this.overwritten.put(entry.getKey(), backup);
                    }
                    list.addAll((Collection)entry.getValue());
                }
                this.successful.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void undo() {
            for (Map.Entry entry : this.successful.entrySet()) {
                ArrayList list = (ArrayList)this.map.get(entry.getKey());
                for (SiftingResult recipe : (ArrayList)entry.getValue()) {
                    Sieve.removeFromList(list, recipe);
                }
            }
            for (Map.Entry entry : this.overwritten.entrySet()) {
                ((ArrayList)this.map.get(entry.getKey())).addAll((Collection)entry.getValue());
            }
            Iterator it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry;
                entry = it.next();
                if (!((ArrayList)entry.getValue()).isEmpty()) continue;
                it.remove();
            }
        }

        @Override
        protected String getRecipeInfo(Map.Entry<ItemInfo, ArrayList<SiftingResult>> recipe) {
            return LogHelper.getStackDescription(recipe.getKey().getStack()) + " (" + recipe.getValue().size() + " entries)";
        }
    }
}

