/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.ItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiAutoBrewer;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerAutoBrewer;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityAutoBrewer
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    protected boolean _inventoryDirty;

    public TileEntityAutoBrewer() {
        super(Machine.AutoBrewer);
        this.setManageSolids(true);
        this._tanks[0].setLock(FluidRegistry.getFluid((String)"water"));
    }

    private int getProcessSlot(int n) {
        return n * 5;
    }

    private int getTemplateSlot(int n) {
        return n * 5 + 1;
    }

    private int getResourceSlot(int n, int n2) {
        return n * 5 + n2 + 2;
    }

    @Override
    protected FluidTankAdv[] createTanks() {
        return new FluidTankAdv[]{new FluidTankAdv(4000)};
    }

    public int func_70302_i_() {
        return 32;
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerAutoBrewer(this, inventoryPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiAutoBrewer(this.getContainer(inventoryPlayer), this);
    }

    @Override
    protected boolean activateMachine() {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.getWorkDone() > 0;
        if (bl3 & !this._inventoryDirty) {
            bl = true;
        } else {
            n = MFRConfig.autobrewerFluidCost.getInt();
            for (int i = 0; i < 6; ++i) {
                int n2 = this.getProcessSlot(i);
                int n3 = this.getTemplateSlot(i);
                if (this._inventory[31] != null && this._inventory[n2] == null && this._inventory[n3] != null && (i == 0 || this._inventory[this.getTemplateSlot(i - 1)] == null) && this.getPotionResult(0, this._inventory[n3]) != 0 && this.drain(this._tanks[0], n, false) == n) {
                    this.drain(this._tanks[0], n, true);
                    this._inventory[31] = ItemHelper.consumeItem((ItemStack)this._inventory[31]);
                    this._inventory[n2] = new ItemStack((Item)Items.field_151068_bn, 1, 0);
                    bl2 = true;
                }
                if (this._inventory[n2] == null || this._inventory[this.getProcessSlot(i + 1)] != null || !this.canBrew(i)) continue;
                bl = true;
            }
            this._inventoryDirty = false;
        }
        if (!bl) {
            this.setWorkDone(0);
            this.setIdleTicks(this.getIdleTicksMax());
            return bl2;
        }
        if (this.getWorkDone() < this.getWorkMax()) {
            return this.incrementWorkDone();
        }
        this.setWorkDone(0);
        n = 6;
        block1: while (n-- > 0) {
            ItemStack itemStack = this._inventory[this.getProcessSlot(n)];
            ItemStack itemStack2 = this._inventory[this.getProcessSlot(n + 1)];
            if (itemStack2 != null && itemStack != null) continue;
            ItemStack itemStack3 = this._inventory[this.getTemplateSlot(n)];
            if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemPotion)) continue;
            if (itemStack3 == null) {
                this._inventory[this.getProcessSlot((int)(n + 1))] = itemStack;
                this._inventory[this.getProcessSlot((int)n)] = null;
                continue;
            }
            for (int i = 0; i < 3; ++i) {
                int n4 = this.getResourceSlot(n, i);
                if (itemStack3.field_77994_a <= 0 && !UtilInventory.stacksEqual(this._inventory[n4], itemStack3)) continue;
                int n5 = itemStack.func_77960_j();
                int n6 = this.getPotionResult(n5, itemStack3);
                List list = Items.field_151068_bn.func_77834_f(n5);
                List list2 = Items.field_151068_bn.func_77834_f(n6);
                if (!(n5 > 0 && list == list2 || list != null && (list.equals(list2) || list2 == null))) {
                    if (n5 != n6) {
                        itemStack.func_77964_b(n6);
                    }
                } else if (!ItemPotion.func_77831_g((int)n5) && ItemPotion.func_77831_g((int)n6)) {
                    itemStack.func_77964_b(n6);
                }
                this._inventory[this.getProcessSlot((int)(n + 1))] = itemStack;
                this._inventory[this.getProcessSlot((int)n)] = null;
                if (n5 == n6) continue block1;
                if (itemStack3.field_77994_a > 0) {
                    --itemStack3.field_77994_a;
                    continue block1;
                }
                --this._inventory[n4].field_77994_a;
                ++itemStack3.field_77994_a;
                if (itemStack3.func_77973_b().hasContainerItem(this._inventory[n4])) {
                    ItemStack itemStack4 = itemStack3.func_77973_b().getContainerItem(this._inventory[n4]);
                    if (itemStack4 != null && itemStack4.func_77984_f() && itemStack4.func_77960_j() > itemStack4.func_77958_k()) {
                        itemStack4 = null;
                    }
                    this._inventory[n4] = itemStack4;
                }
                if (this._inventory[n4] == null || this._inventory[n4].field_77994_a > 0) continue block1;
                this._inventory[n4] = null;
                continue block1;
            }
        }
        return true;
    }

    private boolean canBrew(int n) {
        boolean bl;
        if (this._inventory[this.getTemplateSlot(n)] == null) {
            return false;
        }
        boolean bl2 = bl = this._inventory[this.getTemplateSlot((int)n)].field_77994_a > 0;
        if (!bl) {
            for (int i = 0; i < 3; ++i) {
                if (!UtilInventory.stacksEqual(this._inventory[this.getTemplateSlot(n)], this._inventory[this.getResourceSlot(n, i)])) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            return false;
        }
        ItemStack itemStack = this._inventory[this.getTemplateSlot(n)];
        if (!itemStack.func_77973_b().func_150892_m(itemStack)) {
            return false;
        }
        if (this._inventory[this.getProcessSlot(n)] != null && this._inventory[this.getProcessSlot(n)].func_77973_b() instanceof ItemPotion) {
            int n2 = this._inventory[this.getProcessSlot(n)].func_77960_j();
            int n3 = this.getPotionResult(n2, itemStack);
            if (!ItemPotion.func_77831_g((int)n2) && ItemPotion.func_77831_g((int)n3)) {
                return true;
            }
            List list = Items.field_151068_bn.func_77834_f(n2);
            List list2 = Items.field_151068_bn.func_77834_f(n3);
            if (!(n2 > 0 && list == list2 || list != null && (list.equals(list2) || list2 == null))) {
                return true;
            }
        }
        return false;
    }

    private int getPotionResult(int n, ItemStack itemStack) {
        if (itemStack == null || !itemStack.func_77973_b().func_150892_m(itemStack)) {
            return n;
        }
        return PotionHelper.func_77913_a((int)n, (String)itemStack.func_77973_b().func_150896_i(itemStack));
    }

    @Override
    public int getWorkMax() {
        return 160;
    }

    @Override
    public int getIdleTicksMax() {
        return 10;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        int n3 = n / 5;
        int n4 = n % 5;
        if (itemStack == null) {
            return false;
        }
        if (n == 31) {
            return itemStack.func_77973_b().equals(Items.field_151069_bo);
        }
        if (n3 == 6) {
            return false;
        }
        if (n4 == 1) {
            return false;
        }
        if (n4 == 0) {
            return this._inventory[this.getTemplateSlot(n3)] != null && itemStack.func_77973_b() instanceof ItemPotion && (n3 == 0 || this._inventory[this.getTemplateSlot(n3 - 1)] == null);
        }
        return this.ingredientsEqual(this._inventory[this.getTemplateSlot(n3)], itemStack);
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        int n3 = n / 5;
        int n4 = n % 5;
        if (n3 == 6) {
            return n != 31;
        }
        if (n4 == 1) {
            return false;
        }
        if (n4 == 0) {
            return this._inventory[this.getTemplateSlot(n3)] == null;
        }
        return !this.ingredientsEqual(this._inventory[this.getTemplateSlot(n3)], itemStack);
    }

    private boolean ingredientsEqual(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null || !itemStack.func_77973_b().func_150892_m(itemStack)) {
            return false;
        }
        return itemStack.func_77973_b().func_150896_i(itemStack).equals(itemStack2.func_77973_b().func_150896_i(itemStack2));
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        if (itemStack != null && !this.shouldDropSlotWhenBroken(n)) {
            itemStack.field_77994_a = 0;
        }
        super.func_70299_a(n, itemStack);
    }

    @Override
    protected void onFactoryInventoryChanged() {
        super.onFactoryInventoryChanged();
        this._inventoryDirty = true;
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return n % 5 != 1 || n == 31;
    }

    @Override
    public boolean allowBucketFill(ItemStack itemStack) {
        return !itemStack.func_77973_b().equals(Items.field_151068_bn);
    }

    @Override
    public boolean allowBucketDrain(ItemStack itemStack) {
        return !itemStack.func_77973_b().equals(Items.field_151069_bo);
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.fill(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.drain(n, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.drain(fluidStack, bl);
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }
}

