/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.ic2;

import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.api.ReplacementBlock;
import powercrystals.minefactoryreloaded.modhelpers.EmptyReplacement;

public class IC2Crop
implements IFactoryHarvestable,
IFactoryFertilizable,
IFactoryFruit {
    private Block _block;

    public IC2Crop(Block block) {
        this._block = block;
    }

    @Override
    public Block getPlant() {
        return this._block;
    }

    @Override
    public boolean canFertilize(World world, int n, int n2, int n3, FertilizerType fertilizerType) {
        return fertilizerType != FertilizerType.Grass && this.canFert(world, n, n2, n3);
    }

    private boolean canFert(World world, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity == null || !(tileEntity instanceof ICropTile)) {
            return false;
        }
        ICropTile iCropTile = (ICropTile)tileEntity;
        return iCropTile.getNutrientStorage() < 15;
    }

    @Override
    public boolean fertilize(World world, Random random, int n, int n2, int n3, FertilizerType fertilizerType) {
        ICropTile iCropTile = (ICropTile)world.func_147438_o(n, n2, n3);
        iCropTile.setNutrientStorage(100);
        iCropTile.updateState();
        return iCropTile.getNutrientStorage() == 100;
    }

    @Override
    public HarvestType getHarvestType() {
        return HarvestType.Normal;
    }

    @Override
    public boolean breakBlock() {
        return false;
    }

    @Override
    public boolean canBeHarvested(World world, Map<String, Boolean> map, int n, int n2, int n3) {
        return this.canHarvest(world, n, n2, n3);
    }

    @Override
    public boolean canBePicked(World world, int n, int n2, int n3) {
        return this.canHarvest(world, n, n2, n3);
    }

    private boolean canHarvest(World world, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity == null || !(tileEntity instanceof ICropTile)) {
            return false;
        }
        ICropTile iCropTile = (ICropTile)tileEntity;
        try {
            short s = iCropTile.getID();
            if (s < 0) {
                return false;
            }
            CropCard cropCard = Crops.instance.getCropList()[s];
            if (!cropCard.canBeHarvested(iCropTile) || cropCard.canGrow(iCropTile)) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    @Override
    public List<ItemStack> getDrops(World world, Random random, Map<String, Boolean> map, int n, int n2, int n3) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        this.getDrops(arrayList, world, random, n, n2, n3);
        return arrayList;
    }

    @Override
    public List<ItemStack> getDrops(World world, Random random, int n, int n2, int n3) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        this.getDrops(arrayList, world, random, n, n2, n3);
        return arrayList;
    }

    private void getDrops(List<ItemStack> list, World world, Random random, int n, int n2, int n3) {
        ICropTile iCropTile = (ICropTile)world.func_147438_o(n, n2, n3);
        try {
            int n4;
            CropCard cropCard = Crops.instance.getCropList()[iCropTile.getID()];
            float f = cropCard.dropGainChance();
            for (n4 = 0; n4 < iCropTile.getGain(); ++n4) {
                f *= 1.03f;
            }
            f -= random.nextFloat();
            n4 = 0;
            while (f > 0.0f) {
                ++n4;
                f -= random.nextFloat();
            }
            ItemStack[] itemStackArray = new ItemStack[n4];
            for (int i = 0; i < n4; ++i) {
                itemStackArray[i] = cropCard.getGain(iCropTile);
                if (itemStackArray[i] == null || random.nextInt(100) > iCropTile.getGain()) continue;
                ++itemStackArray[i].field_77994_a;
            }
            iCropTile.setSize(cropCard.getSizeAfterHarvest(iCropTile));
            iCropTile.updateState();
            for (ItemStack itemStack : itemStackArray) {
                list.add(itemStack);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public ReplacementBlock getReplacementBlock(World world, int n, int n2, int n3) {
        return EmptyReplacement.INSTANCE;
    }

    @Override
    public void preHarvest(World world, int n, int n2, int n3) {
    }

    @Override
    public void postHarvest(World world, int n, int n2, int n3) {
    }

    @Override
    public void prePick(World world, int n, int n2, int n3) {
    }

    @Override
    public void postPick(World world, int n, int n2, int n3) {
    }
}

