/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.settings.KeyBinding;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class KeyHandler {
    private final KeyBinding[] keyBindings;
    private KeyBinding[] vKeyBindings;
    private boolean[] keyDown;
    private boolean[] repeatings;
    private boolean[] vRepeatings;
    public boolean isDummy;

    public KeyHandler(KeyBinding[] keyBindings, boolean[] repeatings, KeyBinding[] vanillaKeys, boolean[] vanillaRepeatings) {
        assert (keyBindings.length == repeatings.length) : "You need to pass two arrays of identical length";
        assert (vanillaKeys.length == vanillaRepeatings.length) : "You need to pass two arrays of identical length";
        this.keyBindings = keyBindings;
        this.repeatings = repeatings;
        this.vKeyBindings = vanillaKeys;
        this.vRepeatings = vanillaRepeatings;
        this.keyDown = new boolean[keyBindings.length + vanillaKeys.length];
    }

    public KeyHandler(KeyBinding[] keyBindings) {
        this.keyBindings = keyBindings;
        this.isDummy = true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT) {
            if (event.phase == TickEvent.Phase.START) {
                this.keyTick(event.type, false);
            } else if (event.phase == TickEvent.Phase.END) {
                this.keyTick(event.type, true);
            }
        }
    }

    public void keyTick(TickEvent.Type type, boolean tickEnd) {
        boolean state;
        int keyCode;
        KeyBinding keyBinding;
        int i;
        boolean inChat = FMLClientHandler.instance().getClient().field_71462_r instanceof GuiChat;
        for (i = 0; i < this.keyBindings.length; ++i) {
            keyBinding = this.keyBindings[i];
            keyCode = keyBinding.func_151463_i();
            boolean bl = inChat ? false : (state = keyCode < 0 ? Mouse.isButtonDown((int)(keyCode + 100)) : Keyboard.isKeyDown((int)keyCode));
            if (state == this.keyDown[i] && (!state || !this.repeatings[i])) continue;
            if (state) {
                this.keyDown(type, keyBinding, tickEnd, state != this.keyDown[i]);
            } else {
                this.keyUp(type, keyBinding, tickEnd);
            }
            if (!tickEnd) continue;
            this.keyDown[i] = state;
        }
        for (i = 0; i < this.vKeyBindings.length; ++i) {
            keyBinding = this.vKeyBindings[i];
            keyCode = keyBinding.func_151463_i();
            boolean bl = state = keyCode < 0 ? Mouse.isButtonDown((int)(keyCode + 100)) : Keyboard.isKeyDown((int)keyCode);
            if (state == this.keyDown[i + this.keyBindings.length] && (!state || !this.vRepeatings[i])) continue;
            if (state) {
                this.keyDown(type, keyBinding, tickEnd, state != this.keyDown[i + this.keyBindings.length]);
            } else {
                this.keyUp(type, keyBinding, tickEnd);
            }
            if (!tickEnd) continue;
            this.keyDown[i + this.keyBindings.length] = state;
        }
    }

    public abstract void keyDown(TickEvent.Type var1, KeyBinding var2, boolean var3, boolean var4);

    public abstract void keyUp(TickEvent.Type var1, KeyBinding var2, boolean var3);
}

