/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.List;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkConnection;
import micdoodle8.mods.galacticraft.api.transmission.tile.ITransmitter;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityHydrogenPipe;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockTransmitter
extends BlockContainer {
    public Vector3 minVector = new Vector3(0.3, 0.3, 0.3);
    public Vector3 maxVector = new Vector3(0.7, 0.7, 0.7);

    public BlockTransmitter(Material material) {
        super(material);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        TileEntity tile = world.func_147438_o(x, y, z);
        this.func_149719_a((IBlockAccess)world, x, y, z);
        GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_WIRE_BOUNDS, new Object[]{x, y, z}), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 10.0));
        if (tile instanceof INetworkConnection) {
            ((INetworkConnection)tile).refresh();
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof ITransmitter) {
            TileEntity[] connectable = new TileEntity[6];
            switch (this.getNetworkType()) {
                case OXYGEN: {
                    connectable = OxygenUtil.getAdjacentOxygenConnections(tileEntity);
                    break;
                }
                case HYDROGEN: {
                    connectable = TileEntityHydrogenPipe.getAdjacentHydrogenConnections((TileEntity)tileEntity);
                    break;
                }
                case POWER: {
                    connectable = EnergyUtil.getAdjacentPowerConnections(tileEntity);
                    break;
                }
            }
            float minX = (float)this.minVector.x;
            float minY = (float)this.minVector.y;
            float minZ = (float)this.minVector.z;
            float maxX = (float)this.maxVector.x;
            float maxY = (float)this.maxVector.y;
            float maxZ = (float)this.maxVector.z;
            if (connectable[0] != null) {
                minY = 0.0f;
            }
            if (connectable[1] != null) {
                maxY = 1.0f;
            }
            if (connectable[2] != null) {
                minZ = 0.0f;
            }
            if (connectable[3] != null) {
                maxZ = 1.0f;
            }
            if (connectable[4] != null) {
                minX = 0.0f;
            }
            if (connectable[5] != null) {
                maxX = 1.0f;
            }
            this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    public abstract NetworkType getNetworkType();

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List list, Entity entity) {
        this.func_149676_a((float)this.minVector.x, (float)this.minVector.y, (float)this.minVector.z, (float)this.maxVector.x, (float)this.maxVector.y, (float)this.maxVector.z);
        super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof ITransmitter) {
            TileEntity[] connectable;
            switch (this.getNetworkType()) {
                case OXYGEN: {
                    connectable = OxygenUtil.getAdjacentOxygenConnections(tileEntity);
                    break;
                }
                case HYDROGEN: {
                    connectable = TileEntityHydrogenPipe.getAdjacentHydrogenConnections((TileEntity)tileEntity);
                    break;
                }
                case POWER: {
                    connectable = EnergyUtil.getAdjacentPowerConnections(tileEntity);
                    break;
                }
                default: {
                    connectable = new TileEntity[6];
                }
            }
            if (connectable[4] != null) {
                this.func_149676_a(0.0f, (float)this.minVector.y, (float)this.minVector.z, (float)this.maxVector.x, (float)this.maxVector.y, (float)this.maxVector.z);
                super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
            }
            if (connectable[5] != null) {
                this.func_149676_a((float)this.minVector.x, (float)this.minVector.y, (float)this.minVector.z, 1.0f, (float)this.maxVector.y, (float)this.maxVector.z);
                super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
            }
            if (connectable[0] != null) {
                this.func_149676_a((float)this.minVector.x, 0.0f, (float)this.minVector.z, (float)this.maxVector.x, (float)this.maxVector.y, (float)this.maxVector.z);
                super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
            }
            if (connectable[1] != null) {
                this.func_149676_a((float)this.minVector.x, (float)this.minVector.y, (float)this.minVector.z, (float)this.maxVector.x, 1.0f, (float)this.maxVector.z);
                super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
            }
            if (connectable[2] != null) {
                this.func_149676_a((float)this.minVector.x, (float)this.minVector.y, 0.0f, (float)this.maxVector.x, (float)this.maxVector.y, (float)this.maxVector.z);
                super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
            }
            if (connectable[3] != null) {
                this.func_149676_a((float)this.minVector.x, (float)this.minVector.y, (float)this.minVector.z, (float)this.maxVector.x, (float)this.maxVector.y, 1.0f);
                super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
            }
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }
}

