/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class RandomizedAspectList
extends AspectList {
    private static final Random RANDOM = new Random();
    private Map<Aspect, Integer> aspectMap = new HashMap<Aspect, Integer>();
    private long lastRandomization = 0L;
    private boolean halfCap = false;

    public RandomizedAspectList addAspectRandomBase(Aspect aspect, int amount) {
        this.aspectMap.put(aspect, amount);
        return this;
    }

    public RandomizedAspectList setHalfCap(boolean halfCap) {
        this.halfCap = halfCap;
        return this;
    }

    private void checkRandomization() {
        if (System.currentTimeMillis() - this.lastRandomization > 500L) {
            this.aspects.clear();
            for (Aspect a : this.aspectMap.keySet()) {
                int am;
                if (a == null) continue;
                if (this.halfCap) {
                    int c = this.aspectMap.get(a);
                    am = c / 2 + RANDOM.nextInt(c / 2);
                } else {
                    am = RANDOM.nextInt(this.aspectMap.get(a));
                }
                if (am <= 0) continue;
                super.add(a, am);
            }
            this.lastRandomization = System.currentTimeMillis();
        }
    }

    public Aspect[] getAspects() {
        this.checkRandomization();
        return super.getAspects();
    }

    public Aspect[] getAspectsSorted() {
        this.checkRandomization();
        return super.getAspectsSorted();
    }

    public Aspect[] getAspectsSortedAmount() {
        this.checkRandomization();
        return super.getAspectsSortedAmount();
    }

    public int getAmount(Aspect key) {
        this.checkRandomization();
        return super.getAmount(key);
    }

    public Aspect[] getPrimalAspects() {
        this.checkRandomization();
        return super.getPrimalAspects();
    }
}

