/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.entities.golems.nbt;

import makeo.gadomancy.api.GadomancyApi;
import makeo.gadomancy.api.golems.AdditionalGolemType;
import makeo.gadomancy.api.golems.cores.AdditionalGolemCore;
import makeo.gadomancy.common.data.config.ModConfig;
import makeo.gadomancy.common.entities.golems.cores.EntityAITasksWrapper;
import makeo.gadomancy.common.entities.golems.nbt.OverrideNBTTagByte;
import makeo.gadomancy.common.entities.golems.nbt.OverrideRidingEntity;
import makeo.gadomancy.common.utils.NBTHelper;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import thaumcraft.common.entities.golems.EntityGolemBase;

public class ExtendedGolemProperties
implements IExtendedEntityProperties {
    private static final String TYPE_TAG = "golemTypeOverride";
    private static final String FORGE_TAG = "ForgeData";
    private EntityGolemBase golem;
    private boolean updateHealth = false;
    private float health;
    private boolean isSitting = false;
    private EntityAITasksWrapper taskWrapper = null;
    private EntityAITasksWrapper targetWrapper = null;

    public ExtendedGolemProperties(EntityGolemBase golem) {
        this.golem = golem;
    }

    public boolean shouldUpdateHealth() {
        return this.updateHealth;
    }

    public void resetUpdateHealth() {
        this.updateHealth = false;
    }

    public float getHealth() {
        return this.health;
    }

    public boolean isSitting() {
        return this.isSitting;
    }

    public void setSitting(boolean isSitting) {
        this.isSitting = isSitting;
    }

    public void saveNBTData(NBTTagCompound compound) {
        AdditionalGolemType type = GadomancyApi.getAdditionalGolemType(this.golem.getGolemType());
        if (type != null) {
            NBTTagCompound entityData;
            if (compound.func_74764_b(FORGE_TAG)) {
                entityData = compound.func_74775_l(FORGE_TAG);
            } else {
                entityData = new NBTTagCompound();
                compound.func_74782_a(FORGE_TAG, (NBTBase)entityData);
            }
            ExtendedGolemProperties.writeAdvancedGolemType(entityData, type);
            this.golem.field_70154_o = new OverrideRidingEntity(this.golem, compound, this.golem.field_70154_o);
        }
        compound.func_74757_a("gadomancy:sitting", this.isSitting);
    }

    private static void writeAdvancedGolemType(NBTTagCompound base, AdditionalGolemType type) {
        NBTTagCompound compound;
        if (base.func_74764_b("gadomancy")) {
            compound = base.func_74775_l("gadomancy");
        } else {
            compound = new NBTTagCompound();
            base.func_74782_a("gadomancy", (NBTBase)compound);
        }
        compound.func_74778_a(TYPE_TAG, type.getEnumEntry().name());
    }

    public void loadNBTData(NBTTagCompound compound) {
        AdditionalGolemType type;
        if (compound.func_74764_b("GolemType") && (type = ExtendedGolemProperties.readAdvancedGolemType(this.golem.getEntityData())) != null) {
            byte lastType = compound.func_74771_c("GolemType");
            compound.func_74782_a("GolemType", (NBTBase)new OverrideNBTTagByte(lastType, (byte)type.getEnumEntry().ordinal()));
            this.health = compound.func_74760_g("HealF") * -1.0f;
            this.updateHealth = true;
        }
        this.isSitting = compound.func_74767_n("gadomancy:sitting");
        this.updateGolemCore();
    }

    public void updateGolemCore() {
        NBTTagCompound persistent;
        if (!this.golem.field_70170_p.field_72995_K && NBTHelper.hasPersistentData((Entity)this.golem) && (persistent = NBTHelper.getPersistentData((Entity)this.golem)).func_74764_b("Core")) {
            for (AdditionalGolemCore core : GadomancyApi.getAdditionalGolemCores()) {
                if (!core.getName().equals(persistent.func_74779_i("Core"))) continue;
                this.golem.func_70096_w().func_75692_b(ModConfig.golemDatawatcherId, (Object)core.getName());
                break;
            }
        }
    }

    public void setWrapperIfNeeded() {
        boolean needsUpdate = false;
        if (this.taskWrapper == null) {
            this.taskWrapper = new EntityAITasksWrapper(this.golem, this.golem.field_70714_bg, true);
            this.golem.field_70714_bg = this.taskWrapper;
            needsUpdate = true;
        }
        if (this.targetWrapper == null) {
            this.targetWrapper = new EntityAITasksWrapper(this.golem, this.golem.field_70715_bh, false);
            this.golem.field_70715_bh = this.targetWrapper;
            needsUpdate = true;
        }
        if (needsUpdate) {
            this.updateGolem();
        }
    }

    public void updateGolem() {
        this.taskWrapper.unlock();
        this.targetWrapper.unlock();
        this.golem.setupGolem();
        this.golem.setupGolemInventory();
        AdditionalGolemCore core = GadomancyApi.getAdditionalGolemCore(this.golem);
        if (core != null) {
            this.taskWrapper.field_75782_a.clear();
            this.targetWrapper.field_75782_a.clear();
            core.setupGolem(this.golem);
            this.taskWrapper.lock();
            this.targetWrapper.lock();
        }
    }

    private static AdditionalGolemType readAdvancedGolemType(NBTTagCompound base) {
        NBTTagCompound compound;
        if (base.func_74764_b("gadomancy") && (compound = base.func_74775_l("gadomancy")).func_74764_b(TYPE_TAG)) {
            return GadomancyApi.getAdditionalGolemType(compound.func_74779_i(TYPE_TAG));
        }
        return null;
    }

    public void init(Entity entity, World world) {
    }
}

