/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.repackage.makamys.mclib.updatecheck;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import cpw.mods.fml.common.versioning.ComparableVersion;
import ganymedes01.etfuturum.repackage.makamys.mclib.updatecheck.ConfigUCL;
import ganymedes01.etfuturum.repackage.makamys.mclib.updatecheck.UpdateCheckLib;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;

class UpdateCheckTask
implements Supplier<Result> {
    String name;
    ComparableVersion currentVersion;
    UpdateCheckLib.UpdateCategory category;
    String updateJSONUrl;
    String homepage = "";
    public static final boolean TEST_MODE = Boolean.parseBoolean(System.getProperty("updateCheckLib.test", "false"));
    private static final String MOCK_PREFIX = "mock://";

    public UpdateCheckTask(String name, String currentVersion, UpdateCheckLib.UpdateCategory category, String updateJSONUrl) {
        this.name = name;
        this.currentVersion = new ComparableVersion(currentVersion);
        this.category = category;
        this.updateJSONUrl = updateJSONUrl;
    }

    @Override
    public Result get() {
        UpdateCheckLib.LOGGER.debug("Checking " + this.name + " for updates");
        ComparableVersion current = this.currentVersion;
        ComparableVersion solved = null;
        try {
            solved = this.solveVersion();
        }
        catch (Exception e) {
            UpdateCheckLib.LOGGER.log(this.getErrorLevel(), "Failed to retrieve update JSON for " + this.name + ": " + e.getMessage());
        }
        if (solved == null) {
            return new Result(this);
        }
        UpdateCheckLib.LOGGER.debug("Update version found for " + this.name + ": " + solved + " (running " + current + ")");
        return new Result(this, solved);
    }

    private Level getErrorLevel() {
        return !ConfigUCL.hideErrored ? Level.ERROR : Level.DEBUG;
    }

    private ComparableVersion solveVersion() throws Exception {
        block10: {
            if (this.category == null) {
                return null;
            }
            if (TEST_MODE && this.updateJSONUrl.startsWith(MOCK_PREFIX)) {
                return this.mockSolveVersion();
            }
            URL url = new URL(this.updateJSONUrl);
            InputStream contents = url.openStream();
            String jasonString = IOUtils.toString((InputStream)contents, (String)"UTF-8");
            JsonObject jason = new JsonParser().parse(jasonString).getAsJsonObject();
            JsonElement homepageElem = jason.get("homepage");
            if (homepageElem instanceof JsonPrimitive) {
                this.homepage = homepageElem.getAsString();
            } else {
                UpdateCheckLib.LOGGER.log(this.getErrorLevel(), "Failed to locate 'homepage' element in " + this.updateJSONUrl);
            }
            String channel = ConfigUCL.promoChannel;
            ComparableVersion categoryVersion = new ComparableVersion(this.category.version);
            JsonElement promos = jason.get("promos");
            if (promos instanceof JsonObject) {
                try {
                    ComparableVersion newestLowerCategoryVersion = (ComparableVersion)Collections.max(((JsonObject)promos).entrySet().stream().map(e -> new ComparableVersion(((String)e.getKey()).split("-")[0])).filter(v -> v.compareTo(categoryVersion) <= 0).collect(Collectors.toList()));
                    if (newestLowerCategoryVersion.compareTo(categoryVersion) == 0 || this.category.backwardsCompatible) {
                        String promoKey = newestLowerCategoryVersion + "-" + channel;
                        JsonElement promoVersion = ((JsonObject)promos).get(promoKey);
                        if (promoVersion != null) {
                            return new ComparableVersion(promoVersion.getAsString());
                        }
                        UpdateCheckLib.LOGGER.log(this.getErrorLevel(), "No promo named " + promoKey + " found in " + this.updateJSONUrl);
                        break block10;
                    }
                    UpdateCheckLib.LOGGER.log(this.getErrorLevel(), "No promo found for non-backwards compatible category of version " + categoryVersion + " in " + this.updateJSONUrl);
                }
                catch (NoSuchElementException e2) {
                    UpdateCheckLib.LOGGER.log(this.getErrorLevel(), "No promo found for category version lower than " + this.category.version + " in " + this.updateJSONUrl);
                }
            } else {
                UpdateCheckLib.LOGGER.log(this.getErrorLevel(), "Failed to locate promos in " + this.updateJSONUrl);
            }
        }
        return null;
    }

    private ComparableVersion mockSolveVersion() {
        return new ComparableVersion(this.updateJSONUrl.substring(MOCK_PREFIX.length()));
    }

    public static class Result {
        UpdateCheckTask task;
        public ComparableVersion newVersion;

        public Result(UpdateCheckTask task, ComparableVersion newVersion) {
            this.task = task;
            this.newVersion = newVersion;
        }

        public Result(UpdateCheckTask task) {
            this(task, null);
        }

        public boolean foundUpdate() {
            return this.newVersion != null && this.newVersion.compareTo(this.task.currentVersion) > 0;
        }

        public boolean isInteresting() {
            return !ConfigUCL.hideErrored && this.newVersion == null || this.foundUpdate();
        }
    }
}

