/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.recipes;

import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.oredict.OreDictionary;

public class BlastFurnaceRecipes {
    private static final BlastFurnaceRecipes smeltingBase = new BlastFurnaceRecipes();
    public Map<ItemStack, ItemStack> smeltingList = new HashMap<ItemStack, ItemStack>();
    public Map<ItemStack, Float> experienceList = new HashMap<ItemStack, Float>();

    public static BlastFurnaceRecipes smelting() {
        return smeltingBase;
    }

    private BlastFurnaceRecipes() {
    }

    public static void init() {
        if (ConfigFunctions.enableAutoAddBlastFurnace) {
            for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
                String oreName;
                ItemStack input = (ItemStack)entry.getKey();
                ItemStack result = (ItemStack)entry.getValue();
                if (input == null || result == null) continue;
                boolean registerrecipe = false;
                for (int id : OreDictionary.getOreIDs((ItemStack)input)) {
                    oreName = OreDictionary.getOreName((int)id);
                    if (oreName == null) continue;
                    if (oreName.startsWith("ore")) {
                        registerrecipe = true;
                        break;
                    }
                    if (oreName.startsWith("cluster")) {
                        registerrecipe = true;
                        break;
                    }
                    if (!oreName.startsWith("crushed")) continue;
                    registerrecipe = true;
                    break;
                }
                if (!registerrecipe) {
                    for (int id : OreDictionary.getOreIDs((ItemStack)result)) {
                        oreName = OreDictionary.getOreName((int)id);
                        if (oreName == null) continue;
                        if (oreName.startsWith("ingot")) {
                            registerrecipe = true;
                            break;
                        }
                        if (oreName.startsWith("chunkGt")) {
                            registerrecipe = true;
                            break;
                        }
                        if (oreName.startsWith("nugget")) {
                            registerrecipe = true;
                            break;
                        }
                        if (!oreName.equalsIgnoreCase("quicksilver")) continue;
                        registerrecipe = true;
                        break;
                    }
                }
                if (!registerrecipe) continue;
                smeltingBase.addRecipe(input, result, result.func_77973_b().getSmeltingExperience(result));
            }
        } else {
            smeltingBase.addRecipe(Blocks.field_150366_p, new ItemStack(Items.field_151042_j), 0.7f);
            smeltingBase.addRecipe(Blocks.field_150352_o, new ItemStack(Items.field_151043_k), 1.0f);
            smeltingBase.addRecipe(Blocks.field_150482_ag, new ItemStack(Items.field_151045_i), 1.0f);
            smeltingBase.addRecipe(Blocks.field_150412_bA, new ItemStack(Items.field_151166_bC), 1.0f);
            smeltingBase.addRecipe(Blocks.field_150365_q, new ItemStack(Items.field_151044_h), 0.1f);
            smeltingBase.addRecipe(Blocks.field_150450_ax, new ItemStack(Items.field_151137_ax), 0.7f);
            smeltingBase.addRecipe(Blocks.field_150369_x, new ItemStack(Items.field_151100_aR, 1, 4), 0.2f);
            smeltingBase.addRecipe(Blocks.field_150449_bY, new ItemStack(Items.field_151128_bU), 0.2f);
        }
        if (ConfigFunctions.enableMeltGear) {
            Item[][] crafts = new Item[][]{{Items.field_151169_ag, Items.field_151171_ah, Items.field_151149_ai, Items.field_151151_aj, Items.field_151010_B, Items.field_151005_D, Items.field_151006_E, Items.field_151011_C, Items.field_151013_M, Items.field_151136_bY, Items.field_151028_Y, Items.field_151030_Z, Items.field_151165_aa, Items.field_151167_ab, Items.field_151040_l, Items.field_151035_b, Items.field_151036_c, Items.field_151037_a, Items.field_151019_K, Items.field_151138_bX}, {Items.field_151074_bl, ModItems.iron_nugget}};
            for (int i = 0; i < crafts[0].length && (ConfigBlocksItems.enableIronNugget || i <= 9); ++i) {
                smeltingBase.addRecipe(crafts[0][i], new ItemStack(crafts[1][i > 9 ? 1 : 0]), 0.1f);
            }
        }
    }

    public void addRecipe(Block p_151393_1_, ItemStack p_151393_2_, float p_151393_3_) {
        this.addRecipe(Item.func_150898_a((Block)p_151393_1_), p_151393_2_, p_151393_3_);
    }

    public void addRecipe(Item p_151396_1_, ItemStack p_151396_2_, float p_151396_3_) {
        this.addRecipe(new ItemStack(p_151396_1_, 1, Short.MAX_VALUE), p_151396_2_, p_151396_3_);
    }

    public void addRecipe(ItemStack p_151394_1_, ItemStack p_151394_2_, float p_151394_3_) {
        this.smeltingList.put(p_151394_1_, p_151394_2_);
        this.experienceList.put(p_151394_2_, Float.valueOf(p_151394_3_));
    }

    public ItemStack getSmeltingResult(ItemStack p_151395_1_) {
        Map.Entry<ItemStack, ItemStack> entry;
        Iterator<Map.Entry<ItemStack, ItemStack>> iterator = this.smeltingList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.func_151397_a(p_151395_1_, (entry = iterator.next()).getKey()));
        return entry.getValue();
    }

    private boolean func_151397_a(ItemStack p_151397_1_, ItemStack p_151397_2_) {
        return p_151397_2_.func_77973_b() == p_151397_1_.func_77973_b() && (p_151397_2_.func_77960_j() == Short.MAX_VALUE || p_151397_2_.func_77960_j() == p_151397_1_.func_77960_j());
    }

    public Map<ItemStack, ItemStack> getSmeltingList() {
        return this.smeltingList;
    }

    public float func_151398_b(ItemStack p_151398_1_) {
        Map.Entry<ItemStack, Float> entry;
        float ret = p_151398_1_.func_77973_b().getSmeltingExperience(p_151398_1_);
        if (ret != -1.0f) {
            return ret;
        }
        Iterator<Map.Entry<ItemStack, Float>> iterator = this.experienceList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0.0f;
        } while (!this.func_151397_a(p_151398_1_, (entry = iterator.next()).getKey()));
        return entry.getValue().floatValue();
    }
}

