/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.entities;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.client.particle.ParticleHandler;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import ganymedes01.etfuturum.potion.ModPotions;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityShulkerBullet
extends Entity {
    private EntityLivingBase owner;
    private Entity target;
    private EnumFacing direction;
    private int steps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;
    private UUID ownerUniqueId;
    private BlockPos ownerBlockPos;
    private UUID targetUniqueId;
    private BlockPos targetBlockPos;
    private static final int OWNER_ID = 2;
    private static final int TARGET_ID = 3;

    public EntityShulkerBullet(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.3125f, 0.3125f);
        this.field_70145_X = true;
    }

    public EntityShulkerBullet(World worldIn, double x, double y, double z, double motionXIn, double motionYIn, double motionZIn) {
        this(worldIn);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.field_70159_w = motionXIn;
        this.field_70181_x = motionYIn;
        this.field_70179_y = motionZIn;
    }

    public EntityShulkerBullet(World worldIn, EntityLivingBase ownerIn, Entity targetIn, EnumFacing p_i46772_4_) {
        this(worldIn);
        this.owner = ownerIn;
        BlockPos blockpos = new BlockPos((Entity)ownerIn);
        double d0 = (double)blockpos.getX() + 0.5;
        double d1 = (double)blockpos.getY() + 0.5;
        double d2 = (double)blockpos.getZ() + 0.5;
        this.func_70012_b(d0, d1, d2, this.field_70177_z, this.field_70125_A);
        this.target = targetIn;
        this.direction = EnumFacing.UP;
        this.selectNextMoveDirection(p_i46772_4_);
        this.func_70096_w().func_75692_b(2, (Object)this.owner.func_145782_y());
        this.func_70096_w().func_75692_b(3, (Object)this.target.func_145782_y());
    }

    protected void func_70088_a() {
        this.func_70096_w().func_75682_a(2, (Object)-1);
        this.func_70096_w().func_75682_a(3, (Object)-1);
    }

    private void firstTick() {
        Entity entity;
        if (this.func_70096_w().func_75679_c(2) > -1 && this.owner == null && (entity = this.field_70170_p.func_73045_a(this.func_70096_w().func_75679_c(2))) instanceof EntityLivingBase) {
            this.owner = (EntityLivingBase)entity;
        }
        if (this.func_70096_w().func_75679_c(3) > -1 && this.target == null && (entity = this.field_70170_p.func_73045_a(this.func_70096_w().func_75679_c(3))) instanceof EntityLivingBase) {
            this.target = (EntityLivingBase)entity;
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.owner != null) {
            BlockPos blockpos = new BlockPos((Entity)this.owner);
            NBTTagCompound nbttagcompound = Utils.createUUIDTag(this.owner.func_110124_au());
            nbttagcompound.func_74768_a("X", blockpos.getX());
            nbttagcompound.func_74768_a("Y", blockpos.getY());
            nbttagcompound.func_74768_a("Z", blockpos.getZ());
            compound.func_74782_a("Owner", (NBTBase)nbttagcompound);
        }
        if (this.target != null) {
            BlockPos blockpos1 = new BlockPos(this.target);
            NBTTagCompound nbttagcompound1 = Utils.createUUIDTag(this.target.func_110124_au());
            nbttagcompound1.func_74768_a("X", blockpos1.getX());
            nbttagcompound1.func_74768_a("Y", blockpos1.getY());
            nbttagcompound1.func_74768_a("Z", blockpos1.getZ());
            compound.func_74782_a("Target", (NBTBase)nbttagcompound1);
        }
        if (this.direction != null) {
            compound.func_74768_a("Dir", this.direction.ordinal());
        }
        compound.func_74768_a("Steps", this.steps);
        compound.func_74780_a("TXD", this.targetDeltaX);
        compound.func_74780_a("TYD", this.targetDeltaY);
        compound.func_74780_a("TZD", this.targetDeltaZ);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.steps = compound.func_74762_e("Steps");
        this.targetDeltaX = compound.func_74769_h("TXD");
        this.targetDeltaY = compound.func_74769_h("TYD");
        this.targetDeltaZ = compound.func_74769_h("TZD");
        if (compound.func_150297_b("Dir", 99)) {
            this.direction = EnumFacing.func_82600_a((int)compound.func_74762_e("Dir"));
        }
        if (compound.func_150297_b("Owner", 10)) {
            NBTTagCompound nbttagcompound = compound.func_74775_l("Owner");
            this.ownerUniqueId = Utils.getUUIDFromTag(nbttagcompound);
            this.ownerBlockPos = new BlockPos(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Y"), nbttagcompound.func_74762_e("Z"));
        }
        if (compound.func_150297_b("Target", 10)) {
            NBTTagCompound nbttagcompound1 = compound.func_74775_l("Target");
            this.targetUniqueId = Utils.getUUIDFromTag(nbttagcompound1);
            this.targetBlockPos = new BlockPos(nbttagcompound1.func_74762_e("X"), nbttagcompound1.func_74762_e("Y"), nbttagcompound1.func_74762_e("Z"));
        }
    }

    private void setDirection(EnumFacing directionIn) {
        this.direction = directionIn;
    }

    private void selectNextMoveDirection(EnumFacing p_184569_1_) {
        BlockPos blockpos;
        double d0 = 0.5;
        if (this.target == null) {
            blockpos = new BlockPos(this).down();
        } else {
            d0 = (double)this.target.field_70131_O * 0.5;
            blockpos = new BlockPos(this.target.field_70165_t, this.target.field_70163_u + d0, this.target.field_70161_v);
        }
        double d1 = (double)blockpos.getX() + 0.5;
        double d2 = (double)blockpos.getY() + d0;
        double d3 = (double)blockpos.getZ() + 0.5;
        EnumFacing enumfacing = null;
        if (p_184569_1_ != null && blockpos.distanceSqToCenter(this.field_70165_t, this.field_70163_u, this.field_70161_v) >= 4.0) {
            BlockPos blockpos1 = new BlockPos(this);
            ArrayList list = Lists.newArrayList();
            if (p_184569_1_.func_82601_c() == 0) {
                if (blockpos1.getX() < blockpos.getX() && this.field_70170_p.func_147437_c(blockpos1.west().getX(), blockpos1.getY(), blockpos1.getZ())) {
                    list.add(EnumFacing.WEST);
                } else if (blockpos1.getX() > blockpos.getX() && this.field_70170_p.func_147437_c(blockpos1.east().getX(), blockpos1.getY(), blockpos1.getZ())) {
                    list.add(EnumFacing.EAST);
                }
            }
            if (p_184569_1_.func_96559_d() == 0) {
                if (blockpos1.getY() < blockpos.getY() && this.field_70170_p.func_147437_c(blockpos1.getX(), blockpos1.up().getY(), blockpos1.getZ())) {
                    list.add(EnumFacing.UP);
                } else if (blockpos1.getY() > blockpos.getY() && this.field_70170_p.func_147437_c(blockpos1.getX(), blockpos1.down().getY(), blockpos1.getZ())) {
                    list.add(EnumFacing.DOWN);
                }
            }
            if (p_184569_1_.func_82599_e() == 0) {
                if (blockpos1.getZ() < blockpos.getZ() && this.field_70170_p.func_147437_c(blockpos1.getX(), blockpos1.getY(), blockpos1.south().getZ())) {
                    list.add(EnumFacing.SOUTH);
                } else if (blockpos1.getZ() > blockpos.getZ() && this.field_70170_p.func_147437_c(blockpos1.getX(), blockpos1.getY(), blockpos1.north().getZ())) {
                    list.add(EnumFacing.NORTH);
                }
            }
            enumfacing = EnumFacing.func_82600_a((int)this.field_70146_Z.nextInt(6));
            if (list.isEmpty()) {
                for (int i = 5; !this.field_70170_p.func_147437_c(blockpos1.getX() + enumfacing.func_82601_c(), blockpos1.getY() + enumfacing.func_96559_d(), blockpos1.getZ() + enumfacing.func_82599_e()) && i > 0; --i) {
                    enumfacing = EnumFacing.func_82600_a((int)this.field_70146_Z.nextInt(6));
                }
            } else {
                enumfacing = (EnumFacing)list.get(this.field_70146_Z.nextInt(list.size()));
            }
            d1 = this.field_70165_t + (double)enumfacing.func_82601_c();
            d2 = this.field_70163_u + (double)enumfacing.func_96559_d();
            d3 = this.field_70161_v + (double)enumfacing.func_82599_e();
        }
        this.setDirection(enumfacing);
        double d6 = d1 - this.field_70165_t;
        double d7 = d2 - this.field_70163_u;
        double d4 = d3 - this.field_70161_v;
        double d5 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7 + d4 * d4));
        if (d5 == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = d6 / d5 * 0.15;
            this.targetDeltaY = d7 / d5 * 0.15;
            this.targetDeltaZ = d4 / d5 * 0.15;
        }
        this.field_70160_al = true;
        this.steps = 10 + this.field_70146_Z.nextInt(5) * 10;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        } else {
            MovingObjectPosition raytraceresult;
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K) {
                if (this.target == null && this.targetUniqueId != null) {
                    for (EntityLivingBase entitylivingbase : this.field_70170_p.func_72872_a(EntityLivingBase.class, BlockPos.getBB(this.targetBlockPos.add(-2, -2, -2), this.targetBlockPos.add(2, 2, 2)))) {
                        if (!entitylivingbase.func_110124_au().equals(this.targetUniqueId)) continue;
                        this.target = entitylivingbase;
                        break;
                    }
                    this.targetUniqueId = null;
                }
                if (this.owner == null && this.ownerUniqueId != null) {
                    for (EntityLivingBase entitylivingbase1 : this.field_70170_p.func_72872_a(EntityLivingBase.class, BlockPos.getBB(this.ownerBlockPos.add(-2, -2, -2), this.ownerBlockPos.add(2, 2, 2)))) {
                        if (!entitylivingbase1.func_110124_au().equals(this.ownerUniqueId)) continue;
                        this.owner = entitylivingbase1;
                        break;
                    }
                    this.ownerUniqueId = null;
                }
                if (this.target == null || !this.target.func_70089_S()) {
                    this.field_70181_x -= 0.04;
                } else {
                    this.targetDeltaX = MathHelper.func_151237_a((double)(this.targetDeltaX * 1.025), (double)-1.0, (double)1.0);
                    this.targetDeltaY = MathHelper.func_151237_a((double)(this.targetDeltaY * 1.025), (double)-1.0, (double)1.0);
                    this.targetDeltaZ = MathHelper.func_151237_a((double)(this.targetDeltaZ * 1.025), (double)-1.0, (double)1.0);
                    this.field_70159_w += (this.targetDeltaX - this.field_70159_w) * 0.2;
                    this.field_70181_x += (this.targetDeltaY - this.field_70181_x) * 0.2;
                    this.field_70179_y += (this.targetDeltaZ - this.field_70179_y) * 0.2;
                }
            }
            if (this.field_70173_aa == 1 && this.field_70170_p.field_72995_K) {
                this.firstTick();
            }
            if ((raytraceresult = Utils.forwardsRaycast(this, true, false, (Entity)(this.field_70173_aa <= 30 ? this.owner : null))) != null) {
                this.bulletHit(raytraceresult);
            }
            this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            Utils.rotateTowardsMovement(this, 0.5f);
            if (this.field_70170_p.field_72995_K) {
                ParticleHandler.END_ROD.spawn(this.field_70170_p, this.field_70165_t - this.field_70159_w, this.field_70163_u - this.field_70181_x + 0.15, this.field_70161_v - this.field_70179_y);
            } else if (this.target != null && !this.target.field_70128_L) {
                if (this.steps > 0) {
                    --this.steps;
                    if (this.steps == 0) {
                        this.selectNextMoveDirection(this.direction);
                    }
                }
                if (this.direction != null) {
                    BlockPos blockpos = new BlockPos(this);
                    EnumFacing enumfacing$axis = this.direction;
                    if (this.field_70170_p.func_147445_c(blockpos.getX() + this.direction.func_82601_c(), blockpos.getY() + this.direction.func_96559_d(), blockpos.getZ() + this.direction.func_82599_e(), false)) {
                        this.selectNextMoveDirection(enumfacing$axis);
                    } else {
                        BlockPos blockpos1 = new BlockPos(this.target);
                        if (enumfacing$axis.func_82601_c() != 0 && blockpos.getX() == blockpos1.getX() || enumfacing$axis.func_96559_d() != 0 && blockpos.getY() == blockpos1.getY() || enumfacing$axis.func_82599_e() != 0 && blockpos.getZ() == blockpos1.getZ()) {
                            this.selectNextMoveDirection(enumfacing$axis);
                        }
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double p_70056_1_, double p_70056_3_, double p_70056_5_, float p_70056_7_, float p_70056_8_, int p_70056_9_) {
        this.func_70107_b(p_70056_1_, p_70056_3_, p_70056_5_);
        this.func_70101_b(p_70056_7_, p_70056_8_);
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_70112_a(double distance) {
        return distance < 16384.0;
    }

    public float func_70013_c(float partialTicks) {
        return 1.0f;
    }

    public int func_70070_b(float partialTicks) {
        return 0xF000F0;
    }

    protected void bulletHit(MovingObjectPosition result) {
        boolean flag;
        if (result.field_72308_g == null) {
            this.field_70170_p.func_72869_a("largeexplode", this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, 0.2, 0.2, 0.2);
            this.func_85030_a("etfuturum:entity.shulker_bullet.hit", 1.0f, 1.0f);
        } else if (!this.field_70170_p.field_72995_K && (flag = result.field_72308_g.func_70097_a((DamageSource)new EntityDamageSourceIndirect("mob", (Entity)this, (Entity)this.owner), 4.0f)) && result.field_72308_g instanceof EntityLivingBase) {
            ((EntityLivingBase)result.field_72308_g).func_70690_d(new PotionEffect(ModPotions.levitation.func_76396_c(), 200));
        }
        this.func_70106_y();
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        for (int i = 0; i < 12; ++i) {
            float bound = this.field_70130_N + 0.15f;
            this.field_70170_p.func_72869_a("crit", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * bound * 2.0f) - (double)bound, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * bound), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * bound * 2.0f) - (double)bound, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_85030_a("etfuturum:entity.shulker_bullet.hurt", 1.0f, 1.0f);
            this.func_70106_y();
        }
        return true;
    }
}

