/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.entities;

import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigTweaks;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import ganymedes01.etfuturum.entities.EntityShulkerBullet;
import ganymedes01.etfuturum.entities.ModEntityList;
import ganymedes01.etfuturum.recipes.ModRecipes;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class EntityShulker
extends EntityGolem
implements IMob {
    private static final UUID COVERED_ARMOR_BONUS_ID = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF27F");
    private static final AttributeModifier COVERED_ARMOR_BONUS_MODIFIER = new AttributeModifier(COVERED_ARMOR_BONUS_ID, "Covered armor bonus", 20.0, 0).func_111168_a(false);
    private static final int ATTACHED_FACE = 12;
    private static final int PEEK_TICK = 13;
    private static final int ATTACHED_X = 14;
    private static final int ATTACHED_Y = 15;
    private static final int ATTACHED_Z = 16;
    private static final int COLOR = 17;
    private float currentPeekAmount0;
    private float currentPeekAmount;
    private BlockPos currentAttachmentPosition;
    private int clientSideTeleportInterpolation;

    public EntityShulker(World p_i1686_1_) {
        super(p_i1686_1_);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIAttack());
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIPeek());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AIAttackNearest(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new AIDefenseAttack(this));
        this.func_70105_a(1.0f, 1.0f);
        this.field_82179_bU = true;
    }

    protected boolean func_70692_ba() {
        return !this.func_104002_bU();
    }

    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        return 180.0f;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData p_110161_1_) {
        this.field_70761_aq = 180.0f;
        this.field_70760_ar = 180.0f;
        this.field_70177_z = 180.0f;
        this.field_70126_B = 180.0f;
        this.field_70759_as = 180.0f;
        this.field_70758_at = 180.0f;
        return super.func_110161_a(p_110161_1_);
    }

    public void func_70012_b(double p_70012_1_, double p_70012_3_, double p_70012_5_, float p_70012_7_, float p_70012_8_) {
        super.func_70012_b(p_70012_1_, p_70012_3_, p_70012_5_, p_70012_7_, p_70012_8_);
        if (this.func_70654_ax() == 0) {
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)this.field_70163_u);
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            this.setAttachmentPos(new BlockPos(x, y, z));
            for (EnumFacing enumfacing1 : EnumFacing.values()) {
                if (!this.field_70170_p.func_147445_c(x + enumfacing1.func_82601_c(), y + enumfacing1.func_96559_d(), z + enumfacing1.func_82599_e(), false)) continue;
                this.func_70096_w().func_75692_b(12, (Object)((byte)enumfacing1.ordinal()));
                break;
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(12, (Object)0);
        this.func_70096_w().func_75682_a(13, (Object)0);
        this.func_70096_w().func_75682_a(14, (Object)0);
        this.func_70096_w().func_75682_a(15, (Object)-1);
        this.func_70096_w().func_75682_a(16, (Object)0);
        this.func_70096_w().func_75682_a(17, (Object)16);
    }

    public void setColor(byte color) {
        this.func_70096_w().func_75692_b(17, (Object)((byte)Math.min(Math.max(color, 0), 16)));
    }

    public byte getColor() {
        return this.func_70096_w().func_75683_a(17);
    }

    protected String func_70639_aQ() {
        return "minecraft_1.18:entity.shulker.ambient";
    }

    protected String func_70621_aR() {
        return "minecraft_1.18:entity.shulker.hurt" + (this.isClosed() ? "_closed" : "");
    }

    protected String func_70673_aS() {
        return "minecraft_1.18:entity.shulker.death";
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70642_aH() {
        if (!this.isClosed()) {
            super.func_70642_aH();
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_70096_w().func_75692_b(12, (Object)((byte)EnumFacing.func_82600_a((int)compound.func_74771_c("AttachFace")).ordinal()));
        this.func_70096_w().func_75692_b(13, (Object)compound.func_74771_c("Peek"));
        this.setAttachmentPos(new BlockPos(compound.func_74762_e("APX"), compound.func_74762_e("APY"), compound.func_74762_e("APZ")));
        this.setColor(compound.func_74771_c("Color"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("AttachFace", this.func_70096_w().func_75683_a(12));
        compound.func_74774_a("Peek", this.func_70096_w().func_75683_a(13));
        compound.func_74768_a("APX", this.func_70096_w().func_75679_c(14));
        compound.func_74768_a("APY", this.func_70096_w().func_75679_c(15));
        compound.func_74768_a("APZ", this.func_70096_w().func_75679_c(16));
        compound.func_74774_a("Color", this.func_70096_w().func_75683_a(17));
    }

    public BlockPos getAttachmentPos() {
        return new BlockPos(this.func_70096_w().func_75679_c(14), this.func_70096_w().func_75679_c(15), this.func_70096_w().func_75679_c(16));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        BlockPos blockpos = this.getAttachmentPos();
        if (this.getColor() != 16 && this.field_70170_p.func_147439_a(blockpos.getX(), blockpos.getY(), blockpos.getZ()).func_149688_o() == Material.field_151586_h) {
            this.setColor((byte)16);
        }
        if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && this.func_70638_az() instanceof EntityPlayer) {
            this.func_70624_b(null);
        }
        if (blockpos.getY() == -1 && !this.field_70170_p.field_72995_K) {
            blockpos = new BlockPos((Entity)this);
            this.func_70096_w().func_75692_b(14, (Object)blockpos.getX());
            this.func_70096_w().func_75692_b(15, (Object)blockpos.getY());
            this.func_70096_w().func_75692_b(16, (Object)blockpos.getZ());
        }
        if (this.func_70115_ae()) {
            float f;
            blockpos = null;
            this.field_70177_z = f = this.field_70154_o.field_70177_z;
            this.field_70761_aq = f;
            this.field_70760_ar = f;
            this.clientSideTeleportInterpolation = 0;
        } else if (!this.field_70170_p.field_72995_K) {
            int ordinal;
            int opposite;
            BlockPos blockpos2;
            BlockPos blockpos1;
            Block iblockstate = this.field_70170_p.func_147439_a(blockpos.getX(), blockpos.getY(), blockpos.getZ());
            if (iblockstate != Blocks.field_150350_a) {
                if (iblockstate == Blocks.field_150326_M) {
                    EnumFacing enumfacing = EnumFacing.func_82600_a((int)this.field_70170_p.func_72805_g(blockpos.getX(), blockpos.getY(), blockpos.getZ()));
                    blockpos = blockpos.offset(enumfacing);
                    this.setAttachmentPos(blockpos);
                } else if (iblockstate == Blocks.field_150332_K) {
                    EnumFacing enumfacing3 = EnumFacing.func_82600_a((int)this.field_70170_p.func_72805_g(blockpos.getX(), blockpos.getY(), blockpos.getZ()));
                    blockpos = blockpos.offset(enumfacing3);
                    this.setAttachmentPos(blockpos);
                } else {
                    this.tryTeleportToNewPosition();
                }
            }
            if (!this.field_70170_p.func_147445_c((blockpos1 = blockpos.offset(this.getAttachmentFacing())).getX(), blockpos1.getY(), blockpos1.getZ(), false)) {
                boolean flag = false;
                for (EnumFacing enumfacing1 : EnumFacing.values()) {
                    if (!this.field_70170_p.func_147445_c(blockpos.getX() + enumfacing1.func_82601_c(), blockpos.getY() + enumfacing1.func_96559_d(), blockpos.getZ() + enumfacing1.func_82599_e(), false)) continue;
                    this.func_70096_w().func_75692_b(12, (Object)((byte)enumfacing1.ordinal()));
                    flag = true;
                    break;
                }
                if (!flag) {
                    this.tryTeleportToNewPosition();
                }
            }
            if (this.field_70170_p.func_147445_c((blockpos2 = blockpos.offset(EnumFacing.func_82600_a((int)(opposite = (ordinal = (ordinal = this.getAttachmentFacing().ordinal()) % 2 == 0 ? ordinal + 1 : ordinal - 1))))).getX(), blockpos2.getY(), blockpos2.getZ(), false)) {
                this.tryTeleportToNewPosition();
            }
        }
        float f1 = (float)this.getPeekTick() * 0.01f;
        this.currentPeekAmount0 = this.currentPeekAmount;
        if (this.currentPeekAmount > f1) {
            this.currentPeekAmount = MathHelper.func_76131_a((float)(this.currentPeekAmount - 0.05f), (float)f1, (float)1.0f);
        } else if (this.currentPeekAmount < f1) {
            this.currentPeekAmount = MathHelper.func_76131_a((float)(this.currentPeekAmount + 0.05f), (float)0.0f, (float)f1);
        }
        if (blockpos != null) {
            List list;
            if (this.field_70170_p.field_72995_K) {
                if (this.clientSideTeleportInterpolation > 0 && this.currentAttachmentPosition != null) {
                    --this.clientSideTeleportInterpolation;
                } else {
                    this.currentAttachmentPosition = blockpos;
                }
            }
            this.field_70169_q = this.field_70165_t = (double)blockpos.getX() + 0.5;
            this.field_70142_S = this.field_70165_t;
            this.field_70167_r = this.field_70163_u = (double)blockpos.getY();
            this.field_70137_T = this.field_70163_u;
            this.field_70166_s = this.field_70161_v = (double)blockpos.getZ() + 0.5;
            this.field_70136_U = this.field_70161_v;
            double d3 = 0.5 - (double)MathHelper.func_76126_a((float)((0.5f + this.currentPeekAmount) * (float)Math.PI)) * 0.5;
            double d4 = 0.5 - (double)MathHelper.func_76126_a((float)((0.5f + this.currentPeekAmount0) * (float)Math.PI)) * 0.5;
            double d5 = d3 - d4;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            EnumFacing enumfacing2 = this.getAttachmentFacing();
            switch (enumfacing2) {
                default: {
                    this.field_70121_D.func_72324_b(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0 + d3, this.field_70161_v + 0.5);
                    d1 = d5;
                    break;
                }
                case UP: {
                    this.field_70121_D.func_72324_b(this.field_70165_t - 0.5, this.field_70163_u - d3, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5);
                    d1 = -d5;
                    break;
                }
                case NORTH: {
                    this.field_70121_D.func_72324_b(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5 + d3);
                    d2 = d5;
                    break;
                }
                case SOUTH: {
                    this.field_70121_D.func_72324_b(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5 - d3, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5);
                    d2 = -d5;
                    break;
                }
                case WEST: {
                    this.field_70121_D.func_72324_b(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5 + d3, this.field_70163_u + 1.0, this.field_70161_v + 0.5);
                    d0 = d5;
                    break;
                }
                case EAST: {
                    this.field_70121_D.func_72324_b(this.field_70165_t - 0.5 - d3, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5);
                    d0 = -d5;
                }
            }
            if (d5 > 0.0 && !(list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D)).isEmpty()) {
                for (Entity entity : list) {
                    if (entity instanceof EntityShulker || entity.field_70145_X) continue;
                    entity.func_70091_d(d0, d1, d2);
                }
            }
        }
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.func_70096_w() != null && this.field_70173_aa != 0) {
            int xpos = MathHelper.func_76128_c((double)x);
            int ypos = MathHelper.func_76128_c((double)y);
            int zpos = MathHelper.func_76128_c((double)z);
            if (this.func_70096_w().func_75679_c(14) != xpos || this.func_70096_w().func_75679_c(15) != ypos || this.func_70096_w().func_75679_c(16) != zpos) {
                this.setAttachmentPos(new BlockPos(xpos, ypos, zpos));
                if (!this.func_70115_ae()) {
                    this.func_70096_w().func_75692_b(13, (Object)0);
                }
                this.field_70160_al = true;
            }
        }
    }

    protected boolean tryTeleportToNewPosition() {
        if (this.func_70650_aV() && this.func_70089_S()) {
            for (int i = 0; i < 5; ++i) {
                int newx = MathHelper.func_76128_c((double)this.field_70165_t) + 8 - this.field_70146_Z.nextInt(17);
                int newy = MathHelper.func_76128_c((double)this.field_70163_u) + 8 - this.field_70146_Z.nextInt(17);
                int newz = MathHelper.func_76128_c((double)this.field_70161_v) + 8 - this.field_70146_Z.nextInt(17);
                if (newy <= 0 || !this.field_70170_p.func_147437_c(newx, newy, newz) || !this.field_70170_p.func_72945_a((Entity)this, AxisAlignedBB.func_72330_a((double)newx, (double)newy, (double)newz, (double)(newx + 1), (double)(newy + 1), (double)(newz + 1))).isEmpty()) continue;
                boolean flag = false;
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    if (!this.field_70170_p.func_147445_c(newx + enumfacing.func_82601_c(), newy + enumfacing.func_96559_d(), newz + enumfacing.func_82599_e(), false)) continue;
                    this.func_70096_w().func_75692_b(12, (Object)((byte)enumfacing.ordinal()));
                    flag = true;
                    break;
                }
                if (!flag) continue;
                this.func_85030_a("minecraft_1.18:entity.shulker.teleport", 1.0f, 1.0f);
                this.setAttachmentPos(new BlockPos(newx, newy, newz));
                this.func_70096_w().func_75692_b(13, (Object)0);
                this.func_70624_b(null);
                return true;
            }
            return false;
        }
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70760_ar = 180.0f;
        this.field_70761_aq = 180.0f;
        this.field_70177_z = 180.0f;
    }

    public void func_145781_i(int key) {
        BlockPos blockpos;
        if ((key == 14 || key == 15 || key == 16) && this.field_70170_p.field_72995_K && !this.func_70115_ae() && (blockpos = this.getAttachmentPos()).getY() != -1) {
            if (this.currentAttachmentPosition == null) {
                this.currentAttachmentPosition = blockpos;
            } else if (this.field_70173_aa > 0) {
                this.clientSideTeleportInterpolation = 6;
            }
            this.field_70169_q = this.field_70165_t = (double)blockpos.getX() + 0.5;
            this.field_70142_S = this.field_70165_t;
            this.field_70167_r = this.field_70163_u = (double)blockpos.getY();
            this.field_70137_T = this.field_70163_u;
            this.field_70166_s = this.field_70161_v = (double)blockpos.getZ() + 0.5;
            this.field_70136_U = this.field_70161_v;
        }
        super.func_145781_i(key);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity;
        if (this.isClosed() && (entity = source.func_76364_f()) instanceof EntityArrow) {
            return false;
        }
        if (super.func_70097_a(source, amount)) {
            if ((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.5 && this.field_70146_Z.nextInt(4) == 0) {
                this.tryTeleportToNewPosition();
            } else if (source.func_76364_f() instanceof EntityShulkerBullet) {
                int x = MathHelper.func_76128_c((double)this.field_70165_t);
                int y = MathHelper.func_76128_c((double)this.field_70163_u);
                int z = MathHelper.func_76128_c((double)this.field_70161_v);
                boolean prevClosed = this.isClosed();
                boolean teleported = this.tryTeleportToNewPosition();
                if (this.func_70089_S() && teleported && !prevClosed) {
                    int i = this.field_70170_p.func_82733_a(EntityShulker.class, this.field_70121_D.func_72314_b(8.0, 8.0, 8.0), IEntitySelector.field_94557_a).size();
                    float f = (float)(i - 1) / 5.0f;
                    if (!(this.field_70170_p.field_73012_v.nextFloat() < f)) {
                        EntityShulker newShulker = new EntityShulker(this.field_70170_p);
                        newShulker.func_70107_b(x, y, z);
                        newShulker.setColor(this.getColor());
                        this.field_70170_p.func_72838_d((Entity)newShulker);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean isClosed() {
        return this.getPeekTick() == 0;
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_70089_S() ? this.field_70121_D : null;
    }

    public EnumFacing getAttachmentFacing() {
        return EnumFacing.func_82600_a((int)this.func_70096_w().func_75683_a(12));
    }

    public void setAttachmentPos(BlockPos pos) {
        this.func_70096_w().func_75692_b(14, (Object)pos.getX());
        this.func_70096_w().func_75692_b(15, (Object)pos.getY());
        this.func_70096_w().func_75692_b(16, (Object)pos.getZ());
    }

    public int getPeekTick() {
        return this.func_70096_w().func_75683_a(13);
    }

    public void updateArmorModifier(int p_184691_1_) {
        if (!this.field_70170_p.field_72995_K) {
            if (p_184691_1_ == 0) {
                this.func_85030_a("minecraft_1.18:entity.shulker.close", 1.0f, 1.0f);
            } else {
                this.func_85030_a("minecraft_1.18:entity.shulker.open", 1.0f, 1.0f);
            }
        }
        this.func_70096_w().func_75692_b(13, (Object)((byte)p_184691_1_));
    }

    public int func_70658_aO() {
        return this.isClosed() ? 20 : super.func_70658_aO();
    }

    public float getClientPeekAmount(float p_184688_1_) {
        return this.currentPeekAmount0 + (this.currentPeekAmount - this.currentPeekAmount0) * p_184688_1_;
    }

    public int getClientTeleportInterp() {
        return this.clientSideTeleportInterpolation;
    }

    public BlockPos getOldAttachPos() {
        return this.currentAttachmentPosition;
    }

    public float func_70047_e() {
        return 0.5f;
    }

    public int func_70646_bf() {
        return 180;
    }

    public void func_70108_f(Entity entityIn) {
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public boolean isAttachedToBlock() {
        return this.currentAttachmentPosition != null && this.getAttachmentPos().getY() != -1;
    }

    protected Item func_146068_u() {
        return ConfigBlocksItems.enableShulkerBoxes ? ModItems.shulker_shell : null;
    }

    public void func_70604_c(EntityLivingBase p_70604_1_) {
        if (this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            super.func_70604_c(p_70604_1_);
        }
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        Item item = this.func_146068_u();
        float chance = this.field_70146_Z.nextFloat();
        chance = (float)((double)chance + (double)p_70628_2_ * 0.0625);
        if (item != null && (double)chance > 0.5) {
            this.func_145779_a(item, 1);
        }
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return ModEntityList.getEggFromEntity((Entity)this);
    }

    public void func_71027_c(int p_71027_1_) {
        super.func_71027_c(p_71027_1_);
        this.setAttachmentPos(new BlockPos((Entity)this));
    }

    public void func_110145_l(Entity p_110145_1_) {
        super.func_110145_l(p_110145_1_);
        int y = (int)this.field_70163_u;
        if (this.field_70170_p.func_147437_c(MathHelper.func_76128_c((double)this.field_70165_t), y - 1, MathHelper.func_76128_c((double)this.field_70161_v))) {
            --y;
        }
        this.setAttachmentPos(new BlockPos(this.field_70165_t, (double)y, this.field_70161_v));
    }

    public boolean func_70085_c(EntityPlayer p_70085_1_) {
        ItemStack stack = p_70085_1_.func_71045_bC();
        if (ConfigTweaks.dyableShulkers && stack != null) {
            if (stack.func_77973_b() instanceof ItemBucket && ((ItemBucket)stack.func_77973_b()).field_77876_a == Blocks.field_150358_i && this.getColor() != 16) {
                this.setColor((byte)16);
                return true;
            }
            for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
                byte color = (byte)(~ArrayUtils.indexOf((Object[])ModRecipes.ore_dyes, (Object)OreDictionary.getOreName((int)oreID)) & 0xF);
                if (!ArrayUtils.contains((Object[])ModRecipes.ore_dyes, (Object)OreDictionary.getOreName((int)oreID)) || this.getColor() == color) continue;
                this.setColor(color);
                if (!p_70085_1_.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                return true;
            }
        }
        return super.func_70085_c(p_70085_1_);
    }

    class AIPeek
    extends EntityAIBase {
        private int peekTime;

        public boolean func_75250_a() {
            return EntityShulker.this.func_70638_az() == null && EntityShulker.this.field_70146_Z.nextInt(40) == 0;
        }

        public boolean func_75253_b() {
            return EntityShulker.this.func_70638_az() == null && this.peekTime > 0;
        }

        public void func_75249_e() {
            this.peekTime = 20 * (1 + EntityShulker.this.field_70146_Z.nextInt(3));
            EntityShulker.this.updateArmorModifier(30);
        }

        public void func_75251_c() {
            if (EntityShulker.this.func_70638_az() == null) {
                EntityShulker.this.updateArmorModifier(0);
            }
        }

        public void func_75246_d() {
            --this.peekTime;
        }
    }

    static class AIDefenseAttack
    extends EntityAINearestAttackableTarget {
        public AIDefenseAttack(EntityShulker shulker) {
            super((EntityCreature)shulker, EntityLivingBase.class, 10, true);
        }

        public boolean func_75250_a() {
            return this.field_75299_d.func_96124_cp() == null ? false : super.func_75250_a();
        }

        protected AxisAlignedBB getTargetableArea(double targetDistance) {
            EnumFacing enumfacing = ((EntityShulker)this.field_75299_d).getAttachmentFacing();
            return enumfacing.func_82601_c() != 0 ? this.field_75299_d.field_70121_D.func_72314_b(4.0, targetDistance, targetDistance) : (enumfacing.func_82599_e() != 0 ? this.field_75299_d.field_70121_D.func_72314_b(targetDistance, targetDistance, 4.0) : this.field_75299_d.field_70121_D.func_72314_b(targetDistance, 4.0, targetDistance));
        }
    }

    class AIAttackNearest
    extends EntityAINearestAttackableTarget {
        public AIAttackNearest(EntityShulker shulker) {
            super((EntityCreature)shulker, EntityPlayer.class, 0, true);
        }

        public boolean func_75250_a() {
            return EntityShulker.this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL ? false : super.func_75250_a();
        }

        protected AxisAlignedBB getTargetableArea(double targetDistance) {
            EnumFacing enumfacing = ((EntityShulker)this.field_75299_d).getAttachmentFacing();
            return enumfacing.func_82601_c() != 0 ? this.field_75299_d.field_70121_D.func_72314_b(4.0, targetDistance, targetDistance) : (enumfacing.func_82599_e() != 0 ? this.field_75299_d.field_70121_D.func_72314_b(targetDistance, targetDistance, 4.0) : this.field_75299_d.field_70121_D.func_72314_b(targetDistance, 4.0, targetDistance));
        }
    }

    class AIAttack
    extends EntityAIBase {
        private int attackTime;

        public AIAttack() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = EntityShulker.this.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S() ? EntityShulker.this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL : false;
        }

        public void func_75249_e() {
            this.attackTime = 20;
            EntityShulker.this.updateArmorModifier(100);
        }

        public void func_75251_c() {
            EntityShulker.this.updateArmorModifier(0);
        }

        public void func_75246_d() {
            if (EntityShulker.this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
                --this.attackTime;
                EntityLivingBase entitylivingbase = EntityShulker.this.func_70638_az();
                EntityShulker.this.func_70671_ap().func_75651_a((Entity)entitylivingbase, 180.0f, 180.0f);
                double d0 = EntityShulker.this.func_70068_e((Entity)entitylivingbase);
                if (d0 < 400.0) {
                    if (this.attackTime <= 0) {
                        this.attackTime = 20 + EntityShulker.this.field_70146_Z.nextInt(10) * 20 / 2;
                        EntityShulkerBullet entityshulkerbullet = new EntityShulkerBullet(EntityShulker.this.field_70170_p, (EntityLivingBase)EntityShulker.this, (Entity)entitylivingbase, EntityShulker.this.getAttachmentFacing());
                        EntityShulker.this.field_70170_p.func_72838_d((Entity)entityshulkerbullet);
                        EntityShulker.this.func_85030_a("minecraft_1.18:entity.shulker.shoot", 1.0f, 1.0f);
                    }
                } else {
                    EntityShulker.this.func_70624_b(null);
                }
                super.func_75246_d();
            }
        }
    }
}

