/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.handlers;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.ModEnchantments;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.blocks.BlockMagma;
import ganymedes01.etfuturum.blocks.BlockWitherRose;
import ganymedes01.etfuturum.blocks.ExternalContent;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigEnchantsPotions;
import ganymedes01.etfuturum.configuration.configs.ConfigEntities;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.configuration.configs.ConfigMixins;
import ganymedes01.etfuturum.configuration.configs.ConfigTweaks;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.core.utils.HoeHelper;
import ganymedes01.etfuturum.core.utils.RawOreRegistry;
import ganymedes01.etfuturum.core.utils.StrippedLogRegistry;
import ganymedes01.etfuturum.core.utils.helpers.BlockAndMetadataMapping;
import ganymedes01.etfuturum.core.utils.helpers.RawOreDropMapping;
import ganymedes01.etfuturum.entities.EntityBrownMooshroom;
import ganymedes01.etfuturum.entities.EntityEndermite;
import ganymedes01.etfuturum.entities.EntityNewBoat;
import ganymedes01.etfuturum.entities.EntityNewSnowGolem;
import ganymedes01.etfuturum.entities.EntityRabbit;
import ganymedes01.etfuturum.entities.EntityShulker;
import ganymedes01.etfuturum.entities.EntityTippedArrow;
import ganymedes01.etfuturum.entities.EntityZombieVillager;
import ganymedes01.etfuturum.entities.ai.EntityAIOpenCustomDoor;
import ganymedes01.etfuturum.inventory.ContainerEnchantment;
import ganymedes01.etfuturum.items.ItemArrowTipped;
import ganymedes01.etfuturum.network.BlackHeartParticlesMessage;
import ganymedes01.etfuturum.recipes.ModRecipes;
import ganymedes01.etfuturum.tileentities.TileEntityGateway;
import ganymedes01.etfuturum.world.EtFuturumWorldListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S29PacketSoundEffect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class ServerEventHandler {
    public static final ServerEventHandler INSTANCE = new ServerEventHandler();
    public static HashSet<EntityPlayerMP> playersClosedContainers = new HashSet();
    private Set<Chunk> loadedChunks = Collections.newSetFromMap(new WeakHashMap());
    private Set<Long> debugCoords = new HashSet<Long>();

    private ServerEventHandler() {
    }

    @SubscribeEvent
    public void onPlayerPickXP(PlayerPickupXpEvent event) {
        ModEnchantments.onPlayerPickupXP(event);
    }

    @SubscribeEvent
    public void livingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity.field_70170_p == null) {
            return;
        }
        ModEnchantments.onLivingUpdate(entity);
        double x = entity.field_70165_t;
        double y = entity.field_70163_u;
        double z = entity.field_70161_v;
        if (ConfigBlocksItems.enableMagmaBlock && !entity.func_70045_F() && !entity.func_70093_af() && entity.field_70122_E && entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)x), (int)(y - 0.45), MathHelper.func_76128_c((double)z)) == ModBlocks.magma_block && ConfigEnchantsPotions.enableFrostWalker && EnchantmentHelper.func_77506_a((int)ConfigEnchantsPotions.frostWalkerID, (ItemStack)entity.func_71124_b(1)) == 0) {
            entity.func_70097_a(BlockMagma.HOT_FLOOR, 1.0f);
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (ConfigEntities.flySprintSpeed > 0.05f) {
                player.field_71075_bZ.field_75096_f = player.func_70051_ag() && player.field_71075_bZ.field_75100_b ? ConfigEntities.flySprintSpeed : 0.05f;
            }
        }
        if (ConfigMixins.stepHeightFix && event.entity.field_70138_W == 0.5f) {
            event.entity.field_70138_W = 0.6f;
        }
    }

    @SubscribeEvent
    public void entityAdded(EntityJoinWorldEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        Chunk chunk = event.world.func_72964_e(MathHelper.func_76128_c((double)event.entity.field_70165_t) >> 4, MathHelper.func_76128_c((double)event.entity.field_70161_v) >> 4);
        if (ConfigBlocksItems.enableNewBoats && ConfigBlocksItems.replaceOldBoats && event.entity.getClass() == EntityBoat.class) {
            EntityNewBoat boat = new EntityNewBoat(event.world);
            event.entity.field_70177_z += 90.0f;
            this.replaceEntity(event.entity, boat, event.world, chunk);
            boat.setBoatType(EntityNewBoat.Type.OAK);
            event.setCanceled(true);
            return;
        }
        if (ConfigEntities.enableVillagerZombies && event.entity.getClass() == EntityZombie.class && ((EntityZombie)event.entity).func_82231_m()) {
            this.replaceEntity(event.entity, (Entity)new EntityZombieVillager(event.world), event.world, chunk);
            event.setCanceled(true);
            return;
        }
        if (ConfigEntities.enableShearableSnowGolems && event.entity.getClass() == EntitySnowman.class) {
            EntityNewSnowGolem entity = new EntityNewSnowGolem(event.world);
            this.replaceEntity(event.entity, (Entity)entity, event.world, chunk);
            entity.func_70096_w().func_75692_b(12, (Object)1);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load event) {
        this.loadedChunks.add(event.getChunk());
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Unload event) {
        this.loadedChunks.remove(event.getChunk());
    }

    private void replaceEntity(Entity oldEntity, Entity newEntity, World world, Chunk chunk) {
        newEntity.func_82141_a(oldEntity, true);
        if (this.loadedChunks.contains(chunk)) {
            world.func_72838_d(newEntity);
        } else {
            chunk.func_76612_a(newEntity);
        }
        oldEntity.func_70106_y();
    }

    @SubscribeEvent
    public void livingAttack(LivingAttackEvent event) {
        EntityDamageSourceIndirect dmgSrc;
        if (event.source == DamageSource.field_82727_n && event.entityLiving instanceof EntitySkeleton && ((EntitySkeleton)event.entityLiving).func_82202_m() == 1) {
            event.setCanceled(true);
            return;
        }
        if (event.source instanceof EntityDamageSourceIndirect && (dmgSrc = (EntityDamageSourceIndirect)event.source).func_76364_f() instanceof EntityTippedArrow) {
            EntityTippedArrow tippedArrow = (EntityTippedArrow)dmgSrc.func_76364_f();
            if (!tippedArrow.field_70170_p.field_72995_K) {
                event.entityLiving.func_70690_d(tippedArrow.getEffect());
            }
        }
    }

    @SubscribeEvent
    public void arrowNock(ArrowNockEvent event) {
        if (event.result == null) {
            return;
        }
        InventoryPlayer invt = event.entityPlayer.field_71071_by;
        for (int i = 0; i < invt.func_70302_i_(); ++i) {
            ItemStack stack = invt.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= 0) continue;
            if (stack.func_77973_b() == Items.field_151032_g) {
                return;
            }
            if (stack.func_77973_b() != ModItems.tipped_arrow) continue;
            event.setCanceled(true);
            event.entityPlayer.func_71008_a(event.result, event.result.func_77973_b().func_77626_a(event.result));
            return;
        }
    }

    @SubscribeEvent
    public void arrowLoose(ArrowLooseEvent event) {
        if (event.bow == null) {
            return;
        }
        InventoryPlayer invt = event.entityPlayer.field_71071_by;
        for (int i = 0; i < invt.func_70302_i_(); ++i) {
            int punch;
            int power;
            ItemStack arrow = invt.func_70301_a(i);
            if (arrow == null || arrow.field_77994_a <= 0 || arrow.func_77973_b() != ModItems.tipped_arrow) continue;
            float charge = (float)event.charge / 20.0f;
            if ((double)(charge = (charge * charge + charge * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (charge > 1.0f) {
                charge = 1.0f;
            }
            EntityTippedArrow arrowEntity = new EntityTippedArrow(event.entityPlayer.field_70170_p, (EntityLivingBase)event.entityPlayer, charge * 2.0f);
            arrowEntity.setEffect(ItemArrowTipped.getEffect(arrow));
            if (charge == 1.0f) {
                arrowEntity.func_70243_d(true);
            }
            if ((power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)event.bow)) > 0) {
                arrowEntity.func_70239_b(arrowEntity.func_70242_d() + (double)power * 0.5 + 0.5);
            }
            if ((punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)event.bow)) > 0) {
                arrowEntity.func_70240_a(punch);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)event.bow) > 0) {
                arrowEntity.func_70015_d(100);
            }
            event.bow.func_77972_a(1, (EntityLivingBase)event.entityPlayer);
            event.entityPlayer.field_70170_p.func_72956_a((Entity)event.entityPlayer, "random.bow", 1.0f, 1.0f / (event.entityPlayer.field_70170_p.field_73012_v.nextFloat() * 0.4f + 1.2f) + charge * 0.5f);
            if (!event.entityPlayer.field_71075_bZ.field_75098_d && --arrow.field_77994_a <= 0) {
                event.entityPlayer.field_71071_by.func_70299_a(i, null);
            }
            if (!event.entityPlayer.field_70170_p.field_72995_K) {
                event.entityPlayer.field_70170_p.func_72838_d((Entity)arrowEntity);
            }
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onPlayerLoadFromFileEvent(PlayerEvent.LoadFromFile event) {
        if (!ConfigBlocksItems.enableEnchantingTable) {
            return;
        }
        try {
            File file = event.getPlayerFile("etfuturum");
            if (!file.exists()) {
                file.createNewFile();
                return;
            }
            BufferedReader br = new BufferedReader(new FileReader(file));
            String line = br.readLine();
            if (line != null) {
                int seed = Integer.parseInt(line);
                ContainerEnchantment.seeds.put(event.playerUUID, seed);
            }
            br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onPlayerSaveFromFileEvent(PlayerEvent.SaveToFile event) {
        if (!ConfigBlocksItems.enableEnchantingTable) {
            return;
        }
        try {
            File file = event.getPlayerFile("etfuturum");
            if (!file.exists()) {
                file.createNewFile();
                return;
            }
            Integer seed = ContainerEnchantment.seeds.get(event.playerUUID);
            if (seed != null) {
                BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                bw.write(seed.toString());
                bw.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void harvestEvent(BlockEvent.HarvestDropsEvent event) {
        ItemStack stack;
        int i;
        if (ConfigFunctions.enableSilkTouchingMushrooms && event.isSilkTouching) {
            if (event.block == Blocks.field_150420_aW) {
                event.drops.clear();
                event.drops.add(new ItemStack(ModBlocks.brown_mushroom_block));
            } else if (event.block == Blocks.field_150419_aX) {
                event.drops.clear();
                event.drops.add(new ItemStack(ModBlocks.red_mushroom_block));
            }
        }
        if (ConfigFunctions.enableSticksFromDeadBushes && event.block == Blocks.field_150330_I) {
            boolean isShears;
            boolean bl = isShears = event.harvester != null && event.harvester.func_71045_bC() != null && event.harvester.func_71045_bC().func_77973_b() instanceof ItemShears;
            if (event.harvester == null || event.harvester.func_71045_bC() == null || !isShears) {
                for (i = 0; i < event.world.field_73012_v.nextInt(3); ++i) {
                    event.drops.add(new ItemStack(Items.field_151055_y));
                }
            }
        }
        if (ConfigBlocksItems.enableRawOres && !event.isSilkTouching) {
            RawOreDropMapping mapping = null;
            block1: for (i = 0; i < event.drops.size(); ++i) {
                ItemStack stack2 = (ItemStack)event.drops.get(i);
                for (String oreName : EtFuturum.getOreStrings(stack2)) {
                    mapping = RawOreRegistry.getOreMap().get(oreName);
                    if (mapping == null) continue;
                    event.drops.set(i, new ItemStack(mapping.getItem(), mapping.getDropAmount(event.world.field_73012_v, event.fortuneLevel), mapping.getMeta()));
                    continue block1;
                }
            }
        }
        if (ConfigFunctions.enableShearableCobwebs && event.block == Blocks.field_150321_G && event.harvester != null && (stack = event.harvester.func_71045_bC()) != null && stack.func_77973_b() instanceof ItemShears) {
            event.drops.clear();
            event.drops.add(new ItemStack(Blocks.field_150321_G));
        }
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        ItemStack itemstack;
        if (ConfigFunctions.enableHoeMining && (double)event.block.func_149712_f(event.world, event.x, event.y, event.z) != 0.0 && (itemstack = event.getPlayer().func_70694_bm()) != null && itemstack.func_77973_b() instanceof ItemHoe) {
            itemstack.func_77972_a(1, (EntityLivingBase)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void breakSpeedEvent(PlayerEvent.BreakSpeed event) {
        ItemStack stack;
        boolean flag = false;
        float toolSpeed = 0.0f;
        float speedModifier = 0.0f;
        if (ConfigFunctions.enableHoeMining && HoeHelper.hoeArrayHas(event.block) && (stack = event.entityPlayer.func_70694_bm()) != null && stack.func_77973_b() instanceof ItemHoe) {
            try {
                Item hoe = stack.func_77973_b();
                toolSpeed = this.getHoeSpeed(hoe);
                speedModifier = this.speedModifier(event.entityPlayer, event.block, event.metadata, toolSpeed);
                flag = true;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        if (flag) {
            event.newSpeed = event.originalSpeed + toolSpeed + speedModifier;
        }
    }

    public float getHoeSpeed(Item item) {
        float returnValue = 0.0f;
        try {
            if (item instanceof ItemHoe || item instanceof ItemTool) {
                Item.ToolMaterial theToolMaterial = item instanceof ItemTool ? ((ItemTool)item).field_77862_b : ((ItemHoe)item).field_77843_a;
                returnValue = theToolMaterial.func_77998_b();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public float speedModifier(EntityPlayer entity, Block block, int meta, float digSpeed) {
        float moddedDigSpeed = 1.0f;
        int i = EnchantmentHelper.func_77509_b((EntityLivingBase)entity);
        ItemStack itemstack = entity.field_71071_by.func_70448_g();
        if (i > 0 && itemstack != null) {
            float f1 = i * i + 1;
            moddedDigSpeed += f1;
        }
        if (entity.func_70644_a(Potion.field_76422_e)) {
            moddedDigSpeed *= 1.0f + (float)(entity.func_70660_b(Potion.field_76422_e).func_76458_c() + 1) * 0.2f;
        }
        if (entity.func_70644_a(Potion.field_76419_f)) {
            moddedDigSpeed *= 1.0f - (float)(entity.func_70660_b(Potion.field_76419_f).func_76458_c() + 1) * 0.2f;
        }
        if (entity.func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_77510_g((EntityLivingBase)entity)) {
            moddedDigSpeed /= 5.0f;
        }
        if (!entity.field_70122_E) {
            moddedDigSpeed /= 5.0f;
        }
        return moddedDigSpeed - 1.0f < 0.0f ? 0.0f : moddedDigSpeed - 1.0f;
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.PlaceEvent event) {
        if (ConfigFunctions.enableFloatingTrapDoors && event.blockSnapshot.y - event.y != 0 && event.placedBlock instanceof BlockTrapDoor) {
            int l = MathHelper.func_76128_c((double)((double)(event.player.field_70177_z * 4.0f / 360.0f) + 0.5)) + 1 & 3;
            if (l == 0) {
                l = 1;
            } else if (l == 1) {
                l = 2;
            } else if (l == 2) {
                l = 0;
            }
            event.world.func_72921_c(event.x, event.y, event.z, l, 3);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        if ((event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK || event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) && player != null) {
            ItemStack heldStack = player.func_70694_bm();
            World world = event.world;
            int x = event.x;
            int y = event.y;
            int z = event.z;
            Block oldBlock = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            int side = event.face;
            if (player.func_82247_a(x, y, z, side, heldStack) && event.getResult() == event.useItem) {
                Set toolClasses;
                if (heldStack != null && !event.world.field_72995_K && ConfigWorld.enableNewMiscSounds && heldStack.func_77973_b() == Items.field_151061_bv && oldBlock == Blocks.field_150378_br && !BlockEndPortalFrame.func_150020_b((int)meta)) {
                    int i2;
                    int l2;
                    int l1;
                    world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "minecraft_1.18:block.end_portal_frame.fill", 1.0f, 1.0f);
                    int j1 = meta & 3;
                    int j2 = 0;
                    int k1 = 0;
                    boolean flag1 = false;
                    boolean flag = true;
                    int k2 = Direction.field_71577_f[j1];
                    for (l1 = -2; l1 <= 2; ++l1) {
                        l2 = x + Direction.field_71583_a[k2] * l1;
                        i2 = z + Direction.field_71581_b[k2] * l1;
                        if (world.func_147439_a(l2, y, i2) != Blocks.field_150378_br) continue;
                        if (!(BlockEndPortalFrame.func_150020_b((int)world.func_72805_g(l2, y, i2)) || l2 == x && i2 == z)) {
                            flag = false;
                            break;
                        }
                        k1 = l1;
                        if (flag1) continue;
                        j2 = l1;
                        flag1 = true;
                    }
                    if (flag && k1 == j2 + 2) {
                        for (l1 = j2; l1 <= k1; ++l1) {
                            l2 = x + Direction.field_71583_a[k2] * l1;
                            i2 = z + Direction.field_71581_b[k2] * l1;
                            if (world.func_147439_a(l2 += Direction.field_71583_a[j1] * 4, y, i2 += Direction.field_71581_b[j1] * 4) == Blocks.field_150378_br && BlockEndPortalFrame.func_150020_b((int)world.func_72805_g(l2, y, i2)) || l2 == x && i2 == z) continue;
                            flag = false;
                            break;
                        }
                        block2: for (l1 = j2 - 1; l1 <= k1 + 1; l1 += 4) {
                            for (l2 = 1; l2 <= 3; ++l2) {
                                i2 = x + Direction.field_71583_a[k2] * l1;
                                int i3 = z + Direction.field_71581_b[k2] * l1;
                                if (world.func_147439_a(i2 += Direction.field_71583_a[j1] * l2, y, i3 += Direction.field_71581_b[j1] * l2) == Blocks.field_150378_br && BlockEndPortalFrame.func_150020_b((int)world.func_72805_g(i2, y, i3)) || i2 == x && i3 == z) continue;
                                flag = false;
                                continue block2;
                            }
                        }
                        if (flag) {
                            for (WorldServer worldserver : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                                for (Object playerobj : worldserver.field_73010_i) {
                                    if (!(playerobj instanceof EntityPlayerMP)) continue;
                                    EntityPlayerMP playermp = (EntityPlayerMP)playerobj;
                                    playermp.field_71135_a.func_147359_a((Packet)new S29PacketSoundEffect("minecraft_1.18:block.end_portal.spawn", playermp.field_70165_t, playermp.field_70137_T, playermp.field_70161_v, 1.0f, 1.0f));
                                }
                            }
                        }
                    }
                }
                if (ConfigWorld.enableNewBlocksSounds && side == 1 && heldStack != null && heldStack.func_77973_b() instanceof IPlantable && player.func_82247_a(x, y + 1, z, side, heldStack) && world.func_147439_a(x, y, z).canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)heldStack.func_77973_b()) && world.func_147437_c(x, y + 1, z)) {
                    if (oldBlock instanceof BlockFarmland) {
                        world.func_72908_a((double)x + 0.5, (double)((float)y + 1.0f), (double)z + 0.5, ModSounds.soundCrops.func_150496_b(), ModSounds.soundCrops.func_150497_c(), ModSounds.soundCrops.func_150494_d());
                        return;
                    }
                    if (oldBlock instanceof BlockSoulSand) {
                        world.func_72908_a((double)x + 0.5, (double)((float)y + 1.0f), (double)z + 0.5, ModSounds.soundCropWarts.func_150496_b(), ModSounds.soundCropWarts.func_150497_c(), ModSounds.soundCropWarts.func_150494_d());
                        return;
                    }
                }
                if (ConfigBlocksItems.enableLavaCauldrons && heldStack != null && heldStack.func_77973_b() == Items.field_151129_at && oldBlock == Blocks.field_150383_bp && ServerEventHandler.canUse(player, world, x, y, z) && meta == 0) {
                    event.setResult(Event.Result.DENY);
                    player.func_71038_i();
                    world.func_147449_b(x, y, z, ModBlocks.lava_cauldron);
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (heldStack.field_77994_a <= 1) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151133_ar));
                        } else {
                            --heldStack.field_77994_a;
                        }
                    }
                }
                if (ConfigBlocksItems.enableInvertedDaylightSensor && oldBlock == Blocks.field_150453_bW && ServerEventHandler.canUse(player, world, x, y, z)) {
                    player.func_71038_i();
                    world.func_147465_d(x, y, z, ModBlocks.inverted_daylight_detector, 15 - meta, 2);
                    if (!world.field_72995_K) {
                        event.setResult(Event.Result.DENY);
                        event.setCanceled(true);
                    }
                }
                if (heldStack != null && (toolClasses = heldStack.func_77973_b().getToolClasses(heldStack)) != null) {
                    BlockAndMetadataMapping newBlock;
                    if (ConfigBlocksItems.enableGrassPath && toolClasses.contains("shovel") && !world.func_147439_a(x, y + 1, z).func_149688_o().func_76220_a() && (oldBlock == Blocks.field_150349_c || oldBlock == Blocks.field_150346_d || oldBlock == Blocks.field_150391_bh)) {
                        player.func_71038_i();
                        if (!world.field_72995_K) {
                            world.func_147449_b(x, y, z, ModBlocks.grass_path);
                            heldStack.func_77972_a(1, (EntityLivingBase)player);
                            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "minecraft_1.18:item.shovel.flatten", 1.0f, 1.0f);
                        }
                    } else if (ConfigBlocksItems.enableStrippedLogs && toolClasses.contains("axe") && (newBlock = StrippedLogRegistry.getLog(oldBlock, world.func_72805_g(x, y, z) % 4)) != null) {
                        player.func_71038_i();
                        if (!world.field_72995_K) {
                            world.func_147465_d(x, y, z, newBlock.getBlock(), newBlock.getMeta() + meta / 4 * 4, 2);
                            heldStack.func_77972_a(1, (EntityLivingBase)player);
                            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "minecraft_1.18:item.axe.strip", 1.0f, 0.8f);
                        }
                    }
                }
            }
        }
    }

    public static boolean canUse(EntityPlayer player, World world, int x, int y, int z) {
        return !player.func_70093_af() || player.func_70694_bm() == null || player.func_70694_bm().func_77973_b().doesSneakBypassUse(world, x, y, z, player);
    }

    @SubscribeEvent
    public void onHoeUseEvent(UseHoeEvent event) {
        int z;
        int y;
        int x;
        World world;
        if (ConfigBlocksItems.enableCoarseDirt && (world = event.world).func_147439_a(x = event.x, y = event.y, z = event.z) == ModBlocks.coarse_dirt) {
            world.func_147449_b(x, y, z, Blocks.field_150346_d);
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), Block.field_149767_g.func_150498_e(), 1.0f, 0.8f);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void dropEvent(LivingDropsEvent event) {
        if (event.entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        if (ConfigFunctions.enableSkullDrop) {
            this.dropHead(event.entityLiving, event.source, event.lootingLevel, event.drops);
        }
        Random rand = event.entityLiving.field_70170_p.field_73012_v;
        if (ConfigBlocksItems.enableMutton && event.entityLiving instanceof EntitySheep) {
            int amount = rand.nextInt(3) + 1 + rand.nextInt(1 + event.lootingLevel);
            for (int i = 0; i < amount; ++i) {
                if (event.entityLiving.func_70027_ad()) {
                    this.addDrop(new ItemStack(ModItems.cooked_mutton), event.entityLiving, event.drops);
                    continue;
                }
                this.addDrop(new ItemStack(ModItems.raw_mutton), event.entityLiving, event.drops);
            }
        }
        if (ConfigBlocksItems.enableWitherRose && event.entity instanceof EntityLivingBase && event.source.func_76346_g() instanceof EntityWither) {
            World world = event.entity.field_70170_p;
            Entity entity = event.entity;
            if (world.func_82736_K().func_82766_b("mobGriefing") && ((BlockWitherRose)ModBlocks.wither_rose).func_149742_c(world, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) {
                world.func_147449_b((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, ModBlocks.wither_rose);
            } else {
                this.addDrop(new ItemStack(ModBlocks.wither_rose, 1, 0), event.entityLiving, event.drops);
            }
        }
    }

    private void dropHead(EntityLivingBase entity, DamageSource source, int looting, List<EntityItem> drops) {
        int meta;
        if (this.isPoweredCreeper(source) && (meta = this.getHeadMetadata(entity)) >= 0) {
            this.addDrop(new ItemStack(Items.field_151144_bL, 1, meta), entity, drops);
        }
    }

    private void addDrop(ItemStack stack, EntityLivingBase entity, List<EntityItem> list) {
        if (stack.field_77994_a <= 0) {
            return;
        }
        EntityItem entityItem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
        entityItem.field_145804_b = 10;
        list.add(entityItem);
    }

    private boolean isPoweredCreeper(DamageSource source) {
        Entity entity;
        if (source.func_94541_c() && source instanceof EntityDamageSource && (entity = ((EntityDamageSource)source).func_76346_g()) != null && entity instanceof EntityCreeper) {
            return ((EntityCreeper)entity).func_70830_n();
        }
        return false;
    }

    private int getHeadMetadata(EntityLivingBase entity) {
        if (entity.getClass() == EntityZombie.class) {
            return 2;
        }
        if (entity.getClass() == EntitySkeleton.class && ((EntitySkeleton)entity).func_82202_m() == 0) {
            return 0;
        }
        if (entity.getClass() == EntityCreeper.class) {
            return 4;
        }
        return -1;
    }

    @SubscribeEvent
    public void teleportEvent(EnderTeleportEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity instanceof EntityPlayerMP) {
            ForgeDirection[] horizontal;
            if (ConfigEntities.enableEndermite && entity.func_70681_au().nextFloat() < 0.05f && entity.field_70170_p.func_82736_K().func_82766_b("doMobSpawning")) {
                EntityEndermite entityendermite = new EntityEndermite(entity.field_70170_p);
                entityendermite.func_70012_b(event.targetX, event.targetY, event.targetZ, entity.field_70177_z, entity.field_70125_A);
                entity.field_70170_p.func_72838_d((Entity)entityendermite);
                entityendermite.setSpawnedByPlayer(true);
                entityendermite.aggroEndermen(64);
            }
            for (ForgeDirection enumfacing : horizontal = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}) {
                TileEntity tile = event.entity.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)(event.targetX + (double)enumfacing.offsetX)), MathHelper.func_76128_c((double)event.targetY), MathHelper.func_76128_c((double)(event.targetZ + (double)enumfacing.offsetZ)));
                if (event.entity.field_70170_p.field_72995_K || !(tile instanceof TileEntityGateway) || ((TileEntityGateway)tile).isCoolingDown()) continue;
                ((TileEntityGateway)tile).teleportEntity(event.entity);
                tile.func_70296_d();
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void naturalSpawnEvent(LivingSpawnEvent.SpecialSpawn event) {
        if (event.entityLiving instanceof EntityShulker) {
            EntityShulker shulker = (EntityShulker)event.entityLiving;
            shulker.field_82179_bU = false;
            if (ConfigTweaks.spawnAnywhereShulkerColors) {
                int x = MathHelper.func_76128_c((double)event.x);
                int y = MathHelper.func_76128_c((double)event.y);
                int z = MathHelper.func_76128_c((double)event.z);
                World world = event.world;
                for (EnumFacing facing : EnumFacing.values()) {
                    Block block = world.func_147439_a(x + facing.func_82601_c(), y + facing.func_96559_d(), z + facing.func_82599_e());
                    byte color = -1;
                    int meta = world.func_72805_g(x + facing.func_82601_c(), y + facing.func_96559_d(), z + facing.func_82599_e());
                    if (facing == EnumFacing.DOWN && block == ExternalContent.hee_end_stone) {
                        color = (byte)(meta == 2 ? 10 : (meta == 1 ? 1 : 14));
                    } else if (block == ExternalContent.enderlicious_sand) {
                        color = (byte)(meta == 1 ? 15 : 0);
                    } else if (block == ExternalContent.enderlicious_end_rock) {
                        color = (byte)(meta % 4 == 1 ? 13 : -1);
                    }
                    if (color <= -1) continue;
                    shulker.setColor(color);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void spawnEvent(EntityJoinWorldEvent event) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (!(event.entity instanceof EntityPig)) break block4;
                        EntityPig pig = (EntityPig)event.entity;
                        if (!ConfigBlocksItems.enableBeetroot) break block5;
                        pig.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)pig, 1.2, ModItems.beetroot, false));
                        break block5;
                    }
                    if (!(event.entity instanceof EntityChicken)) break block6;
                    EntityChicken chicken = (EntityChicken)event.entity;
                    if (!ConfigBlocksItems.enableBeetroot) break block5;
                    chicken.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)chicken, 1.0, ModItems.beetroot_seeds, false));
                    break block5;
                }
                if (!(event.entity instanceof EntityWolf)) break block7;
                EntityWolf wolf = (EntityWolf)event.entity;
                if (!ConfigEntities.enableRabbit) break block5;
                wolf.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)wolf, EntityRabbit.class, 200, false));
                break block5;
            }
            if (event.entity instanceof EntityEnderman) {
                EntityEnderman enderman = (EntityEnderman)event.entity;
                enderman.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)enderman, EntityEndermite.class, 100, false));
            } else if (event.entity instanceof EntityVillager) {
                EntityVillager villager = (EntityVillager)event.entity;
                for (Object obj : villager.field_70714_bg.field_75782_a) {
                    EntityAITasks.EntityAITaskEntry entry = (EntityAITasks.EntityAITaskEntry)obj;
                    if (!(entry.field_75733_a instanceof EntityAIOpenDoor)) continue;
                    villager.field_70714_bg.func_85156_a(entry.field_75733_a);
                    villager.field_70714_bg.func_75776_a(entry.field_75731_b, (EntityAIBase)new EntityAIOpenCustomDoor((EntityLiving)villager, true));
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void interactEntityEvent(EntityInteractEvent event) {
        ItemStack stack = event.entityPlayer.func_71045_bC();
        if (stack == null) {
            return;
        }
        if (!(event.target instanceof EntityAnimal)) {
            return;
        }
        EntityAnimal animal = (EntityAnimal)event.target;
        if (!animal.func_70631_g_()) {
            if (animal instanceof EntityPig) {
                if (stack.func_77973_b() == ModItems.beetroot && ConfigBlocksItems.enableBeetroot) {
                    this.setAnimalInLove(animal, event.entityPlayer, stack);
                }
            } else if (animal instanceof EntityChicken && stack.func_77973_b() == ModItems.beetroot_seeds && ConfigBlocksItems.enableBeetroot) {
                this.setAnimalInLove(animal, event.entityPlayer, stack);
            }
        } else if (ConfigEntities.enableBabyGrowthBoost && this.isFoodItem(animal, stack)) {
            this.feedBaby(animal, event.entityPlayer, stack);
        }
        if (animal instanceof EntitySheep && stack.func_77973_b() != Items.field_151100_aR && !animal.field_70170_p.field_72995_K) {
            EntitySheep sheep = (EntitySheep)animal;
            for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
                int fleeceColour = ~ArrayUtils.indexOf((Object[])ModRecipes.ore_dyes, (Object)OreDictionary.getOreName((int)oreID)) & 0xF;
                if (!ArrayUtils.contains((Object[])ModRecipes.ore_dyes, (Object)OreDictionary.getOreName((int)oreID)) || sheep.func_70896_n() == fleeceColour || sheep.func_70892_o()) continue;
                sheep.func_70891_b(fleeceColour);
                if (event.entityPlayer.field_71075_bZ.field_75098_d) break;
                --stack.field_77994_a;
                break;
            }
        }
    }

    private void setAnimalInLove(EntityAnimal animal, EntityPlayer player, ItemStack stack) {
        if (!animal.func_70880_s()) {
            animal.func_146082_f(player);
            if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
        }
    }

    private void feedBaby(EntityAnimal animal, EntityPlayer player, ItemStack stack) {
        int currentAge = animal.func_70874_b();
        int age = (int)((float)(-currentAge) * 0.1f);
        animal.func_70873_a(currentAge + age);
        player.func_71038_i();
        Random itemRand = animal.field_70170_p.field_73012_v;
        for (int i = 0; i < 3; ++i) {
            double d0 = itemRand.nextGaussian() * 0.02;
            double d1 = itemRand.nextGaussian() * 0.02;
            double d2 = itemRand.nextGaussian() * 0.02;
            animal.field_70170_p.func_72869_a("happyVillager", animal.field_70165_t + (double)itemRand.nextFloat() * 0.5, animal.field_70163_u + 0.5 + (double)itemRand.nextFloat() * 0.5, animal.field_70161_v + (double)itemRand.nextFloat() * 0.5, d0, d1, d2);
        }
        if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a <= 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
        }
    }

    private boolean isFoodItem(EntityAnimal animal, ItemStack food) {
        if (animal.func_70877_b(food)) {
            return true;
        }
        if (animal instanceof EntityPig && food.func_77973_b() == ModItems.beetroot && ConfigBlocksItems.enableBeetroot) {
            return true;
        }
        return animal instanceof EntityChicken && food.func_77973_b() == ModItems.beetroot_seeds && ConfigBlocksItems.enableBeetroot;
    }

    @SubscribeEvent
    public void entityHurtEvent(LivingHurtEvent event) {
        EntityDamageSource src;
        Entity attacker;
        if (!ConfigWorld.enableDmgIndicator) {
            return;
        }
        int amount = MathHelper.func_76141_d((float)(Math.min(event.entityLiving.func_110143_aJ(), event.ammount) / 2.0f));
        amount = (int)this.applyArmorCalculations(event.entityLiving, event.source, amount);
        if ((amount = (int)this.applyPotionDamageCalculations(event.entityLiving, event.source, amount)) <= 0) {
            return;
        }
        if (event.source instanceof EntityDamageSource && (attacker = (src = (EntityDamageSource)event.source).func_76364_f()) instanceof EntityPlayer && !(attacker instanceof FakePlayer)) {
            Random random = event.entity.field_70170_p.field_73012_v;
            EntityPlayer player = (EntityPlayer)attacker;
            Vec3 look = player.func_70040_Z();
            look.func_72442_b(1.5707964f);
            for (int i = 0; i < amount; ++i) {
                double x = event.entityLiving.field_70165_t - 0.35 * look.field_72450_a / 2.0 * look.field_72450_a + (double)(i / 3);
                double y = event.entityLiving.field_70163_u + (double)event.entityLiving.field_70131_O * 0.75;
                double z = event.entityLiving.field_70161_v - 0.35 * look.field_72449_c / 2.0 * look.field_72449_c + (double)(i / 3);
                EtFuturum.networkWrapper.sendToAllAround((IMessage)new BlackHeartParticlesMessage(x, y, z), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.field_76574_g, x, y, z, 64.0));
            }
        }
    }

    private float applyArmorCalculations(EntityLivingBase entity, DamageSource p_70655_1_, float p_70655_2_) {
        if (!p_70655_1_.func_76363_c()) {
            int i = 25 - entity.func_70658_aO();
            float f1 = p_70655_2_ * (float)i;
            p_70655_2_ = f1 / 25.0f;
        }
        return p_70655_2_;
    }

    private float applyPotionDamageCalculations(EntityLivingBase entity, DamageSource p_70672_1_, float p_70672_2_) {
        float f1;
        int j;
        int i;
        if (p_70672_1_.func_151517_h()) {
            return p_70672_2_;
        }
        if (entity instanceof EntityZombie) {
            // empty if block
        }
        if (entity.func_70644_a(Potion.field_76429_m) && p_70672_1_ != DamageSource.field_76380_i) {
            i = (entity.func_70660_b(Potion.field_76429_m).func_76458_c() + 1) * 5;
            j = 25 - i;
            f1 = p_70672_2_ * (float)j;
            p_70672_2_ = f1 / 25.0f;
        }
        if (p_70672_2_ <= 0.0f) {
            return 0.0f;
        }
        i = EnchantmentHelper.func_77508_a((ItemStack[])entity.func_70035_c(), (DamageSource)p_70672_1_);
        if (i > 20) {
            i = 20;
        }
        if (i > 0 && i <= 20) {
            j = 25 - i;
            f1 = p_70672_2_ * (float)j;
            p_70672_2_ = f1 / 25.0f;
        }
        return p_70672_2_;
    }

    @SubscribeEvent
    public void entityStruckByLightning(EntityStruckByLightningEvent event) {
        if (ConfigEntities.enableVillagerTurnsIntoWitch && event.entity instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)event.entity;
            if (!villager.field_70170_p.field_72995_K) {
                EntityWitch witch = new EntityWitch(villager.field_70170_p);
                witch.func_82149_j((Entity)villager);
                witch.func_110161_a(null);
                villager.field_70170_p.func_72838_d((Entity)witch);
                villager.func_70106_y();
            }
        } else if (ConfigEntities.enableBrownMooshroom && event.entity.field_70173_aa > 40 && event.entity.getClass() == EntityMooshroom.class) {
            EntityMooshroom mooshroom = (EntityMooshroom)event.entity;
            if (!mooshroom.field_70170_p.field_72995_K) {
                EntityBrownMooshroom brownmooshroom = new EntityBrownMooshroom(mooshroom.field_70170_p);
                brownmooshroom.func_82149_j((Entity)mooshroom);
                brownmooshroom.func_110161_a(null);
                mooshroom.field_70170_p.func_72838_d((Entity)brownmooshroom);
                mooshroom.func_70106_y();
                brownmooshroom.func_70097_a(DamageSource.field_76370_b, 0.0f);
            }
        } else if (ConfigEntities.enableBrownMooshroom && event.entity.field_70173_aa > 40 && event.entity.getClass() == EntityBrownMooshroom.class) {
            EntityBrownMooshroom brownmooshroom = (EntityBrownMooshroom)event.entity;
            if (!brownmooshroom.field_70170_p.field_72995_K) {
                EntityMooshroom mooshroom = new EntityMooshroom(brownmooshroom.field_70170_p);
                mooshroom.func_82149_j((Entity)brownmooshroom);
                mooshroom.func_110161_a(null);
                brownmooshroom.field_70170_p.func_72838_d((Entity)mooshroom);
                brownmooshroom.func_70106_y();
                mooshroom.func_70097_a(DamageSource.field_76370_b, 0.0f);
            }
        }
    }

    @SubscribeEvent
    public void livingHurtEvent(LivingHurtEvent event) {
        Entity entity = event.entity;
        if (ConfigFunctions.enableHayBaleFalls && entity != null && entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)(entity.field_70163_u - (double)0.2f - (double)entity.field_70129_M)), MathHelper.func_76128_c((double)entity.field_70161_v)) == Blocks.field_150407_cf && event.source == DamageSource.field_76379_h) {
            event.ammount *= (float)ConfigFunctions.hayBaleReducePercent / 100.0f;
        }
        if (entity == null || !(entity instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase livingEntity = (EntityLivingBase)entity;
        if (ConfigBlocksItems.enableTotemUndying) {
            this.handleTotemCheck(livingEntity, event);
        }
    }

    public void handleTotemCheck(EntityLivingBase entity, LivingHurtEvent event) {
        if (entity.func_110143_aJ() > (float)Math.round(event.ammount)) {
            return;
        }
        if (entity.func_70694_bm() == null || entity.func_70694_bm().func_77973_b() != ModItems.totem) {
            return;
        }
        if (entity instanceof EntityLiving || entity instanceof EntityPlayer) {
            entity.field_70170_p.func_72908_a(entity.field_70165_t + 0.5, entity.field_70163_u + 0.5, entity.field_70161_v + 0.5, "minecraft_1.18:item.totem.use", 1.0f, entity.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            entity.func_70674_bp();
            float healpercent = (float)ConfigFunctions.totemHealPercent / 100.0f;
            float sethp = entity.func_110138_aP() * healpercent;
            entity.func_70606_j(sethp < 0.5f ? 0.5f : sethp);
            event.ammount = 0.0f;
            entity.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 900, 1));
            entity.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 800, 1));
            entity.func_70690_d(new PotionEffect(Potion.field_76444_x.field_76415_H, 100, 1));
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_70062_b(0, (ItemStack)null);
            }
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"util.totemBreak")));
                ((EntityPlayer)entity).func_71028_bD();
            }
        }
    }

    @SubscribeEvent
    public void onDrops(BlockEvent.HarvestDropsEvent event) {
        if (ConfigBlocksItems.enableSmoothStone && event.block == Blocks.field_150334_T && event.blockMetadata == 8) {
            event.drops.clear();
            event.drops.add(new ItemStack(ModBlocks.smooth_stone, 1));
        }
    }

    @SubscribeEvent
    public void loadWorldEvent(WorldEvent.Load event) {
        event.world.func_72954_a((IWorldAccess)new EtFuturumWorldListener(event.world));
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        if (ConfigMixins.avoidDroppingItemsWhenClosing && event.player instanceof EntityPlayerMP && playersClosedContainers.contains(event.player) && event.player.field_71071_by.func_70441_a(event.entityItem.func_92059_d())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            playersClosedContainers.clear();
        }
    }
}

