/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.configuration.configs;

import ganymedes01.etfuturum.configuration.ConfigBase;
import java.io.File;
import net.minecraft.launchwrapper.Launch;

public class ConfigEntities
extends ConfigBase {
    public static boolean enableStray;
    public static boolean enableEndermite;
    public static boolean enableVillagerZombies;
    public static boolean enableVillagerTurnsIntoWitch;
    public static boolean enableHusk;
    public static boolean enableShulker;
    public static boolean enableBrownMooshroom;
    public static boolean enableBabyGrowthBoost;
    public static boolean enableRabbit;
    public static boolean enableDragonRespawn;
    public static boolean enableNetherEndermen;
    public static boolean enableShearableSnowGolems;
    public static float flySprintSpeed;
    static final String catHostile = "hostile";
    static final String catNeutral = "neutral";
    static final String catPassive = "passive";
    static final String catPlayer = "player";
    static final String catMisc = "misc";
    public static final String PATH;
    public static final ConfigEntities configInstance;

    public ConfigEntities(File file) {
        super(file);
        this.setCategoryComment(catHostile, "Hostile entities.");
        this.setCategoryComment(catNeutral, "Neutral entities.");
        this.setCategoryComment(catPassive, "Passive entities.");
        this.setCategoryComment(catPlayer, "These settings affect the player directly.");
        this.setCategoryComment(catMisc, "Entity settings that don't fit into any other category, typically entity settings.");
        this.configCats.add(this.getCategory(catHostile));
        this.configCats.add(this.getCategory(catNeutral));
        this.configCats.add(this.getCategory(catPassive));
        this.configCats.add(this.getCategory(catMisc));
        this.configCats.add(this.getCategory(catPlayer));
    }

    @Override
    protected void syncConfigOptions() {
        ConfigEntities cfg = configInstance;
        enableRabbit = cfg.getBoolean("enableRabbits", catPassive, true, "");
        enableBrownMooshroom = cfg.getBoolean("enableBrownMooshroom", catPassive, true, "Brown mooshroom variant.");
        enableEndermite = cfg.getBoolean("enableEndermite", catHostile, true, "Rarely spawns when the player lands from Ender Pearl throws");
        enableHusk = cfg.getBoolean("enableHusks", catHostile, true, "Desert zombie variant");
        enableStray = cfg.getBoolean("enableStrays", catHostile, true, "Tundra skeleton variant");
        enableShulker = cfg.getBoolean("enableShulker", catHostile, true, "Shell-lurking mobs from the End.");
        enableVillagerZombies = cfg.getBoolean("enableZombieVillager", catHostile, true, "");
        flySprintSpeed = cfg.getFloat("flySprintSpeed", catPlayer, 0.125f, 0.05f, 0.2f, "Speed boost while sprinting and flying. 0.05 is no extra speed.");
        enableShearableSnowGolems = cfg.getBoolean("enableShearableSnowGolems", catMisc, true, "");
        enableBabyGrowthBoost = cfg.getBoolean("enableBabyGrowthBoost", catMisc, true, "");
        enableVillagerTurnsIntoWitch = cfg.getBoolean("enableVillagerTurnsIntoWitch", catMisc, true, "Villagers turn into Witches when struck by lightning");
        enableDragonRespawn = cfg.getBoolean("enableDragonRespawn", catMisc, true, "Crude implementation of respawning the dragon using four End crystals.");
        enableNetherEndermen = cfg.getBoolean("enableNetherEndermen", catMisc, true, "Allow endermen to rarely spawn in the Nether");
    }

    static {
        PATH = configDir + File.separator + "entities.cfg";
        configInstance = new ConfigEntities(new File(Launch.minecraftHome, PATH));
    }
}

