/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.configuration;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.etfuturum.EtFuturumMixinPlugin;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.ExternalContent;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.spongepowered.asm.mixin.MixinEnvironment;

public abstract class ConfigBase
extends Configuration {
    private static final String catClientLegacy = "client";
    private static final String catBlockLegacy = "blocks";
    private static final String catItemsLegacy = "items";
    private static final String catEquipmentLegacy = "equipment";
    private static final String catEnchantsLegacy = "enchants";
    private static final String catEntityLegacy = "entity";
    private static final String catReplacementLegacy = "replacement";
    private static final String catFunctionLegacy = "function";
    private static final String catWorldLegacy = "world";
    protected final List<ConfigCategory> configCats = new ArrayList<ConfigCategory>();
    protected static String configDir = "config" + File.separator + "etfuturum";
    public static final String PATH = configDir + File.separator + "etfuturum.cfg";

    public List<ConfigCategory> getConfigCats() {
        return this.configCats;
    }

    public ConfigBase(File file) {
        super(file);
    }

    public void syncConfig() {
        this.syncConfigOptions();
        for (ConfigCategory cat : this.configCats) {
            if (EtFuturumMixinPlugin.side == MixinEnvironment.Side.SERVER && cat.getName().contains(catClientLegacy)) {
                for (Property prop : cat.getOrderedValues()) {
                    cat.remove((Object)prop.getName());
                }
            }
            if (!cat.isEmpty()) continue;
            this.removeCategory(cat);
        }
        if (this.hasChanged()) {
            this.save();
        }
    }

    protected abstract void syncConfigOptions();

    public static void postInit() {
        ConfigFunctions.shulkerBans = new ArrayList<Item>();
        for (String itemName : ConfigFunctions.shulkerBansString) {
            String[] nameAndID;
            if (itemName.contains(":") && (nameAndID = itemName.split(":")).length == 2) {
                Item item = GameRegistry.findItem((String)nameAndID[0], (String)nameAndID[1]);
                if (item == null) continue;
                if (!ConfigFunctions.shulkerBans.contains(item)) {
                    ConfigFunctions.shulkerBans.add(item);
                    continue;
                }
                System.err.println("Shulker ban list entry \"" + itemName + "\" is already added!");
                continue;
            }
            System.err.println("Shulker ban list entry \"" + itemName + "\" is formatted incorrectly!");
        }
        Block block = ConfigWorld.fossilBlockID == 1 ? ExternalContent.netherlicious_bone_block : ExternalContent.utd_bone_block;
        ConfigWorld.fossilBoneBlock = ConfigWorld.fossilBlockID == 0 || block == null ? ModBlocks.bone_block : block;
        block = ConfigWorld.amethystOuterID == 1 && ConfigBlocksItems.enableTuff ? ModBlocks.tuff : ExternalContent.netherlicious_basalt_bricks;
        ConfigWorld.amethystOuterBlock = ConfigWorld.amethystOuterID == 0 || block == null ? ModBlocks.smooth_basalt : block;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if ("etfuturum".equals(eventArgs.modID)) {
            this.syncConfig();
        }
    }
}

