/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.IConfigurable;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.items.block.ItemShulkerBox;
import ganymedes01.etfuturum.tileentities.TileEntityShulkerBox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockShulkerBox
extends BlockContainer
implements IConfigurable,
ModBlocks.ISubBlocksBlock {
    public IIcon[] colorIcons = new IIcon[17];

    public BlockShulkerBox() {
        super(Material.field_151576_e);
        this.func_149672_a(field_149769_e);
        this.func_149711_c(2.5f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149752_b(2.5f);
        this.func_149663_c(Utils.getUnlocalisedName("shulker_box"));
        this.func_149658_d("shulker_box");
        this.field_149758_A = true;
        this.func_149647_a((CreativeTabs)(this.isEnabled() ? EtFuturum.creativeTabBlocks : null));
    }

    public int func_149692_a(int i) {
        return ConfigBlocksItems.enableIronShulkerBoxes ? i % (TileEntityShulkerBox.tiers.length + 1) : 0;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        if (world.func_72805_g(x, y, z) >= 7) {
            return 10000.0f;
        }
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public int func_149656_h() {
        return 1;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntityShulkerBox box = (TileEntityShulkerBox)world.func_147438_o(x, y, z);
        if (stack.func_77942_o()) {
            NBTTagList nbttaglist = stack.func_77978_p().func_150295_c("Items", 10);
            box.chestContents = new ItemStack[box.func_70302_i_()];
            Utils.loadItemStacksFromNBT(nbttaglist, box.chestContents);
            box.color = stack.func_77978_p().func_74764_b("Color") ? stack.func_77978_p().func_74771_c("Color") : (byte)0;
            if (stack.func_82837_s()) {
                box.func_145976_a(stack.func_82833_r());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister i) {
        this.field_149761_L = this.colorIcons[0] = i.func_94245_a("shulker_box");
        this.colorIcons[1] = i.func_94245_a("white_shulker_box");
        this.colorIcons[2] = i.func_94245_a("orange_shulker_box");
        this.colorIcons[3] = i.func_94245_a("magenta_shulker_box");
        this.colorIcons[4] = i.func_94245_a("light_blue_shulker_box");
        this.colorIcons[5] = i.func_94245_a("yellow_shulker_box");
        this.colorIcons[6] = i.func_94245_a("lime_shulker_box");
        this.colorIcons[7] = i.func_94245_a("pink_shulker_box");
        this.colorIcons[8] = i.func_94245_a("gray_shulker_box");
        this.colorIcons[9] = i.func_94245_a("light_gray_shulker_box");
        this.colorIcons[10] = i.func_94245_a("cyan_shulker_box");
        this.colorIcons[11] = i.func_94245_a("purple_shulker_box");
        this.colorIcons[12] = i.func_94245_a("blue_shulker_box");
        this.colorIcons[13] = i.func_94245_a("brown_shulker_box");
        this.colorIcons[14] = i.func_94245_a("green_shulker_box");
        this.colorIcons[15] = i.func_94245_a("red_shulker_box");
        this.colorIcons[16] = i.func_94245_a("black_shulker_box");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        return world.func_147438_o(x, y, z) instanceof TileEntityShulkerBox ? Blocks.field_150426_aN.func_149691_a(0, 0) : Blocks.field_150451_bX.func_149691_a(0, 0);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileentity = world.func_147438_o(x, y, z);
        if (tileentity instanceof TileEntityShulkerBox) {
            boolean flag;
            ForgeDirection dir = ForgeDirection.getOrientation((int)((TileEntityShulkerBox)tileentity).facing);
            if (((TileEntityShulkerBox)tileentity).func_190591_p() == TileEntityShulkerBox.AnimationStatus.CLOSED) {
                AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72321_a((double)(0.5f * (float)dir.offsetX), (double)(0.5f * (float)dir.offsetY), (double)(0.5f * (float)dir.offsetZ));
                axisalignedbb.func_72321_a(-((double)dir.offsetX), -((double)dir.offsetY), -((double)dir.offsetZ));
                flag = this.canOpen(axisalignedbb, world, tileentity);
            } else {
                flag = true;
            }
            if (flag) {
                player.openGui((Object)EtFuturum.instance, 6, world, x, y, z);
            }
            return true;
        }
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        TileEntity tileentity = world.func_147438_o(x, y, z);
        return tileentity instanceof TileEntityShulkerBox ? ((TileEntityShulkerBox)tileentity).func_190584_a(((TileEntityShulkerBox)tileentity).facing).func_72317_d((double)x, (double)y, (double)z) : super.func_149668_a(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World p_149633_1_, int p_149633_2_, int p_149633_3_, int p_149633_4_) {
        return this.func_149668_a(p_149633_1_, p_149633_2_, p_149633_3_, p_149633_4_);
    }

    private boolean canOpen(AxisAlignedBB bb, World world, TileEntity tile) {
        ArrayList boxes = new ArrayList();
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(bb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(bb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(bb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = i1; l1 < j1; ++l1) {
                for (int i2 = k - 1; i2 < l; ++i2) {
                    if (k1 == tile.field_145851_c && i2 == tile.field_145848_d && l1 == tile.field_145849_e) continue;
                    Block block = k1 >= -30000000 && k1 < 30000000 && l1 >= -30000000 && l1 < 30000000 ? world.func_147439_a(k1, i2, l1) : Blocks.field_150348_b;
                    block.func_149743_a(world, k1, i2, l1, bb, boxes, null);
                }
            }
        }
        return boxes.isEmpty();
    }

    public IInventory func_149951_m(World p_149951_1_, int p_149951_2_, int p_149951_3_, int p_149951_4_) {
        TileEntity object = p_149951_1_.func_147438_o(p_149951_2_, p_149951_3_, p_149951_4_);
        if (object == null) {
            return null;
        }
        return (IInventory)object;
    }

    public void func_149690_a(World world, int x, int y, int z, int p_149690_5_, float p_149690_6_, int p_149690_7_) {
        super.func_149690_a(world, x, y, z, p_149690_5_, p_149690_6_, p_149690_7_);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!((TileEntityShulkerBox)world.func_147438_o(x, y, z)).onBlockBreak(player)) {
            return false;
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        TileEntityShulkerBox container = (TileEntityShulkerBox)world.func_147438_o(x, y, z);
        if (container != null) {
            container.onBlockDestroyed();
        }
    }

    protected void func_149642_a(World p_149642_1_, int p_149642_2_, int p_149642_3_, int p_149642_4_, ItemStack p_149642_5_) {
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public int func_149645_b() {
        return 22;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityShulkerBox(p_149915_2_);
    }

    @Override
    public Class<? extends ItemBlock> getItemBlockClass() {
        return ItemShulkerBox.class;
    }

    public IIcon func_149691_a(int side, int metadata) {
        return BlockRedstoneWire.func_150173_e((String)"cross_overlay");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int metadata, EffectRenderer effectRenderer) {
        TileEntityShulkerBox TE = (TileEntityShulkerBox)world.func_147438_o(x, y, z);
        if (TE != null) {
            int b0 = 4;
            for (int i1 = 0; i1 < b0; ++i1) {
                for (int j1 = 0; j1 < b0; ++j1) {
                    for (int k1 = 0; k1 < b0; ++k1) {
                        double d0 = (double)x + ((double)i1 + 0.5) / (double)b0;
                        double d1 = (double)y + ((double)j1 + 0.5) / (double)b0;
                        double d2 = (double)z + ((double)k1 + 0.5) / (double)b0;
                        EntityDiggingFX dig = new EntityDiggingFX(world, d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, (Block)this, 0);
                        dig.func_110125_a(this.colorIcons[TE.color]);
                        effectRenderer.func_78873_a((EntityFX)dig.func_70596_a(x, y, z));
                    }
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        int x = target.field_72311_b;
        int y = target.field_72312_c;
        int z = target.field_72309_d;
        int side = target.field_72310_e;
        Block block = world.func_147439_a(x, y, z);
        TileEntityShulkerBox TE = (TileEntityShulkerBox)world.func_147438_o(x, y, z);
        if (block.func_149688_o() != Material.field_151579_a && TE != null) {
            float f = 0.1f;
            double d0 = (double)x + world.field_73012_v.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(f * 2.0f)) + (double)f + block.func_149704_x();
            double d1 = (double)y + world.field_73012_v.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(f * 2.0f)) + (double)f + block.func_149665_z();
            double d2 = (double)z + world.field_73012_v.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(f * 2.0f)) + (double)f + block.func_149706_B();
            if (side == 0) {
                d1 = (double)y + block.func_149665_z() - (double)f;
            }
            if (side == 1) {
                d1 = (double)y + block.func_149669_A() + (double)f;
            }
            if (side == 2) {
                d2 = (double)z + block.func_149706_B() - (double)f;
            }
            if (side == 3) {
                d2 = (double)z + block.func_149693_C() + (double)f;
            }
            if (side == 4) {
                d0 = (double)x + block.func_149704_x() - (double)f;
            }
            if (side == 5) {
                d0 = (double)x + block.func_149753_y() + (double)f;
            }
            EntityDiggingFX dig = new EntityDiggingFX(world, d0, d1, d2, 0.0, 0.0, 0.0, (Block)this, 0);
            dig.func_110125_a(this.colorIcons[TE.color]);
            effectRenderer.func_78873_a(dig.func_70596_a(x, y, z).func_70543_e(0.2f).func_70541_f(0.6f));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List subItems) {
        for (int i = 0; i <= (ConfigBlocksItems.enableIronShulkerBoxes ? 7 : 0); i = (int)((byte)(i + 1))) {
            for (byte j = 0; j <= (ConfigBlocksItems.enableDyedShulkerBoxes ? (byte)16 : 0); j = (byte)(j + 1)) {
                NBTTagCompound tag = new NBTTagCompound();
                ItemStack stack = new ItemStack(item, 1, i);
                if (j > 0) {
                    tag.func_74774_a("Color", j);
                }
                if (j > 0 || i > 0) {
                    stack.func_77982_d(tag);
                }
                subItems.add(stack);
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        ItemStack stack = new ItemStack((Block)this, 1, this.func_149692_a(world.func_72805_g(x, y, z)));
        TileEntityShulkerBox box = (TileEntityShulkerBox)world.func_147438_o(x, y, z);
        if (box != null && box.color > 0 && ConfigBlocksItems.enableDyedShulkerBoxes) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74774_a("Color", box.color);
        }
        return stack;
    }

    @Override
    public boolean isEnabled() {
        return ConfigBlocksItems.enableShulkerBoxes;
    }
}

