/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.IConfigurable;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.items.block.ItemDecorationWorkbench;
import ganymedes01.etfuturum.lib.RenderIDs;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockComposter
extends Block
implements IConfigurable,
ModBlocks.ISubBlocksBlock {
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon bottomIcon;
    @SideOnly(value=Side.CLIENT)
    public IIcon compostIcon;
    @SideOnly(value=Side.CLIENT)
    public IIcon fullCompostIcon;

    public BlockComposter() {
        super(Material.field_151575_d);
        this.func_149672_a(field_149766_f);
        this.func_149711_c(0.6f);
        this.func_149752_b(0.6f);
        this.setHarvestLevel("axe", 0);
        this.func_149663_c(Utils.getUnlocalisedName("composter"));
        this.func_149658_d("composter");
        this.func_149713_g(500);
        this.func_149647_a((CreativeTabs)(this.isEnabled() ? EtFuturum.creativeTabBlocks : null));
        this.func_149713_g(0);
        this.field_149783_u = true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_) {
        return p_149691_1_ == 1 ? this.topIcon : (p_149691_1_ == 0 ? this.bottomIcon : this.field_149761_L);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.field_149761_L = p_149651_1_.func_94245_a(this.func_149641_N() + "_side");
        this.bottomIcon = p_149651_1_.func_94245_a(this.func_149641_N() + "_bottom");
        this.topIcon = p_149651_1_.func_94245_a(this.func_149641_N() + "_top");
        this.compostIcon = p_149651_1_.func_94245_a(this.func_149641_N() + "_compost");
        this.fullCompostIcon = p_149651_1_.func_94245_a(this.func_149641_N() + "_ready");
    }

    public void func_149743_a(World p_149743_1_, int p_149743_2_, int p_149743_3_, int p_149743_4_, AxisAlignedBB p_149743_5_, List p_149743_6_, Entity p_149743_7_) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        super.func_149743_a(p_149743_1_, p_149743_2_, p_149743_3_, p_149743_4_, p_149743_5_, p_149743_6_, p_149743_7_);
        float f = 0.125f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        super.func_149743_a(p_149743_1_, p_149743_2_, p_149743_3_, p_149743_4_, p_149743_5_, p_149743_6_, p_149743_7_);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        super.func_149743_a(p_149743_1_, p_149743_2_, p_149743_3_, p_149743_4_, p_149743_5_, p_149743_6_, p_149743_7_);
        this.func_149676_a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.func_149743_a(p_149743_1_, p_149743_2_, p_149743_3_, p_149743_4_, p_149743_5_, p_149743_6_, p_149743_7_);
        this.func_149676_a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        super.func_149743_a(p_149743_1_, p_149743_2_, p_149743_3_, p_149743_4_, p_149743_5_, p_149743_6_, p_149743_7_);
        this.func_149683_g();
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < 6) {
            meta = Math.min(meta, 7);
            ItemStack stack = player.func_71045_bC();
            for (String oreName : EtFuturum.getOreStrings(stack)) {
                String chanceKey;
                if (!oreName.startsWith(chanceKey = "compostChance")) continue;
                try {
                    if (!world.field_72995_K) {
                        int chance = Math.min(100, Math.max(1, Integer.valueOf(oreName.substring(chanceKey.length()))));
                        int chance2 = world.field_73012_v.nextInt(100);
                        if (chance2 < chance) {
                            world.func_72921_c(x, y, z, meta + 1, 3);
                            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "minecraft_1.18:block.composter.fill_success", 1.0f, 1.0f);
                            if (meta == 5) {
                                world.func_147464_a(x, y, z, (Block)this, world.field_73012_v.nextInt(10) + 10);
                            }
                        } else {
                            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "minecraft_1.18:block.composter.fill", 1.0f, 1.0f);
                        }
                        if (!player.field_71075_bZ.field_75098_d) {
                            --stack.field_77994_a;
                        }
                    }
                    for (int i = 0; i < 5; ++i) {
                        world.func_72869_a("happyVillager", world.field_73012_v.nextDouble() * 0.875 + 0.125 + (double)x, 0.25 + 0.125 * (double)Math.min(meta, 6) + (double)y, world.field_73012_v.nextDouble() * 0.875 + 0.125 + (double)z, 0.0, 0.0, 0.0);
                    }
                    return true;
                }
                catch (NumberFormatException e) {
                    String itemName = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b());
                    System.out.println("Item " + itemName + " had an incorrectly formatted composter tag! Got " + oreName + " instead.");
                    System.out.println("It should be formatted starting with \"compostChance\" and then a number from 1 to 100. Example: compostChance75 for a 75% composting chance.");
                    e.printStackTrace();
                    return false;
                }
            }
        } else if (meta == 7) {
            if (!world.field_72995_K) {
                EntityItem item = new EntityItem(world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5, new ItemStack(Items.field_151100_aR, 1, 15));
                item.func_70016_h(world.field_73012_v.nextDouble() * 0.5, 0.0, world.field_73012_v.nextDouble() * 0.5);
                world.func_72838_d((Entity)item);
            }
            world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "minecraft_1.18:block.composter.empty", 1.0f, 1.0f, true);
            world.func_72921_c(x, y, z, 0, 3);
            return true;
        }
        return false;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (world.func_72805_g(x, y, z) == 6) {
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "minecraft_1.18:block.composter.ready", 1.0f, 1.0f);
            world.func_72921_c(x, y, z, 7, 3);
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return RenderIDs.COMPOSTER;
    }

    @Override
    public boolean isEnabled() {
        return ConfigBlocksItems.enableComposter;
    }

    @Override
    public Class<? extends ItemBlock> getItemBlockClass() {
        return ItemDecorationWorkbench.class;
    }
}

