/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.blocks.BlockAmethystBlock;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.items.block.ItemAmethystCluster;
import ganymedes01.etfuturum.lib.RenderIDs;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAmethystCluster
extends BlockAmethystBlock
implements ModBlocks.ISubBlocksBlock {
    private final int type;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockAmethystCluster(int type) {
        super(Material.field_151592_s);
        this.func_149711_c(1.5f);
        this.func_149752_b(1.5f);
        this.func_149672_a(ConfigWorld.enableNewBlocksSounds ? ModSounds.soundAmethystCluster : field_149778_k);
        this.func_149658_d("amethyst_cluster");
        this.func_149663_c(Utils.getUnlocalisedName("amethyst_cluster_" + (type + 1)));
        this.func_149647_a((CreativeTabs)(this.isEnabled() ? EtFuturum.creativeTabBlocks : null));
        this.setHarvestLevel("pickaxe", 0);
        this.field_149784_t = 1;
        this.type = type;
    }

    public int func_149656_h() {
        return 1;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.func_149750_m() + this.type * 3 + meta / 6;
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return ModItems.amethyst_shard;
    }

    protected ItemStack func_149644_j(int p_149644_1_) {
        int j = 0;
        Item item = Item.func_150898_a((Block)this);
        if (item != null && item.func_77614_k()) {
            j = p_149644_1_ < 6 ? 0 : 6;
        }
        return new ItemStack(item, 1, j);
    }

    protected boolean func_149700_E() {
        return true;
    }

    public int func_149643_k(World p_149643_1_, int p_149643_2_, int p_149643_3_, int p_149643_4_) {
        return p_149643_1_.func_72805_g(p_149643_2_, p_149643_3_, p_149643_4_) < 6 ? 0 : 6;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        if (this == ModBlocks.amethyst_cluster_2 && meta >= 6) {
            int drop = this.func_149745_a(random);
            if (fortune > 0 && this.harvestingWithPickaxe() && random.nextInt(2 + fortune) == 0) {
                drop += 4 * fortune;
            }
            return drop;
        }
        return 0;
    }

    public int func_149745_a(Random p_149745_1_) {
        if (this.harvestingWithPickaxe()) {
            return 4;
        }
        return 2;
    }

    private boolean harvestingWithPickaxe() {
        return this.harvesters.get() != null && ((EntityPlayer)this.harvesters.get()).func_71045_bC() != null && ((EntityPlayer)this.harvesters.get()).func_71045_bC().func_77973_b().getToolClasses(((EntityPlayer)this.harvesters.get()).func_71045_bC()).contains("pickaxe");
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        return side + meta;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        float xzOffset;
        int meta = world.func_72805_g(x, y, z);
        float height = (meta < 6 ? 0.125f : 0.1875f) + (this.type == 1 ? 0.1875f : 0.0625f);
        float f = xzOffset = meta < 6 && this.type == 0 ? 0.25f : 0.1875f;
        if (meta >= 6 && this.type == 1) {
            height += 0.0625f;
        }
        switch (meta % 6) {
            case 0: {
                return AxisAlignedBB.func_72330_a((double)((float)x + xzOffset), (double)((float)(y + 1) - height), (double)((float)z + xzOffset), (double)((float)(x + 1) - xzOffset), (double)((float)y + 1.0f), (double)((float)(z + 1) - xzOffset));
            }
            case 1: {
                return AxisAlignedBB.func_72330_a((double)((float)x + xzOffset), (double)y, (double)((float)z + xzOffset), (double)((float)(x + 1) - xzOffset), (double)((float)y + height), (double)((float)(z + 1) - xzOffset));
            }
            case 2: {
                return AxisAlignedBB.func_72330_a((double)((float)x + xzOffset), (double)((float)y + xzOffset), (double)((float)(z + 1) - height), (double)((float)(x + 1) - xzOffset), (double)((float)(y + 1) - xzOffset), (double)((float)z + 1.0f));
            }
            case 3: {
                return AxisAlignedBB.func_72330_a((double)((float)x + xzOffset), (double)((float)y + xzOffset), (double)z, (double)((float)(x + 1) - xzOffset), (double)((float)(y + 1) - xzOffset), (double)((float)z + height));
            }
            case 4: {
                return AxisAlignedBB.func_72330_a((double)((float)(x + 1) - height), (double)((float)y + xzOffset), (double)((float)z + xzOffset), (double)((float)x + 1.0f), (double)((float)(y + 1) - xzOffset), (double)((float)(z + 1) - xzOffset));
            }
            case 5: {
                return AxisAlignedBB.func_72330_a((double)x, (double)((float)y + xzOffset), (double)((float)z + xzOffset), (double)((float)x + height), (double)((float)(y + 1) - xzOffset), (double)((float)(z + 1) - xzOffset));
            }
        }
        return null;
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        float xzOffset;
        int meta = access.func_72805_g(x, y, z);
        float height = (meta < 6 ? 0.125f : 0.1875f) + (this.type == 1 ? 0.1875f : 0.0625f);
        float f = xzOffset = meta < 6 && this.type == 0 ? 0.25f : 0.1875f;
        if (meta >= 6 && this.type == 1) {
            height += 0.0625f;
        }
        switch (meta % 6) {
            case 0: {
                this.func_149676_a(xzOffset, 1.0f - height, xzOffset, 1.0f - xzOffset, 1.0f, 1.0f - xzOffset);
                break;
            }
            case 1: {
                this.func_149676_a(xzOffset, 0.0f, xzOffset, 1.0f - xzOffset, height, 1.0f - xzOffset);
                break;
            }
            case 2: {
                this.func_149676_a(xzOffset, xzOffset, 1.0f - height, 1.0f - xzOffset, 1.0f - xzOffset, 1.0f);
                break;
            }
            case 3: {
                this.func_149676_a(xzOffset, xzOffset, 0.0f, 1.0f - xzOffset, 1.0f - xzOffset, height);
                break;
            }
            case 4: {
                this.func_149676_a(1.0f - height, xzOffset, xzOffset, 1.0f, 1.0f - xzOffset, 1.0f - xzOffset);
                break;
            }
            case 5: {
                this.func_149676_a(0.0f, xzOffset, xzOffset, height, 1.0f - xzOffset, 1.0f - xzOffset);
            }
        }
    }

    protected void checkAndDropBlock(World p_149855_1_, int p_149855_2_, int p_149855_3_, int p_149855_4_) {
        if (!this.func_149718_j(p_149855_1_, p_149855_2_, p_149855_3_, p_149855_4_)) {
            this.func_149697_b(p_149855_1_, p_149855_2_, p_149855_3_, p_149855_4_, p_149855_1_.func_72805_g(p_149855_2_, p_149855_3_, p_149855_4_), 0);
            p_149855_1_.func_147468_f(p_149855_2_, p_149855_3_, p_149855_4_);
        }
    }

    public void func_149695_a(World p_149695_1_, int p_149695_2_, int p_149695_3_, int p_149695_4_, Block p_149695_5_) {
        super.func_149695_a(p_149695_1_, p_149695_2_, p_149695_3_, p_149695_4_, p_149695_5_);
        this.checkAndDropBlock(p_149695_1_, p_149695_2_, p_149695_3_, p_149695_4_);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.func_149707_d(world, x, y, z, world.func_72805_g(x, y, z));
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        EnumFacing facing = EnumFacing.func_82600_a((int)side);
        return world.func_147439_a(x - facing.func_82601_c(), y - facing.func_96559_d(), z - facing.func_82599_e()).func_149662_c();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_) {
        return this.icons[p_149691_2_ < 6 ? 0 : 1];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.icons = new IIcon[2];
        if (this.type == 0) {
            this.icons[0] = p_149651_1_.func_94245_a("small_amethyst_bud");
            this.icons[1] = p_149651_1_.func_94245_a("medium_amethyst_bud");
        }
        if (this.type == 1) {
            this.icons[0] = p_149651_1_.func_94245_a("large_amethyst_bud");
            this.icons[1] = p_149651_1_.func_94245_a(this.func_149641_N());
        }
        super.func_149651_a(p_149651_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item p_149666_1_, CreativeTabs p_149666_2_, List p_149666_3_) {
        p_149666_3_.add(new ItemStack(p_149666_1_, 1, 0));
        p_149666_3_.add(new ItemStack(p_149666_1_, 1, 6));
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return RenderIDs.AMETHYST_CLUSTER;
    }

    @Override
    public Class<? extends ItemBlock> getItemBlockClass() {
        return ItemAmethystCluster.class;
    }
}

