/*
 * Decompiled with CFR 0.152.
 */
package me.guichaguri.betterfps;

import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import me.guichaguri.betterfps.BetterFps;
import me.guichaguri.betterfps.BetterMathHelper;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class BetterFpsTransformer
implements IClassTransformer {
    public byte[] transform(String name, String name2, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            if (name.equals("net.minecraft.util.MathHelper") || name.equals("qh")) {
                return this.patchMath(bytes);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bytes;
    }

    private byte[] patchMath(byte[] bytes) throws Exception {
        ClassReader reader;
        String sinOb = "a";
        String sinDeob = "sin";
        String cosOb = "b";
        String cosDeob = "cos";
        BetterMathHelper.loadConfig();
        if (BetterMathHelper.ALGORITHM_NAME.equals("vanilla")) {
            LogManager.getLogger((String)"BetterFps").info("Letting Minecraft use " + BetterMathHelper.displayHelpers.get(BetterMathHelper.ALGORITHM_NAME));
            return bytes;
        }
        LogManager.getLogger((String)"BetterFps").info("Patching Minecraft using " + BetterMathHelper.displayHelpers.get(BetterMathHelper.ALGORITHM_NAME));
        if (BetterFps.LOC == null) {
            reader = new ClassReader("me.guichaguri.betterfps.math." + BetterMathHelper.ALGORITHM_CLASS);
        } else {
            JarFile jar = new JarFile(BetterFps.LOC);
            ZipEntry e = jar.getEntry("me/guichaguri/betterfps/math/" + BetterMathHelper.ALGORITHM_CLASS + ".class");
            reader = new ClassReader(jar.getInputStream(e));
            jar.close();
        }
        ClassNode mathnode = new ClassNode();
        reader.accept((ClassVisitor)mathnode, 0);
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        String className = classNode.name;
        String mathClass = mathnode.name;
        this.patchInit(classNode, mathnode, className, mathClass);
        Iterator methods = classNode.methods.iterator();
        boolean patched = false;
        while (methods.hasNext()) {
            MethodNode method = (MethodNode)methods.next();
            if (!method.desc.equals("(F)F")) continue;
            if (method.name.equals(sinOb) || method.name.equals(sinDeob)) {
                this.patchSin(method, mathnode, className, mathClass);
                patched = true;
                continue;
            }
            if (!method.name.equals(cosOb) && !method.name.equals(cosDeob)) continue;
            this.patchCos(method, mathnode, className, mathClass);
            patched = true;
        }
        if (!patched) {
            return bytes;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void patchInit(ClassNode classNode, ClassNode math, String name, String oldName) {
        for (FieldNode field : math.fields) {
            classNode.fields.add(field);
        }
        for (MethodNode m : math.methods) {
            if (!m.name.equals("<clinit>")) continue;
            MethodNode method = new MethodNode(9, "bfInit", "()V", null, null);
            method.instructions.add(m.instructions);
            for (AbstractInsnNode node : method.instructions.toArray()) {
                if (!(node instanceof FieldInsnNode)) continue;
                FieldInsnNode field = (FieldInsnNode)node;
                if (!field.owner.equals(oldName)) continue;
                field.owner = name;
            }
            classNode.methods.add(method);
        }
    }

    private void patchSin(MethodNode method, ClassNode math, String name, String oldName) {
        method.instructions.clear();
        for (MethodNode original : math.methods) {
            if (!original.name.equals("sin")) continue;
            method.instructions.add(original.instructions);
            for (AbstractInsnNode node : method.instructions.toArray()) {
                if (!(node instanceof FieldInsnNode)) continue;
                FieldInsnNode field = (FieldInsnNode)node;
                if (!field.owner.equals(oldName)) continue;
                field.owner = name;
            }
        }
    }

    private void patchCos(MethodNode method, ClassNode math, String name, String oldName) {
        method.instructions.clear();
        for (MethodNode original : math.methods) {
            if (!original.name.equals("cos")) continue;
            method.instructions.add(original.instructions);
            for (AbstractInsnNode node : method.instructions.toArray()) {
                if (!(node instanceof FieldInsnNode)) continue;
                FieldInsnNode field = (FieldInsnNode)node;
                if (!field.owner.equals(oldName)) continue;
                field.owner = name;
            }
        }
    }
}

