/*
 * Decompiled with CFR 0.152.
 */
package ab.common.item.relic;

import ab.client.core.handler.PlayerItemUsingSound;
import ab.common.core.handler.ConfigABHandler;
import ab.common.core.handler.NetworkHandler;
import ab.common.item.relic.ItemModRelic;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemHornPlenty
extends ItemModRelic {
    public static final String[] dropFewItems = new String[]{"dropFewItems", "func_70628_a"};
    private static final short maxChargeLoot = 16;
    private static final int manaCost = 64000;

    public ItemHornPlenty() {
        super("hornPlenty");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int pos, boolean equipped) {
        super.func_77663_a(stack, world, entity, pos, equipped);
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            short chargeLoot;
            EntityPlayer player = (EntityPlayer)entity;
            short lastChargeLoot = this.getLastChargeLoot(stack);
            if (lastChargeLoot != (chargeLoot = this.getChargeLoot(stack))) {
                this.setLastChargeLoot(stack, chargeLoot);
                NetworkHandler.sendPacketToHornHud((EntityPlayerMP)player, chargeLoot);
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!this.hasChargeLoot(stack) && ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)player, (int)64000, (boolean)false)) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int time) {
        time = this.func_77626_a(stack) - time;
        if (time > 48) {
            if (!player.field_70170_p.field_72995_K && ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)player, (int)64000, (boolean)true)) {
                this.setChargeLoot(stack, (short)16);
                player.field_70170_p.func_72956_a((Entity)player, "random.orb", 1.2f, 4.0f);
            }
            player.func_71034_by();
        } else if (player.field_70170_p.field_72995_K) {
            PlayerItemUsingSound.ClientSoundHandler.playSound(player, "ab:hornPlentyUsing", 2.4f, 2.47f, 19, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showDurabilityBar(ItemStack stack) {
        return this.hasChargeLoot(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getChargeLoot(stack) / 16.0;
    }

    public int func_77626_a(ItemStack stack) {
        return 42000;
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.bow;
    }

    @SubscribeEvent
    public void onPlayerAttack(LivingDropsEvent event) {
        if (event != null && event.source != null && event.source.func_76364_f() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.source.func_76364_f();
            ItemStack horn = null;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof ItemHornPlenty) || !this.hasChargeLoot(stack)) continue;
                horn = stack;
                break;
            }
            if (!player.field_70170_p.field_72995_K && horn != null && this.hasChargeLoot(horn) && player.field_70170_p.field_73012_v.nextInt(100) < 20 && event.entityLiving != null && !(event.entityLiving instanceof IBossDisplayData) && ItemHornPlenty.isVallidEntity(event.entityLiving)) {
                try {
                    EntityLivingBase liv = event.entityLiving;
                    ReflectionHelper.findMethod(EntityLivingBase.class, (Object)liv, (String[])dropFewItems, (Class[])new Class[]{Boolean.TYPE, Integer.TYPE}).invoke((Object)liv, true, (int)((float)event.lootingLevel * 1.5f));
                    this.setChargeLoot(horn, (short)(this.getChargeLoot(horn) - 1));
                    player.field_70170_p.func_72956_a((Entity)player, "random.orb", 1.9f, 0.8f);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setLastChargeLoot(ItemStack stack, short count) {
        ItemNBTHelper.setShort((ItemStack)stack, (String)"lastChargeLoot", (short)count);
    }

    public short getLastChargeLoot(ItemStack stack) {
        return ItemNBTHelper.getShort((ItemStack)stack, (String)"lastChargeLoot", (short)0);
    }

    public void setChargeLoot(ItemStack stack, short count) {
        ItemNBTHelper.setShort((ItemStack)stack, (String)"chargeLoot", (short)count);
    }

    public short getChargeLoot(ItemStack stack) {
        return ItemNBTHelper.getShort((ItemStack)stack, (String)"chargeLoot", (short)0);
    }

    public boolean hasChargeLoot(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"chargeLoot", (int)0) > 0;
    }

    public static boolean isVallidEntity(EntityLivingBase liv) {
        for (String entityName : ConfigABHandler.lockEntityListToHorn) {
            if (!liv.getClass().getSimpleName().equals(entityName)) continue;
            return false;
        }
        return true;
    }
}

