/*
 * Decompiled with CFR 0.152.
 */
package ab.common.item.equipment.armor;

import ab.common.item.equipment.armor.ItemNebulaArmor;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.IManaDiscountArmor;
import vazkii.botania.api.mana.IManaGivingItem;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemNebulaHelm
extends ItemNebulaArmor
implements IManaDiscountArmor,
IManaGivingItem {
    private static final String TAG_COSMIC_FACE = "enableCosmicFace";

    public ItemNebulaHelm() {
        this("nebulaHelm");
    }

    public ItemNebulaHelm(String str) {
        super(0, str);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            this.setCosmicFace(stack, !this.enableCosmicFace(stack));
        } else {
            super.func_77659_a(stack, world, player);
        }
        return stack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        super.func_77624_a(stack, player, list, adv);
        if (!GuiScreen.func_146272_n() && !this.enableCosmicFace(stack)) {
            this.addStringToTooltip(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"ab.nebulaHelm.mask"), list);
        }
    }

    public boolean enableCosmicFace(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_COSMIC_FACE, (boolean)true);
    }

    public void setCosmicFace(ItemStack stack, boolean enable) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_COSMIC_FACE, (boolean)enable);
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (this.hasArmorSet(player)) {
            int food = player.func_71024_bL().func_75116_a();
            if (food > 0 && food < 18 && player.func_70996_bM() && player.field_70173_aa % 80 == 0) {
                player.func_70691_i(1.0f);
            }
            ItemNebulaHelm.dispatchManaExact(stack, player, 2, true);
        }
    }

    public static boolean dispatchManaExact(ItemStack stack, EntityPlayer player, int manaToSend, boolean add) {
        int invSize;
        if (stack == null) {
            return false;
        }
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        IInventory baublesInv = BotaniaAPI.internalHandler.getBaublesInventory(player);
        int size = invSize = inventoryPlayer.func_70302_i_();
        if (baublesInv != null) {
            size += baublesInv.func_70302_i_();
        }
        for (int i = 0; i < size; ++i) {
            IManaItem manaItemSlot;
            int slot;
            boolean useBaubles = i >= invSize;
            Object inv = useBaubles ? baublesInv : inventoryPlayer;
            ItemStack stackInSlot = inv.func_70301_a(slot = i - (useBaubles ? invSize : 0));
            if (stackInSlot == stack || stackInSlot == null || !(stackInSlot.func_77973_b() instanceof IManaItem) || (manaItemSlot = (IManaItem)stackInSlot.func_77973_b()).getMana(stackInSlot) + manaToSend > manaItemSlot.getMaxMana(stackInSlot) || !manaItemSlot.canReceiveManaFromItem(stackInSlot, stack)) continue;
            if (add) {
                manaItemSlot.addMana(stackInSlot, manaToSend);
            }
            if (useBaubles) {
                BotaniaAPI.internalHandler.sendBaubleUpdatePacket(player, slot);
            }
            return true;
        }
        return false;
    }

    public float getDiscount(ItemStack stack, int slot, EntityPlayer player) {
        return this.hasArmorSet(player) ? 0.3f : 0.0f;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        HashMultimap hashMultimap = HashMultimap.create();
        UUID uuid = new UUID(this.func_77658_a().hashCode(), 0L);
        hashMultimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(uuid, "NebulaHelm modifier", 20.0 * (double)(1.0f - (float)this.getDamage(stack) / 1000.0f), 0));
        return hashMultimap;
    }
}

