/*
 * Decompiled with CFR 0.152.
 */
package ab.common.item.equipment;

import ab.AdvancedBotany;
import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.entity.EntityDoppleganger;

public abstract class ItemBauble
extends Item
implements IBauble,
ICosmeticAttachable,
IPhantomInkable {
    public ItemBauble(String name) {
        this.func_77625_d(1);
        this.func_77655_b(name);
        this.func_111206_d("ab:" + name);
        this.func_77637_a(AdvancedBotany.tabAB);
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EntityDoppleganger.isTruePlayer((Entity)par3EntityPlayer)) {
            return par1ItemStack;
        }
        if (this.canEquip(par1ItemStack, (EntityLivingBase)par3EntityPlayer)) {
            InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)par3EntityPlayer);
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                ItemStack stackInSlot;
                if (!baubles.func_94041_b(i, par1ItemStack) || (stackInSlot = baubles.func_70301_a(i)) != null && !((IBauble)stackInSlot.func_77973_b()).canUnequip(stackInSlot, (EntityLivingBase)par3EntityPlayer)) continue;
                if (!par2World.field_72995_K) {
                    baubles.func_70299_a(i, par1ItemStack.func_77946_l());
                    if (!par3EntityPlayer.field_71075_bZ.field_75098_d) {
                        par3EntityPlayer.field_71071_by.func_70299_a(par3EntityPlayer.field_71071_by.field_70461_c, null);
                    }
                }
                if (stackInSlot == null) break;
                ((IBauble)stackInSlot.func_77973_b()).onUnequipped(stackInSlot, (EntityLivingBase)par3EntityPlayer);
                return stackInSlot.func_77946_l();
            }
        }
        return par1ItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (GuiScreen.func_146272_n()) {
            this.addHiddenTooltip(par1ItemStack, par2EntityPlayer, par3List, par4);
        } else {
            this.addStringToTooltip(StatCollector.func_74838_a((String)"botaniamisc.shiftinfo"), par3List);
        }
    }

    public void addHiddenTooltip(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List<String> par3List, boolean par4) {
        ItemStack cosmetic;
        BaubleType type = this.getBaubleType(par1ItemStack);
        this.addStringToTooltip(StatCollector.func_74838_a((String)("botania.baubletype." + type.name().toLowerCase())), par3List);
        String key = RenderHelper.getKeyDisplayString((String)"Baubles Inventory");
        if (key != null) {
            this.addStringToTooltip(StatCollector.func_74838_a((String)"botania.baubletooltip").replaceAll("%key%", key), par3List);
        }
        if ((cosmetic = this.getCosmeticItem(par1ItemStack)) != null) {
            this.addStringToTooltip(String.format(StatCollector.func_74838_a((String)"botaniamisc.hasCosmetic"), cosmetic.func_82833_r()), par3List);
        }
        if (this.hasPhantomInk(par1ItemStack)) {
            this.addStringToTooltip(StatCollector.func_74838_a((String)"botaniamisc.hasPhantomInk"), par3List);
        }
    }

    void addStringToTooltip(String s, List tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    public boolean canEquip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        if (ItemBauble.getLastPlayerHashcode(stack) != player.hashCode()) {
            this.onEquippedOrLoadedIntoWorld(stack, player);
            ItemBauble.setLastPlayerHashcode(stack, player.hashCode());
        }
    }

    public void onEquipped(ItemStack stack, EntityLivingBase player) {
        if (player != null) {
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_72956_a((Entity)player, "botania:equipBauble", 0.1f, 1.3f);
            }
            if (player instanceof EntityPlayer) {
                ((EntityPlayer)player).func_71064_a((StatBase)ModAchievements.baubleWear, 1);
            }
            this.onEquippedOrLoadedIntoWorld(stack, player);
            ItemBauble.setLastPlayerHashcode(stack, player.hashCode());
        }
    }

    public void onEquippedOrLoadedIntoWorld(ItemStack stack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
    }

    public ItemStack getCosmeticItem(ItemStack stack) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)"cosmeticItem", (boolean)true);
        if (cmp == null) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)cmp);
    }

    public void setCosmeticItem(ItemStack stack, ItemStack cosmetic) {
        NBTTagCompound cmp = new NBTTagCompound();
        if (cosmetic != null) {
            cosmetic.func_77955_b(cmp);
        }
        ItemNBTHelper.setCompound((ItemStack)stack, (String)"cosmeticItem", (NBTTagCompound)cmp);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.getContainerItem(stack) != null;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return this.getCosmeticItem(itemStack);
    }

    public boolean func_77630_h(ItemStack p_77630_1_) {
        return false;
    }

    public static UUID getBaubleUUID(ItemStack stack) {
        long most = ItemNBTHelper.getLong((ItemStack)stack, (String)"baubleUUIDMost", (long)0L);
        if (most == 0L) {
            UUID uuid = UUID.randomUUID();
            ItemNBTHelper.setLong((ItemStack)stack, (String)"baubleUUIDMost", (long)uuid.getMostSignificantBits());
            ItemNBTHelper.setLong((ItemStack)stack, (String)"baubleUUIDLeast", (long)uuid.getLeastSignificantBits());
            return ItemBauble.getBaubleUUID(stack);
        }
        long least = ItemNBTHelper.getLong((ItemStack)stack, (String)"baubleUUIDLeast", (long)0L);
        return new UUID(most, least);
    }

    public static int getLastPlayerHashcode(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"playerHashcode", (int)0);
    }

    public static void setLastPlayerHashcode(ItemStack stack, int hash) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)"playerHashcode", (int)hash);
    }

    public boolean hasPhantomInk(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"phantomInk", (boolean)false);
    }

    public void setPhantomInk(ItemStack stack, boolean ink) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"phantomInk", (boolean)ink);
    }
}

