/*
 * Decompiled with CFR 0.152.
 */
package ab.common.entity;

import ab.common.item.equipment.ItemSprawlRod;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import vazkii.botania.common.Botania;
import vazkii.botania.common.item.ItemGrassSeeds;

public class EntitySeed
extends EntityThrowable {
    public EntitySeed(World world) {
        super(world);
    }

    public EntitySeed(World world, EntityPlayer e) {
        super(world, (EntityLivingBase)e);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(27, (Object)new ItemStack(Blocks.field_150350_a));
        this.field_70180_af.func_75682_a(28, (Object)1);
        this.field_70180_af.func_75682_a(29, (Object)"");
        this.field_70180_af.func_82708_h(27);
        this.field_70180_af.func_82708_h(28);
        this.field_70180_af.func_82708_h(29);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa >= 240) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            float m = 0.02f;
            float f1 = 4.0f / ((float)this.getRadius() / 20.0f);
            float size = 1.0f + (float)this.getRadius() / 12.0f;
            for (int i = 0; i < 5; ++i) {
                double posX = this.field_70165_t + (Math.random() - 0.5) / (double)f1;
                double posY = this.field_70163_u + (Math.random() - 0.5) / (double)f1;
                double posZ = this.field_70161_v + (Math.random() - 0.5) / (double)f1;
                float mx = (float)(Math.random() - 0.5) * m;
                float my = (float)(Math.random() - 0.5) * m;
                float mz = (float)(Math.random() - 0.5) * m;
                Color color = ItemSprawlRod.getSeedColor(this.getSeed());
                Botania.proxy.wispFX(this.field_70170_p, posX, posY, posZ, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)((double)(0.0625f * size) + Math.random() * (double)0.12f), mx, my, mz, 0.5f);
            }
        }
    }

    public int getRadius() {
        return this.field_70180_af.func_75679_c(28);
    }

    public void setRadius(int rad) {
        this.field_70180_af.func_75692_b(28, (Object)rad);
    }

    public ItemStack getSeed() {
        return this.field_70180_af.func_82710_f(27);
    }

    public void setSeed(ItemStack stack) {
        stack.field_77994_a = 1;
        this.field_70180_af.func_75692_b(27, (Object)(stack == null ? new ItemStack(Blocks.field_150350_a) : stack));
    }

    public String getAttacker() {
        return this.field_70180_af.func_75681_e(29);
    }

    public void setAttacker(String str) {
        this.field_70180_af.func_75692_b(29, (Object)str);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float help, float me, int please) {
    }

    protected float func_70185_h() {
        return 0.025f;
    }

    protected void func_70184_a(MovingObjectPosition mov) {
        Block block = this.field_70170_p.func_147439_a(mov.field_72311_b, mov.field_72312_c, mov.field_72309_d);
        EntityPlayer player = this.field_70170_p.func_72924_a(this.getAttacker());
        if (block != null && mov.field_72308_g == null) {
            if (block instanceof BlockBush || block instanceof BlockLeaves || player == null) {
                return;
            }
            ItemStack seed = this.getSeed();
            if (seed != null && seed.func_77973_b() instanceof ItemGrassSeeds) {
                ItemGrassSeeds itemSeed = (ItemGrassSeeds)seed.func_77973_b();
                for (int i = 0; i < this.getRadius(); ++i) {
                    for (int k = 0; k < this.getRadius(); ++k) {
                        int posX = mov.field_72311_b + i - this.getRadius() / 2;
                        int posY = mov.field_72312_c;
                        int posZ = mov.field_72309_d + k - this.getRadius() / 2;
                        int j = posY;
                        if (this.isTopBlock(posX, posY - 1, posZ)) {
                            j = Math.max(0, j - 20);
                        }
                        while (!this.isTopBlock(posX, j, posZ) && Math.abs(j - posY) <= 40) {
                            ++j;
                        }
                        posY = j;
                        if (!this.field_70170_p.field_72995_K && this.isDirt(posX, posY, posZ)) {
                            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(posX, posY, posZ, this.field_70170_p, this.field_70170_p.func_147439_a(posX, posY, posZ), this.field_70170_p.func_72805_g(posX, posY, posZ), player);
                            MinecraftForge.EVENT_BUS.post((Event)event);
                            if (event.isCanceled()) continue;
                            itemSeed.func_77648_a(seed.func_77946_l(), player, this.field_70170_p, posX, posY, posZ, mov.field_72310_e, 0.0f, 0.0f, 0.0f);
                            continue;
                        }
                        if (!(Math.random() < (double)0.15f) && this.getRadius() >= 3 || !this.isDirt(posX, posY, posZ)) continue;
                        this.spawnGrowParticle(posX, posY, posZ);
                    }
                }
            }
            this.func_70106_y();
        }
    }

    public void func_70037_a(NBTTagCompound nbtt) {
        super.func_70037_a(nbtt);
        this.field_70173_aa = nbtt.func_74762_e("ticks");
        this.setAttacker(nbtt.func_74779_i("attacker"));
        NBTTagCompound stackCmp = nbtt.func_74775_l("seedStack");
        this.setSeed(ItemStack.func_77949_a((NBTTagCompound)stackCmp));
        this.setRadius(nbtt.func_74762_e("radius"));
    }

    public void func_70014_b(NBTTagCompound nbtt) {
        super.func_70014_b(nbtt);
        nbtt.func_74768_a("ticks", this.field_70173_aa);
        nbtt.func_74778_a("attacker", this.getAttacker());
        ItemStack stack = this.getSeed();
        NBTTagCompound stackNbt = new NBTTagCompound();
        if (stack != null) {
            stack.func_77955_b(stackNbt);
        }
        nbtt.func_74768_a("radius", this.getRadius());
        nbtt.func_74782_a("seedStack", (NBTBase)stackNbt);
    }

    private void spawnGrowParticle(int posX, int posY, int posZ) {
        for (int i = 0; i < 50; ++i) {
            double x = (Math.random() - 0.5) * 3.0;
            double y = Math.random() - 0.5 + 1.0;
            double z = (Math.random() - 0.5) * 3.0;
            float velMul = 0.025f;
            Color color = ItemSprawlRod.getSeedColor(this.getSeed());
            Botania.proxy.wispFX(this.field_70170_p, (double)posX + 0.5 + x, (double)posY + 0.5 + y, (double)posZ + 0.5 + z, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)Math.random() * 0.15f + 0.15f, (float)(-x) * velMul, (float)(-y) * velMul, (float)(-z) * velMul);
        }
    }

    private boolean isDirt(int posX, int posY, int posZ) {
        return this.field_70170_p.func_147439_a(posX, posY, posZ) == Blocks.field_150346_d || this.field_70170_p.func_147439_a(posX, posY, posZ) == Blocks.field_150349_c;
    }

    private boolean isTopBlock(int posX, int posY, int posZ) {
        return this.field_70170_p.func_147439_a(posX, posY + 1, posZ).func_149688_o() == Material.field_151579_a || this.field_70170_p.func_147439_a(posX, posY + 1, posZ) instanceof BlockBush;
    }
}

