/*
 * Decompiled with CFR 0.152.
 */
package ab.common.block.tile;

import ab.api.AdvancedBotanyAPI;
import ab.api.recipe.RecipeAdvancedPlate;
import ab.common.block.tile.TileInventory;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.Botania;

public class TileNidavellirForge
extends TileInventory
implements ISparkAttachable,
ISidedInventory {
    private int mana;
    public int manaToGet;
    private RecipeAdvancedPlate currentRecipe;
    private int recipeID;
    public boolean requestUpdate;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateServer();
        } else {
            this.updateClient();
        }
        ISparkEntity spark = this.getAttachedSpark();
        if (spark != null) {
            List sparkEntities = SparkHelper.getSparksAround((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5));
            for (ISparkEntity otherSpark : sparkEntities) {
                if (spark == otherSpark || otherSpark.getAttachedTile() == null || !(otherSpark.getAttachedTile() instanceof IManaPool)) continue;
                otherSpark.registerTransfer(spark);
            }
        }
    }

    private void updateServer() {
        if (this.requestUpdate) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        }
        boolean hasUpdate = false;
        List items = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)));
        for (EntityItem item : items) {
            if (item.func_92059_d() == null || item.field_70128_L) continue;
            ItemStack stack = item.func_92059_d();
            int splitCount = this.addItemStack(stack);
            stack.field_77994_a -= splitCount;
            if (stack.field_77994_a <= 0) {
                item.func_70106_y();
            }
            if (splitCount <= 0) break;
            hasUpdate = true;
            break;
        }
        int wasManaToGet = this.manaToGet;
        boolean hasCraft = false;
        int recipeID = 0;
        for (RecipeAdvancedPlate recipe : AdvancedBotanyAPI.advancedPlateRecipes) {
            if (recipe.matches(this)) {
                this.recipeID = recipeID;
                if (this.mana > 0 && this.isFull()) {
                    ItemStack output = recipe.getOutput().func_77946_l();
                    this.recieveMana(-recipe.getManaUsage());
                    this.manaToGet = 0;
                    for (int i = 1; i < this.func_70302_i_(); ++i) {
                        if (this.func_70301_a((int)i).field_77994_a > 1) {
                            --this.func_70301_a((int)i).field_77994_a;
                            continue;
                        }
                        this.func_70299_a(i, null);
                    }
                    if (this.func_70301_a(0) != null) {
                        ++this.func_70301_a((int)0).field_77994_a;
                    } else {
                        this.func_70299_a(0, output);
                    }
                    hasUpdate = true;
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "botania:terrasteelCraft", 1.0f, 2.0f);
                    break;
                }
                if (this.func_70301_a(0) == null) {
                    this.manaToGet = recipe.getManaUsage();
                    this.currentRecipe = recipe;
                    hasCraft = true;
                    break;
                }
                if (TileNidavellirForge.isItemEqual(recipe.getOutput(), this.func_70301_a(0)) && this.func_70301_a((int)0).field_77994_a < recipe.getOutput().func_77976_d()) {
                    this.manaToGet = recipe.getManaUsage();
                    this.currentRecipe = recipe;
                    hasCraft = true;
                    break;
                }
            }
            ++recipeID;
        }
        if (!hasCraft) {
            this.currentRecipe = null;
            this.mana = 0;
            this.manaToGet = 0;
        }
        if (this.manaToGet != wasManaToGet) {
            hasUpdate = true;
        }
        this.requestUpdate = hasUpdate;
    }

    private void updateClient() {
        if (this.mana > 0) {
            double worldTime = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
            float indetY = (float)(Math.sin((worldTime += (double)new Random(this.field_145851_c ^ this.field_145848_d ^ this.field_145849_e).nextInt(360)) / 18.0) / 24.0);
            float ticks = 100.0f * (float)this.getCurrentMana() / (float)this.manaToGet;
            int totalSpiritCount = 3;
            double tickIncrement = 360.0 / (double)totalSpiritCount;
            int speed = 5;
            double wticks = (double)(ticks * (float)speed) - tickIncrement;
            double r = Math.sin((double)(ticks - 100.0f) / 10.0) * 0.5;
            double g = Math.sin(wticks * Math.PI / 180.0 * 0.55);
            float size = 0.4f;
            for (int i = 0; i < totalSpiritCount; ++i) {
                double x = (double)this.field_145851_c + Math.sin(wticks * Math.PI / 180.0) * r + 0.5;
                double y = (double)((float)this.field_145848_d - indetY) + 0.85 + Math.abs(r) * 0.7;
                double z = (double)this.field_145849_e + Math.cos(wticks * Math.PI / 180.0) * r + 0.5;
                wticks += tickIncrement;
                int color = 2411744;
                if (this.currentRecipe != null) {
                    color = this.currentRecipe.getColor();
                }
                float[] hsb = Color.RGBtoHSB(color & 0xFF, color >> 8 & 0xFF, color >> 16 & 0xFF, null);
                int color1 = Color.HSBtoRGB(hsb[0], hsb[1], ticks / 100.0f);
                float[] colorsfx = new float[]{(float)(color1 & 0xFF) / 255.0f, (float)(color1 >> 8 & 0xFF) / 255.0f, (float)(color1 >> 16 & 0xFF) / 255.0f};
                Botania.proxy.wispFX(this.field_145850_b, x, y, z, colorsfx[0], colorsfx[1], colorsfx[2], 0.85f * size, (float)g * 0.05f, 0.25f);
                Botania.proxy.wispFX(this.field_145850_b, x, y, z, colorsfx[0], colorsfx[1], colorsfx[2], (float)Math.random() * 0.1f + 0.1f * size, (float)(Math.random() - 0.5) * 0.05f, (float)(Math.random() - 0.5) * 0.05f, (float)(Math.random() - 0.5) * 0.05f, 0.9f);
                if (ticks != 100.0f) continue;
                for (int j = 0; j < 12; ++j) {
                    Botania.proxy.wispFX(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.1 - (double)indetY, (double)this.field_145849_e + 0.5, colorsfx[0], colorsfx[1], colorsfx[2], (float)Math.random() * 0.15f + 0.15f * size, (float)(Math.random() - 0.5) * 0.125f * size, (float)(Math.random() - 0.5) * 0.125f * size, (float)(Math.random() - 0.5) * 0.125f * size, 0.8f);
                }
            }
        }
    }

    public static boolean isItemEqual(ItemStack stack, ItemStack stack1) {
        return stack.func_77969_a(stack1) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stack1);
    }

    private int addItemStack(ItemStack stack) {
        for (int i = 1; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) {
                ItemStack stackToAdd = stack.func_77946_l();
                this.func_70299_a(i, stackToAdd);
                return stack.field_77994_a;
            }
            if (!TileNidavellirForge.isItemEqual(stack, this.func_70301_a(i)) || this.func_70301_a((int)i).field_77994_a >= stack.func_77976_d()) continue;
            int count = Math.min(stack.field_77994_a, stack.func_77976_d() - this.func_70301_a((int)i).field_77994_a);
            this.func_70301_a((int)i).field_77994_a += count;
            return count;
        }
        return 0;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound cmp) {
        super.writeCustomNBT(cmp);
        cmp.func_74768_a("mana", this.mana);
        cmp.func_74768_a("manaToGet", this.manaToGet);
        cmp.func_74757_a("requestUpdate", this.requestUpdate);
        cmp.func_74768_a("recipeID", this.currentRecipe == null ? -1 : this.recipeID);
    }

    @Override
    public void readCustomNBT(NBTTagCompound cmp) {
        super.readCustomNBT(cmp);
        this.mana = cmp.func_74762_e("mana");
        this.manaToGet = cmp.func_74762_e("manaToGet");
        this.requestUpdate = cmp.func_74767_n("requestUpdate");
        int recipeID = cmp.func_74762_e("recipeID");
        this.currentRecipe = recipeID == -1 ? null : AdvancedBotanyAPI.advancedPlateRecipes.get(recipeID);
    }

    public int func_70302_i_() {
        return 4;
    }

    public String func_145825_b() {
        return "tileAdvancedPlate";
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public boolean isFull() {
        return this.mana >= this.manaToGet;
    }

    public void recieveMana(int mana) {
        this.mana = Math.min(this.mana + mana, this.manaToGet);
    }

    public boolean canRecieveManaFromBursts() {
        return !this.isFull();
    }

    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    public void attachSpark(ISparkEntity entity) {
    }

    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_72872_a(ISparkEntity.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1)));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return this.isFull();
    }

    public int getAvailableSpaceForMana() {
        return Math.max(0, this.manaToGet - this.getCurrentMana());
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        for (int i = 1; i < this.func_70302_i_(); ++i) {
            ItemStack slotStack = this.func_70301_a(i);
            if (slotStack == null || slotStack.field_77994_a != slotStack.func_77976_d() || !TileNidavellirForge.isItemEqual(stack, slotStack)) continue;
            return false;
        }
        return side == 1 && slot != 0;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return side == 0 && slot == 0 || side != 0 && side != 1 && slot != 0;
    }
}

