/*
 * Decompiled with CFR 0.152.
 */
package ab.common.block.tile;

import ab.common.core.handler.ConfigABHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILensEffect;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.IManaSpreader;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.common.block.tile.mana.TileSpreader;
import vazkii.botania.common.entity.EntityManaBurst;

public class TileABSpreader
extends TileSpreader {
    protected boolean requestsClientUpdate = false;
    protected int knownMana = -1;
    protected IManaReceiver receiver = null;

    public void readCustomNBT(NBTTagCompound cmp) {
        super.readCustomNBT(cmp);
        this.requestsClientUpdate = cmp.func_74767_n("requestUpdate");
        if (cmp.func_74764_b("knownMana")) {
            this.knownMana = cmp.func_74762_e("knownMana");
        }
        if (this.requestsClientUpdate && this.field_145850_b != null) {
            TileEntity tile;
            int x = cmp.func_74762_e("forceClientBindingX");
            int y = cmp.func_74762_e("forceClientBindingY");
            int z = cmp.func_74762_e("forceClientBindingZ");
            this.receiver = y != -1 ? ((tile = this.field_145850_b.func_147438_o(x, y, z)) instanceof IManaReceiver ? (IManaReceiver)tile : null) : null;
        }
    }

    public EntityManaBurst getBurst(boolean fake) {
        EntityManaBurst burst = new EntityManaBurst((IManaSpreader)this, fake);
        int maxMana = ConfigABHandler.spreaderBurstMana;
        int color = 13489177;
        int ticksBeforeManaLoss = 35;
        float manaLossPerTick = (float)ConfigABHandler.spreaderBurstMana / 4.5f;
        float motionModifier = 2.5f;
        float gravity = 0.0f;
        BurstProperties props = new BurstProperties(maxMana, ticksBeforeManaLoss, manaLossPerTick, gravity, motionModifier, color);
        ItemStack lens = this.func_70301_a(0);
        if (lens != null && lens.func_77973_b() instanceof ILensEffect) {
            ((ILensEffect)lens.func_77973_b()).apply(lens, props);
        }
        burst.setSourceLens(lens);
        if (this.getCurrentMana() >= props.maxMana || fake) {
            burst.setColor(props.color);
            burst.setMana(props.maxMana);
            burst.setStartingMana(props.maxMana);
            burst.setMinManaLoss(props.ticksBeforeManaLoss);
            burst.setManaLossPerTick(props.manaLossPerTick);
            burst.setGravity(props.gravity);
            burst.setMotion(burst.field_70159_w * (double)props.motionModifier, burst.field_70181_x * (double)props.motionModifier, burst.field_70179_y * (double)props.motionModifier);
            return burst;
        }
        return null;
    }

    public void renderHUD(Minecraft mc, ScaledResolution res) {
        String name = StatCollector.func_74838_a((String)"tile.advancedSpreader.name");
        int color = 13489177;
        HUDHandler.drawSimpleManaHUD((int)color, (int)this.knownMana, (int)this.getMaxMana(), (String)name, (ScaledResolution)res);
        ItemStack lens = this.func_70301_a(0);
        if (lens != null) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            String lensName = lens.func_82833_r();
            int width = 16 + mc.field_71466_p.func_78256_a(lensName) / 2;
            int x = res.func_78326_a() / 2 - width;
            int y = res.func_78328_b() / 2 + 50;
            mc.field_71466_p.func_78261_a(lensName, x + 20, y + 5, color);
            RenderHelper.func_74520_c();
            RenderItem.getInstance().func_82406_b(mc.field_71466_p, mc.field_71446_o, lens, x, y);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3042);
        }
        if (this.receiver != null) {
            TileEntity receiverTile = (TileEntity)this.receiver;
            ItemStack recieverStack = new ItemStack(this.field_145850_b.func_147439_a(receiverTile.field_145851_c, receiverTile.field_145848_d, receiverTile.field_145849_e), 1, receiverTile.func_145832_p());
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (recieverStack != null && recieverStack.func_77973_b() != null) {
                String stackName = recieverStack.func_82833_r();
                int width = 16 + mc.field_71466_p.func_78256_a(stackName) / 2;
                int x = res.func_78326_a() / 2 - width;
                int y = res.func_78328_b() / 2 + 30;
                mc.field_71466_p.func_78261_a(stackName, x + 20, y + 5, color);
                RenderHelper.func_74520_c();
                RenderItem.getInstance().func_82406_b(mc.field_71466_p, mc.field_71446_o, recieverStack, x, y);
                RenderHelper.func_74518_a();
            }
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3042);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public int getMaxMana() {
        return ConfigABHandler.spreaderMaxMana;
    }
}

